% DataViewFileSpec - Specifies a file to be processed, including filename matching and parsing options
%
% DataViewFileSpec Properties:
%    container       - The type of container (e.g. session)
%    analysisFilter 
%    filter         
%    zipMember      
%    match           - If multiple file matches are encountered, which file to choose. Default is first
%    format          - The expected data file format, default is auto-detect
%    formatOptions  
%    processFiles    - Set to false to skip file reading, and return file attributes instead
%    columns        
%
% DataViewFileSpec Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DataViewFileSpec < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'container', 'analysisFilter', 'filter', 'zipMember', 'match', 'format', 'formatOptions', 'processFiles', 'columns' }, ...
            { 'container', 'analysisFilter', 'filter', 'zipMember', 'match', 'format', 'formatOptions', 'processFiles', 'columns' });
    end
    properties(Dependent)
        container
        analysisFilter
        filter
        zipMember
        match
        format
        formatOptions
        processFiles
        columns
    end
    methods
        function obj = DataViewFileSpec(varargin)
            obj@flywheel.ModelBase(flywheel.model.DataViewFileSpec.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'container', []);
                addParameter(p, 'analysisFilter', []);
                addParameter(p, 'filter', []);
                addParameter(p, 'zipMember', []);
                addParameter(p, 'match', []);
                addParameter(p, 'format', []);
                addParameter(p, 'formatOptions', []);
                addParameter(p, 'processFiles', []);
                addParameter(p, 'columns', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.container)
                    obj.props_('container') = p.Results.container;
                end
                if ~isempty(p.Results.analysisFilter)
                    obj.props_('analysisFilter') = p.Results.analysisFilter;
                end
                if ~isempty(p.Results.filter)
                    obj.props_('filter') = p.Results.filter;
                end
                if ~isempty(p.Results.zipMember)
                    obj.props_('zipMember') = p.Results.zipMember;
                end
                if ~isempty(p.Results.match)
                    obj.props_('match') = p.Results.match;
                end
                if ~isempty(p.Results.format)
                    obj.props_('format') = p.Results.format;
                end
                if ~isempty(p.Results.formatOptions)
                    obj.props_('formatOptions') = p.Results.formatOptions;
                end
                if ~isempty(p.Results.processFiles)
                    obj.props_('processFiles') = p.Results.processFiles;
                end
                if ~isempty(p.Results.columns)
                    obj.props_('columns') = p.Results.columns;
                end
            end
        end
        function result = get.container(obj)
            if ismethod(obj, 'get_container')
                result = obj.get_container();
            else
                if isKey(obj.props_, 'container')
                    result = obj.props_('container');
                else
                    result = [];
                end
            end
        end
        function obj = set.container(obj, value)
            obj.props_('container') = value;
        end
        function result = get.analysisFilter(obj)
            if ismethod(obj, 'get_analysisFilter')
                result = obj.get_analysisFilter();
            else
                if isKey(obj.props_, 'analysisFilter')
                    result = obj.props_('analysisFilter');
                else
                    result = [];
                end
            end
        end
        function obj = set.analysisFilter(obj, value)
            obj.props_('analysisFilter') = value;
        end
        function result = get.filter(obj)
            if ismethod(obj, 'get_filter')
                result = obj.get_filter();
            else
                if isKey(obj.props_, 'filter')
                    result = obj.props_('filter');
                else
                    result = [];
                end
            end
        end
        function obj = set.filter(obj, value)
            obj.props_('filter') = value;
        end
        function result = get.zipMember(obj)
            if ismethod(obj, 'get_zipMember')
                result = obj.get_zipMember();
            else
                if isKey(obj.props_, 'zipMember')
                    result = obj.props_('zipMember');
                else
                    result = [];
                end
            end
        end
        function obj = set.zipMember(obj, value)
            obj.props_('zipMember') = value;
        end
        function result = get.match(obj)
            if ismethod(obj, 'get_match')
                result = obj.get_match();
            else
                if isKey(obj.props_, 'match')
                    result = obj.props_('match');
                else
                    result = [];
                end
            end
        end
        function obj = set.match(obj, value)
            obj.props_('match') = value;
        end
        function result = get.format(obj)
            if ismethod(obj, 'get_format')
                result = obj.get_format();
            else
                if isKey(obj.props_, 'format')
                    result = obj.props_('format');
                else
                    result = [];
                end
            end
        end
        function obj = set.format(obj, value)
            obj.props_('format') = value;
        end
        function result = get.formatOptions(obj)
            if ismethod(obj, 'get_formatOptions')
                result = obj.get_formatOptions();
            else
                if isKey(obj.props_, 'formatOptions')
                    result = obj.props_('formatOptions');
                else
                    result = [];
                end
            end
        end
        function obj = set.formatOptions(obj, value)
            obj.props_('formatOptions') = value;
        end
        function result = get.processFiles(obj)
            if ismethod(obj, 'get_processFiles')
                result = obj.get_processFiles();
            else
                if isKey(obj.props_, 'processFiles')
                    result = obj.props_('processFiles');
                else
                    result = [];
                end
            end
        end
        function obj = set.processFiles(obj, value)
            obj.props_('processFiles') = value;
        end
        function result = get.columns(obj)
            if ismethod(obj, 'get_columns')
                result = obj.get_columns();
            else
                if isKey(obj.props_, 'columns')
                    result = obj.props_('columns');
                else
                    result = [];
                end
            end
        end
        function obj = set.columns(obj, value)
            obj.props_('columns') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'container')
                result('container') = flywheel.ModelBase.serializeValue(obj.props_('container'), 'char');
            end
            if isKey(obj.props_, 'analysisFilter')
                result('analysisFilter') = obj.props_('analysisFilter').toJson();
            end
            if isKey(obj.props_, 'filter')
                result('filter') = obj.props_('filter').toJson();
            end
            if isKey(obj.props_, 'zipMember')
                result('zipMember') = obj.props_('zipMember').toJson();
            end
            if isKey(obj.props_, 'match')
                result('match') = flywheel.ModelBase.serializeValue(obj.props_('match'), 'char');
            end
            if isKey(obj.props_, 'format')
                result('format') = flywheel.ModelBase.serializeValue(obj.props_('format'), 'char');
            end
            if isKey(obj.props_, 'formatOptions')
                result('formatOptions') = flywheel.ModelBase.serializeValue(obj.props_('formatOptions'), 'containers.Map');
            end
            if isKey(obj.props_, 'processFiles')
                result('processFiles') = flywheel.ModelBase.serializeValue(obj.props_('processFiles'), 'logical');
            end
            if isKey(obj.props_, 'columns')
                result('columns') = flywheel.ModelBase.cellmap(@toJson, obj.props_('columns'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'container')
                result.container = obj.props_('container');
            else
                result.container = [];
            end
            if isKey(obj.props_, 'analysisFilter')
                result.analysisFilter = struct(obj.props_('analysisFilter'));
            else
                result.analysisFilter = [];
            end
            if isKey(obj.props_, 'filter')
                result.filter = struct(obj.props_('filter'));
            else
                result.filter = [];
            end
            if isKey(obj.props_, 'zipMember')
                result.zipMember = struct(obj.props_('zipMember'));
            else
                result.zipMember = [];
            end
            if isKey(obj.props_, 'match')
                result.match = obj.props_('match');
            else
                result.match = [];
            end
            if isKey(obj.props_, 'format')
                result.format = obj.props_('format');
            else
                result.format = [];
            end
            if isKey(obj.props_, 'formatOptions')
                result.formatOptions = obj.props_('formatOptions');
            else
                result.formatOptions = [];
            end
            if isKey(obj.props_, 'processFiles')
                result.processFiles = obj.props_('processFiles');
            else
                result.processFiles = [];
            end
            if isKey(obj.props_, 'columns')
                result.columns = flywheel.ModelBase.cellmap(@struct, obj.props_('columns'));
            else
                result.columns = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'container')
                    propList.container = obj.props_('container');
                else
                    propList.container = [];
                end
                if isKey(obj.props_, 'analysisFilter')
                    propList.analysisFilter = obj.props_('analysisFilter');
                else
                    propList.analysisFilter = [];
                end
                if isKey(obj.props_, 'filter')
                    propList.filter = obj.props_('filter');
                else
                    propList.filter = [];
                end
                if isKey(obj.props_, 'zipMember')
                    propList.zipMember = obj.props_('zipMember');
                else
                    propList.zipMember = [];
                end
                if isKey(obj.props_, 'match')
                    propList.match = obj.props_('match');
                else
                    propList.match = [];
                end
                if isKey(obj.props_, 'format')
                    propList.format = obj.props_('format');
                else
                    propList.format = [];
                end
                if isKey(obj.props_, 'formatOptions')
                    propList.formatOptions = obj.props_('formatOptions');
                else
                    propList.formatOptions = [];
                end
                if isKey(obj.props_, 'processFiles')
                    propList.processFiles = obj.props_('processFiles');
                else
                    propList.processFiles = [];
                end
                if isKey(obj.props_, 'columns')
                    propList.columns = obj.props_('columns');
                else
                    propList.columns = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DataViewFileSpec;
            if isfield(json, 'container')
                obj.props_('container') = flywheel.ModelBase.deserializeValue(json.container, 'char');
            end
            if isfield(json, 'analysisFilter')
                obj.props_('analysisFilter') = flywheel.model.DataViewAnalysisFilterSpec.fromJson(json.analysisFilter, context);
            end
            if isfield(json, 'filter')
                obj.props_('filter') = flywheel.model.DataViewNameFilterSpec.fromJson(json.filter, context);
            end
            if isfield(json, 'zipMember')
                obj.props_('zipMember') = flywheel.model.DataViewZipFilterSpec.fromJson(json.zipMember, context);
            end
            if isfield(json, 'match')
                obj.props_('match') = flywheel.ModelBase.deserializeValue(json.match, 'char');
            end
            if isfield(json, 'format')
                obj.props_('format') = flywheel.ModelBase.deserializeValue(json.format, 'char');
            end
            if isfield(json, 'formatOptions')
                obj.props_('formatOptions') = flywheel.ModelBase.deserializeValue(json.formatOptions, 'containers.Map');
            end
            if isfield(json, 'processFiles')
                obj.props_('processFiles') = flywheel.ModelBase.deserializeValue(json.processFiles, 'logical');
            end
            if isfield(json, 'columns')
                obj.props_('columns') = flywheel.ModelBase.cellmap(@(x) flywheel.model.DataViewColumnSpec.fromJson(x, context), json.columns);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DataViewFileSpec')
                    obj = flywheel.model.DataViewFileSpec(obj);
                end
                if isKey(obj.props_, 'container')
                end
                if isKey(obj.props_, 'analysisFilter')
                    obj.props_('analysisFilter') =  flywheel.model.DataViewAnalysisFilterSpec.ensureIsInstance(obj.props_('analysisFilter'));
                end
                if isKey(obj.props_, 'filter')
                    obj.props_('filter') =  flywheel.model.DataViewNameFilterSpec.ensureIsInstance(obj.props_('filter'));
                end
                if isKey(obj.props_, 'zipMember')
                    obj.props_('zipMember') =  flywheel.model.DataViewZipFilterSpec.ensureIsInstance(obj.props_('zipMember'));
                end
                if isKey(obj.props_, 'match')
                end
                if isKey(obj.props_, 'format')
                end
                if isKey(obj.props_, 'formatOptions')
                end
                if isKey(obj.props_, 'processFiles')
                end
                if isKey(obj.props_, 'columns')
                    obj.props_('columns') = flywheel.ModelBase.cellmap(@flywheel.model.DataViewColumnSpec.ensureIsInstance, obj.props_('columns'));
                end
            end
        end
    end
end
