% DataViewGroupBy
%
% DataViewGroupBy Properties:
%    columns 
%
% DataViewGroupBy Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DataViewGroupBy < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'columns' }, ...
            { 'columns' });
    end
    properties(Dependent)
        columns
    end
    methods
        function obj = DataViewGroupBy(varargin)
            obj@flywheel.ModelBase(flywheel.model.DataViewGroupBy.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'columns', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.columns)
                    obj.props_('columns') = p.Results.columns;
                end
            end
        end
        function result = get.columns(obj)
            if ismethod(obj, 'get_columns')
                result = obj.get_columns();
            else
                if isKey(obj.props_, 'columns')
                    result = obj.props_('columns');
                else
                    result = [];
                end
            end
        end
        function obj = set.columns(obj, value)
            obj.props_('columns') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'columns')
                result('columns') = flywheel.ModelBase.cellmap(@toJson, obj.props_('columns'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'columns')
                result.columns = flywheel.ModelBase.cellmap(@struct, obj.props_('columns'));
            else
                result.columns = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'columns')
                    propList.columns = obj.props_('columns');
                else
                    propList.columns = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DataViewGroupBy;
            if isfield(json, 'columns')
                obj.props_('columns') = flywheel.ModelBase.cellmap(@(x) flywheel.model.DataViewGroupByColumn.fromJson(x, context), json.columns);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DataViewGroupBy')
                    obj = flywheel.model.DataViewGroupBy(obj);
                end
                if isKey(obj.props_, 'columns')
                    obj.props_('columns') = flywheel.ModelBase.cellmap(@flywheel.model.DataViewGroupByColumn.ensureIsInstance, obj.props_('columns'));
                end
            end
        end
    end
end
