% DataViewGroupByColumn
%
% DataViewGroupByColumn Properties:
%    src  - The source property in the format of {container}.{field}
%    dst  - The optional destination property name
%
% DataViewGroupByColumn Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DataViewGroupByColumn < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'src', 'dst' }, ...
            { 'src', 'dst' });
    end
    properties(Dependent)
        src
        dst
    end
    methods
        function obj = DataViewGroupByColumn(varargin)
            obj@flywheel.ModelBase(flywheel.model.DataViewGroupByColumn.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'src', []);
                addParameter(p, 'dst', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.src)
                    obj.props_('src') = p.Results.src;
                end
                if ~isempty(p.Results.dst)
                    obj.props_('dst') = p.Results.dst;
                end
            end
        end
        function result = get.src(obj)
            if ismethod(obj, 'get_src')
                result = obj.get_src();
            else
                if isKey(obj.props_, 'src')
                    result = obj.props_('src');
                else
                    result = [];
                end
            end
        end
        function obj = set.src(obj, value)
            obj.props_('src') = value;
        end
        function result = get.dst(obj)
            if ismethod(obj, 'get_dst')
                result = obj.get_dst();
            else
                if isKey(obj.props_, 'dst')
                    result = obj.props_('dst');
                else
                    result = [];
                end
            end
        end
        function obj = set.dst(obj, value)
            obj.props_('dst') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'src')
                result('src') = flywheel.ModelBase.serializeValue(obj.props_('src'), 'char');
            end
            if isKey(obj.props_, 'dst')
                result('dst') = flywheel.ModelBase.serializeValue(obj.props_('dst'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'src')
                result.src = obj.props_('src');
            else
                result.src = [];
            end
            if isKey(obj.props_, 'dst')
                result.dst = obj.props_('dst');
            else
                result.dst = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'src')
                    propList.src = obj.props_('src');
                else
                    propList.src = [];
                end
                if isKey(obj.props_, 'dst')
                    propList.dst = obj.props_('dst');
                else
                    propList.dst = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DataViewGroupByColumn;
            if isfield(json, 'src')
                obj.props_('src') = flywheel.ModelBase.deserializeValue(json.src, 'char');
            end
            if isfield(json, 'dst')
                obj.props_('dst') = flywheel.ModelBase.deserializeValue(json.dst, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DataViewGroupByColumn')
                    obj = flywheel.model.DataViewGroupByColumn(obj);
                end
                if isKey(obj.props_, 'src')
                end
                if isKey(obj.props_, 'dst')
                end
            end
        end
    end
end
