% DeletedFile - Truncated file data in the 'files' collection after hard deletion
%
% DeletedFile Properties:
%    id          
%    origin      
%    parentRef   
%    name        
%    providerId  
%    uuid        
%    size        
%    copyOf      
%    created     
%    deleted     
%    replaced    
%    hardDeleted 
%
% DeletedFile Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DeletedFile < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'origin', 'parentRef', 'name', 'providerId', 'uuid', 'size', 'copyOf', 'created', 'deleted', 'replaced', 'hardDeleted' }, ...
            { '_id', 'origin', 'parent_ref', 'name', 'provider_id', 'uuid', 'size', 'copy_of', 'created', 'deleted', 'replaced', 'hard_deleted' });
    end
    properties(Dependent)
        id
        origin
        parentRef
        name
        providerId
        uuid
        size
        copyOf
        created
        deleted
        replaced
        hardDeleted
    end
    methods
        function obj = DeletedFile(varargin)
            obj@flywheel.ModelBase(flywheel.model.DeletedFile.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'parentRef', []);
                addParameter(p, 'name', []);
                addParameter(p, 'providerId', []);
                addParameter(p, 'uuid', []);
                addParameter(p, 'size', []);
                addParameter(p, 'copyOf', []);
                addParameter(p, 'created', []);
                addParameter(p, 'deleted', []);
                addParameter(p, 'replaced', []);
                addParameter(p, 'hardDeleted', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.parentRef)
                    obj.props_('parent_ref') = p.Results.parentRef;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.providerId)
                    obj.props_('provider_id') = p.Results.providerId;
                end
                if ~isempty(p.Results.uuid)
                    obj.props_('uuid') = p.Results.uuid;
                end
                if ~isempty(p.Results.size)
                    obj.props_('size') = p.Results.size;
                end
                if ~isempty(p.Results.copyOf)
                    obj.props_('copy_of') = p.Results.copyOf;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.deleted)
                    obj.props_('deleted') = p.Results.deleted;
                end
                if ~isempty(p.Results.replaced)
                    obj.props_('replaced') = p.Results.replaced;
                end
                if ~isempty(p.Results.hardDeleted)
                    obj.props_('hard_deleted') = p.Results.hardDeleted;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.parentRef(obj)
            if ismethod(obj, 'get_parentRef')
                result = obj.get_parentRef();
            else
                if isKey(obj.props_, 'parent_ref')
                    result = obj.props_('parent_ref');
                else
                    result = [];
                end
            end
        end
        function obj = set.parentRef(obj, value)
            obj.props_('parent_ref') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.providerId(obj)
            if ismethod(obj, 'get_providerId')
                result = obj.get_providerId();
            else
                if isKey(obj.props_, 'provider_id')
                    result = obj.props_('provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.providerId(obj, value)
            obj.props_('provider_id') = value;
        end
        function result = get.uuid(obj)
            if ismethod(obj, 'get_uuid')
                result = obj.get_uuid();
            else
                if isKey(obj.props_, 'uuid')
                    result = obj.props_('uuid');
                else
                    result = [];
                end
            end
        end
        function obj = set.uuid(obj, value)
            obj.props_('uuid') = value;
        end
        function result = get.size(obj)
            if ismethod(obj, 'get_size')
                result = obj.get_size();
            else
                if isKey(obj.props_, 'size')
                    result = obj.props_('size');
                else
                    result = [];
                end
            end
        end
        function obj = set.size(obj, value)
            obj.props_('size') = value;
        end
        function result = get.copyOf(obj)
            if ismethod(obj, 'get_copyOf')
                result = obj.get_copyOf();
            else
                if isKey(obj.props_, 'copy_of')
                    result = obj.props_('copy_of');
                else
                    result = [];
                end
            end
        end
        function obj = set.copyOf(obj, value)
            obj.props_('copy_of') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.deleted(obj)
            if ismethod(obj, 'get_deleted')
                result = obj.get_deleted();
            else
                if isKey(obj.props_, 'deleted')
                    result = obj.props_('deleted');
                else
                    result = [];
                end
            end
        end
        function obj = set.deleted(obj, value)
            obj.props_('deleted') = value;
        end
        function result = get.replaced(obj)
            if ismethod(obj, 'get_replaced')
                result = obj.get_replaced();
            else
                if isKey(obj.props_, 'replaced')
                    result = obj.props_('replaced');
                else
                    result = [];
                end
            end
        end
        function obj = set.replaced(obj, value)
            obj.props_('replaced') = value;
        end
        function result = get.hardDeleted(obj)
            if ismethod(obj, 'get_hardDeleted')
                result = obj.get_hardDeleted();
            else
                if isKey(obj.props_, 'hard_deleted')
                    result = obj.props_('hard_deleted');
                else
                    result = [];
                end
            end
        end
        function obj = set.hardDeleted(obj, value)
            obj.props_('hard_deleted') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = obj.props_('_id').toJson();
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'parent_ref')
                result('parent_ref') = obj.props_('parent_ref').toJson();
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'provider_id')
                result('provider_id') = flywheel.ModelBase.serializeValue(obj.props_('provider_id'), 'char');
            end
            if isKey(obj.props_, 'uuid')
                result('uuid') = flywheel.ModelBase.serializeValue(obj.props_('uuid'), 'char');
            end
            if isKey(obj.props_, 'size')
                result('size') = flywheel.ModelBase.serializeValue(obj.props_('size'), 'integer');
            end
            if isKey(obj.props_, 'copy_of')
                result('copy_of') = obj.props_('copy_of').toJson();
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'deleted')
                result('deleted') = flywheel.ModelBase.serializeValue(obj.props_('deleted'), 'datetime');
            end
            if isKey(obj.props_, 'replaced')
                result('replaced') = flywheel.ModelBase.serializeValue(obj.props_('replaced'), 'datetime');
            end
            if isKey(obj.props_, 'hard_deleted')
                result('hard_deleted') = flywheel.ModelBase.serializeValue(obj.props_('hard_deleted'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = struct(obj.props_('_id'));
            else
                result.id = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'parent_ref')
                result.parentRef = struct(obj.props_('parent_ref'));
            else
                result.parentRef = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'provider_id')
                result.providerId = obj.props_('provider_id');
            else
                result.providerId = [];
            end
            if isKey(obj.props_, 'uuid')
                result.uuid = obj.props_('uuid');
            else
                result.uuid = [];
            end
            if isKey(obj.props_, 'size')
                result.size = obj.props_('size');
            else
                result.size = [];
            end
            if isKey(obj.props_, 'copy_of')
                result.copyOf = struct(obj.props_('copy_of'));
            else
                result.copyOf = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'deleted')
                result.deleted = obj.props_('deleted');
            else
                result.deleted = [];
            end
            if isKey(obj.props_, 'replaced')
                result.replaced = obj.props_('replaced');
            else
                result.replaced = [];
            end
            if isKey(obj.props_, 'hard_deleted')
                result.hardDeleted = obj.props_('hard_deleted');
            else
                result.hardDeleted = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'parent_ref')
                    propList.parentRef = obj.props_('parent_ref');
                else
                    propList.parentRef = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'provider_id')
                    propList.providerId = obj.props_('provider_id');
                else
                    propList.providerId = [];
                end
                if isKey(obj.props_, 'uuid')
                    propList.uuid = obj.props_('uuid');
                else
                    propList.uuid = [];
                end
                if isKey(obj.props_, 'size')
                    propList.size = obj.props_('size');
                else
                    propList.size = [];
                end
                if isKey(obj.props_, 'copy_of')
                    propList.copyOf = obj.props_('copy_of');
                else
                    propList.copyOf = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'deleted')
                    propList.deleted = obj.props_('deleted');
                else
                    propList.deleted = [];
                end
                if isKey(obj.props_, 'replaced')
                    propList.replaced = obj.props_('replaced');
                else
                    propList.replaced = [];
                end
                if isKey(obj.props_, 'hard_deleted')
                    propList.hardDeleted = obj.props_('hard_deleted');
                else
                    propList.hardDeleted = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DeletedFile;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.model.FileVersion.fromJson(json.x0x5Fid, context);
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'parent_ref')
                obj.props_('parent_ref') = flywheel.model.ContainerReference.fromJson(json.parent_ref, context);
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'provider_id')
                obj.props_('provider_id') = flywheel.ModelBase.deserializeValue(json.provider_id, 'char');
            end
            if isfield(json, 'uuid')
                obj.props_('uuid') = flywheel.ModelBase.deserializeValue(json.uuid, 'char');
            end
            if isfield(json, 'size')
                obj.props_('size') = flywheel.ModelBase.deserializeValue(json.size, 'integer');
            end
            if isfield(json, 'copy_of')
                obj.props_('copy_of') = flywheel.model.FileVersionCopyOf.fromJson(json.copy_of, context);
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'deleted')
                obj.props_('deleted') = flywheel.ModelBase.deserializeValue(json.deleted, 'datetime');
            end
            if isfield(json, 'replaced')
                obj.props_('replaced') = flywheel.ModelBase.deserializeValue(json.replaced, 'datetime');
            end
            if isfield(json, 'hard_deleted')
                obj.props_('hard_deleted') = flywheel.ModelBase.deserializeValue(json.hard_deleted, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DeletedFile')
                    obj = flywheel.model.DeletedFile(obj);
                end
                if isKey(obj.props_, '_id')
                    obj.props_('_id') =  flywheel.model.FileVersion.ensureIsInstance(obj.props_('_id'));
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'parent_ref')
                    obj.props_('parent_ref') =  flywheel.model.ContainerReference.ensureIsInstance(obj.props_('parent_ref'));
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'provider_id')
                end
                if isKey(obj.props_, 'uuid')
                end
                if isKey(obj.props_, 'size')
                end
                if isKey(obj.props_, 'copy_of')
                    obj.props_('copy_of') =  flywheel.model.FileVersionCopyOf.ensureIsInstance(obj.props_('copy_of'));
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'deleted')
                end
                if isKey(obj.props_, 'replaced')
                end
                if isKey(obj.props_, 'hard_deleted')
                end
            end
        end
    end
end
