% DeletedResult
%
% DeletedResult Properties:
%    deleted   - The number of containers that were deleted
%    notFound  - The number of containers that were specified by ID to be deleted, but were not found because they don't exist or were already deleted
%
% DeletedResult Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DeletedResult < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'deleted', 'notFound' }, ...
            { 'deleted', 'not_found' });
    end
    properties(Dependent)
        deleted
        notFound
    end
    methods
        function obj = DeletedResult(varargin)
            obj@flywheel.ModelBase(flywheel.model.DeletedResult.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'deleted', []);
                addParameter(p, 'notFound', 0);

                parse(p, varargin{:});

                if ~isempty(p.Results.deleted)
                    obj.props_('deleted') = p.Results.deleted;
                end
                if ~isempty(p.Results.notFound)
                    obj.props_('not_found') = p.Results.notFound;
                end
            end
        end
        function result = get.deleted(obj)
            if ismethod(obj, 'get_deleted')
                result = obj.get_deleted();
            else
                if isKey(obj.props_, 'deleted')
                    result = obj.props_('deleted');
                else
                    result = [];
                end
            end
        end
        function obj = set.deleted(obj, value)
            obj.props_('deleted') = value;
        end
        function result = get.notFound(obj)
            if ismethod(obj, 'get_notFound')
                result = obj.get_notFound();
            else
                if isKey(obj.props_, 'not_found')
                    result = obj.props_('not_found');
                else
                    result = [];
                end
            end
        end
        function obj = set.notFound(obj, value)
            obj.props_('not_found') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'deleted')
                result('deleted') = flywheel.ModelBase.serializeValue(obj.props_('deleted'), 'integer');
            end
            if isKey(obj.props_, 'not_found')
                result('not_found') = flywheel.ModelBase.serializeValue(obj.props_('not_found'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'deleted')
                result.deleted = obj.props_('deleted');
            else
                result.deleted = [];
            end
            if isKey(obj.props_, 'not_found')
                result.notFound = obj.props_('not_found');
            else
                result.notFound = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'deleted')
                    propList.deleted = obj.props_('deleted');
                else
                    propList.deleted = [];
                end
                if isKey(obj.props_, 'not_found')
                    propList.notFound = obj.props_('not_found');
                else
                    propList.notFound = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DeletedResult;
            if isfield(json, 'deleted')
                obj.props_('deleted') = flywheel.ModelBase.deserializeValue(json.deleted, 'integer');
            end
            if isfield(json, 'not_found')
                obj.props_('not_found') = flywheel.ModelBase.deserializeValue(json.not_found, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DeletedResult')
                    obj = flywheel.model.DeletedResult(obj);
                end
                if isKey(obj.props_, 'deleted')
                end
                if isKey(obj.props_, 'not_found')
                end
            end
        end
    end
end
