% Device
%
% Device Properties:
%    id            
%    lastSeen      
%    label         
%    type          
%    storageConfig 
%    disabled      
%    version       
%    name          
%    interval      
%    errors        
%    info          
%
% Device Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Device < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'lastSeen', 'label', 'type', 'storageConfig', 'disabled', 'version', 'name', 'interval', 'errors', 'info' }, ...
            { 'id', 'last_seen', 'label', 'type', 'storage_config', 'disabled', 'version', 'name', 'interval', 'errors', 'info' });
    end
    properties(Dependent)
        id
        lastSeen
        label
        type
        storageConfig
        disabled
        version
        name
        interval
        errors
        info
    end
    methods
        function obj = Device(varargin)
            obj@flywheel.ModelBase(flywheel.model.Device.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'lastSeen', []);
                addParameter(p, 'label', []);
                addParameter(p, 'type', []);
                addParameter(p, 'storageConfig', []);
                addParameter(p, 'disabled', []);
                addParameter(p, 'version', []);
                addParameter(p, 'name', []);
                addParameter(p, 'interval', []);
                addParameter(p, 'errors', []);
                addParameter(p, 'info', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('id') = p.Results.id;
                end
                if ~isempty(p.Results.lastSeen)
                    obj.props_('last_seen') = p.Results.lastSeen;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.storageConfig)
                    obj.props_('storage_config') = p.Results.storageConfig;
                end
                if ~isempty(p.Results.disabled)
                    obj.props_('disabled') = p.Results.disabled;
                end
                if ~isempty(p.Results.version)
                    obj.props_('version') = p.Results.version;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.interval)
                    obj.props_('interval') = p.Results.interval;
                end
                if ~isempty(p.Results.errors)
                    obj.props_('errors') = p.Results.errors;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, 'id')
                    result = obj.props_('id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('id') = value;
        end
        function result = get.lastSeen(obj)
            if ismethod(obj, 'get_lastSeen')
                result = obj.get_lastSeen();
            else
                if isKey(obj.props_, 'last_seen')
                    result = obj.props_('last_seen');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastSeen(obj, value)
            obj.props_('last_seen') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.storageConfig(obj)
            if ismethod(obj, 'get_storageConfig')
                result = obj.get_storageConfig();
            else
                if isKey(obj.props_, 'storage_config')
                    result = obj.props_('storage_config');
                else
                    result = [];
                end
            end
        end
        function obj = set.storageConfig(obj, value)
            obj.props_('storage_config') = value;
        end
        function result = get.disabled(obj)
            if ismethod(obj, 'get_disabled')
                result = obj.get_disabled();
            else
                if isKey(obj.props_, 'disabled')
                    result = obj.props_('disabled');
                else
                    result = [];
                end
            end
        end
        function obj = set.disabled(obj, value)
            obj.props_('disabled') = value;
        end
        function result = get.version(obj)
            if ismethod(obj, 'get_version')
                result = obj.get_version();
            else
                if isKey(obj.props_, 'version')
                    result = obj.props_('version');
                else
                    result = [];
                end
            end
        end
        function obj = set.version(obj, value)
            obj.props_('version') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.interval(obj)
            if ismethod(obj, 'get_interval')
                result = obj.get_interval();
            else
                if isKey(obj.props_, 'interval')
                    result = obj.props_('interval');
                else
                    result = [];
                end
            end
        end
        function obj = set.interval(obj, value)
            obj.props_('interval') = value;
        end
        function result = get.errors(obj)
            if ismethod(obj, 'get_errors')
                result = obj.get_errors();
            else
                if isKey(obj.props_, 'errors')
                    result = obj.props_('errors');
                else
                    result = [];
                end
            end
        end
        function obj = set.errors(obj, value)
            obj.props_('errors') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'id')
                result('id') = flywheel.ModelBase.serializeValue(obj.props_('id'), 'char');
            end
            if isKey(obj.props_, 'last_seen')
                result('last_seen') = flywheel.ModelBase.serializeValue(obj.props_('last_seen'), 'datetime');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'storage_config')
                result('storage_config') = flywheel.ModelBase.serializeValue(obj.props_('storage_config'), 'containers.Map');
            end
            if isKey(obj.props_, 'disabled')
                result('disabled') = flywheel.ModelBase.serializeValue(obj.props_('disabled'), 'logical');
            end
            if isKey(obj.props_, 'version')
                result('version') = flywheel.ModelBase.serializeValue(obj.props_('version'), 'char');
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'interval')
                result('interval') = flywheel.ModelBase.serializeValue(obj.props_('interval'), 'integer');
            end
            if isKey(obj.props_, 'errors')
                result('errors') = flywheel.ModelBase.serializeValue(obj.props_('errors'), 'vector[char]');
            end
            if isKey(obj.props_, 'info')
                result('info') = obj.props_('info').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'id')
                result.id = obj.props_('id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'last_seen')
                result.lastSeen = obj.props_('last_seen');
            else
                result.lastSeen = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'storage_config')
                result.storageConfig = obj.props_('storage_config');
            else
                result.storageConfig = [];
            end
            if isKey(obj.props_, 'disabled')
                result.disabled = obj.props_('disabled');
            else
                result.disabled = [];
            end
            if isKey(obj.props_, 'version')
                result.version = obj.props_('version');
            else
                result.version = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'interval')
                result.interval = obj.props_('interval');
            else
                result.interval = [];
            end
            if isKey(obj.props_, 'errors')
                result.errors = obj.props_('errors');
            else
                result.errors = [];
            end
            if isKey(obj.props_, 'info')
                result.info = struct(obj.props_('info'));
            else
                result.info = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'id')
                    propList.id = obj.props_('id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'last_seen')
                    propList.lastSeen = obj.props_('last_seen');
                else
                    propList.lastSeen = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'storage_config')
                    propList.storageConfig = obj.props_('storage_config');
                else
                    propList.storageConfig = [];
                end
                if isKey(obj.props_, 'disabled')
                    propList.disabled = obj.props_('disabled');
                else
                    propList.disabled = [];
                end
                if isKey(obj.props_, 'version')
                    propList.version = obj.props_('version');
                else
                    propList.version = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'interval')
                    propList.interval = obj.props_('interval');
                else
                    propList.interval = [];
                end
                if isKey(obj.props_, 'errors')
                    propList.errors = obj.props_('errors');
                else
                    propList.errors = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Device;
            if isfield(json, 'id')
                obj.props_('id') = flywheel.ModelBase.deserializeValue(json.id, 'char');
            end
            if isfield(json, 'last_seen')
                obj.props_('last_seen') = flywheel.ModelBase.deserializeValue(json.last_seen, 'datetime');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'storage_config')
                obj.props_('storage_config') = flywheel.ModelBase.deserializeValue(json.storage_config, 'containers.Map');
            end
            if isfield(json, 'disabled')
                obj.props_('disabled') = flywheel.ModelBase.deserializeValue(json.disabled, 'logical');
            end
            if isfield(json, 'version')
                obj.props_('version') = flywheel.ModelBase.deserializeValue(json.version, 'char');
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'interval')
                obj.props_('interval') = flywheel.ModelBase.deserializeValue(json.interval, 'integer');
            end
            if isfield(json, 'errors')
                obj.props_('errors') = flywheel.ModelBase.deserializeValue(json.errors, 'vector[char]');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.model.CommonInfo.fromJson(json.info, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Device')
                    obj = flywheel.model.Device(obj);
                end
                if isKey(obj.props_, 'id')
                end
                if isKey(obj.props_, 'last_seen')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'storage_config')
                end
                if isKey(obj.props_, 'disabled')
                end
                if isKey(obj.props_, 'version')
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'interval')
                end
                if isKey(obj.props_, 'errors')
                end
                if isKey(obj.props_, 'info')
                    obj.props_('info') =  flywheel.model.CommonInfo.ensureIsInstance(obj.props_('info'));
                end
            end
        end
    end
end
