% DeviceAdminUpdate
%
% DeviceAdminUpdate Properties:
%    disabled      
%    storageConfig 
%
% DeviceAdminUpdate Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DeviceAdminUpdate < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'disabled', 'storageConfig' }, ...
            { 'disabled', 'storage_config' });
    end
    properties(Dependent)
        disabled
        storageConfig
    end
    methods
        function obj = DeviceAdminUpdate(varargin)
            obj@flywheel.ModelBase(flywheel.model.DeviceAdminUpdate.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'disabled', []);
                addParameter(p, 'storageConfig', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.disabled)
                    obj.props_('disabled') = p.Results.disabled;
                end
                if ~isempty(p.Results.storageConfig)
                    obj.props_('storage_config') = p.Results.storageConfig;
                end
            end
        end
        function result = get.disabled(obj)
            if ismethod(obj, 'get_disabled')
                result = obj.get_disabled();
            else
                if isKey(obj.props_, 'disabled')
                    result = obj.props_('disabled');
                else
                    result = [];
                end
            end
        end
        function obj = set.disabled(obj, value)
            obj.props_('disabled') = value;
        end
        function result = get.storageConfig(obj)
            if ismethod(obj, 'get_storageConfig')
                result = obj.get_storageConfig();
            else
                if isKey(obj.props_, 'storage_config')
                    result = obj.props_('storage_config');
                else
                    result = [];
                end
            end
        end
        function obj = set.storageConfig(obj, value)
            obj.props_('storage_config') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'disabled')
                result('disabled') = flywheel.ModelBase.serializeValue(obj.props_('disabled'), 'logical');
            end
            if isKey(obj.props_, 'storage_config')
                result('storage_config') = obj.props_('storage_config').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'disabled')
                result.disabled = obj.props_('disabled');
            else
                result.disabled = [];
            end
            if isKey(obj.props_, 'storage_config')
                result.storageConfig = struct(obj.props_('storage_config'));
            else
                result.storageConfig = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'disabled')
                    propList.disabled = obj.props_('disabled');
                else
                    propList.disabled = [];
                end
                if isKey(obj.props_, 'storage_config')
                    propList.storageConfig = obj.props_('storage_config');
                else
                    propList.storageConfig = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DeviceAdminUpdate;
            if isfield(json, 'disabled')
                obj.props_('disabled') = flywheel.ModelBase.deserializeValue(json.disabled, 'logical');
            end
            if isfield(json, 'storage_config')
                obj.props_('storage_config') = flywheel.model.DeviceStorageStrategyUpdate.fromJson(json.storage_config, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DeviceAdminUpdate')
                    obj = flywheel.model.DeviceAdminUpdate(obj);
                end
                if isKey(obj.props_, 'disabled')
                end
                if isKey(obj.props_, 'storage_config')
                    obj.props_('storage_config') =  flywheel.model.DeviceStorageStrategyUpdate.ensureIsInstance(obj.props_('storage_config'));
                end
            end
        end
    end
end
