% DeviceCreate - Used only for Post inputs
%
% DeviceCreate Properties:
%    label         
%    type          
%    storageConfig 
%
% DeviceCreate Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DeviceCreate < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'type', 'storageConfig' }, ...
            { 'label', 'type', 'storage_config' });
    end
    properties(Dependent)
        label
        type
        storageConfig
    end
    methods
        function obj = DeviceCreate(varargin)
            obj@flywheel.ModelBase(flywheel.model.DeviceCreate.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'type', []);
                addParameter(p, 'storageConfig', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.storageConfig)
                    obj.props_('storage_config') = p.Results.storageConfig;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.storageConfig(obj)
            if ismethod(obj, 'get_storageConfig')
                result = obj.get_storageConfig();
            else
                if isKey(obj.props_, 'storage_config')
                    result = obj.props_('storage_config');
                else
                    result = [];
                end
            end
        end
        function obj = set.storageConfig(obj, value)
            obj.props_('storage_config') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'storage_config')
                result('storage_config') = obj.props_('storage_config').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'storage_config')
                result.storageConfig = struct(obj.props_('storage_config'));
            else
                result.storageConfig = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'storage_config')
                    propList.storageConfig = obj.props_('storage_config');
                else
                    propList.storageConfig = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DeviceCreate;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'storage_config')
                obj.props_('storage_config') = flywheel.model.StorageStrategyConfig.fromJson(json.storage_config, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DeviceCreate')
                    obj = flywheel.model.DeviceCreate(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'storage_config')
                    obj.props_('storage_config') =  flywheel.model.StorageStrategyConfig.ensureIsInstance(obj.props_('storage_config'));
                end
            end
        end
    end
end
