% DeviceSelfUpdate
%
% DeviceSelfUpdate Properties:
%    type     
%    version  
%    interval 
%    errors   
%    info     
%
% DeviceSelfUpdate Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DeviceSelfUpdate < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'type', 'version', 'interval', 'errors', 'info' }, ...
            { 'type', 'version', 'interval', 'errors', 'info' });
    end
    properties(Dependent)
        type
        version
        interval
        errors
        info
    end
    methods
        function obj = DeviceSelfUpdate(varargin)
            obj@flywheel.ModelBase(flywheel.model.DeviceSelfUpdate.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'type', []);
                addParameter(p, 'version', []);
                addParameter(p, 'interval', []);
                addParameter(p, 'errors', []);
                addParameter(p, 'info', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.version)
                    obj.props_('version') = p.Results.version;
                end
                if ~isempty(p.Results.interval)
                    obj.props_('interval') = p.Results.interval;
                end
                if ~isempty(p.Results.errors)
                    obj.props_('errors') = p.Results.errors;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
            end
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.version(obj)
            if ismethod(obj, 'get_version')
                result = obj.get_version();
            else
                if isKey(obj.props_, 'version')
                    result = obj.props_('version');
                else
                    result = [];
                end
            end
        end
        function obj = set.version(obj, value)
            obj.props_('version') = value;
        end
        function result = get.interval(obj)
            if ismethod(obj, 'get_interval')
                result = obj.get_interval();
            else
                if isKey(obj.props_, 'interval')
                    result = obj.props_('interval');
                else
                    result = [];
                end
            end
        end
        function obj = set.interval(obj, value)
            obj.props_('interval') = value;
        end
        function result = get.errors(obj)
            if ismethod(obj, 'get_errors')
                result = obj.get_errors();
            else
                if isKey(obj.props_, 'errors')
                    result = obj.props_('errors');
                else
                    result = [];
                end
            end
        end
        function obj = set.errors(obj, value)
            obj.props_('errors') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'version')
                result('version') = flywheel.ModelBase.serializeValue(obj.props_('version'), 'char');
            end
            if isKey(obj.props_, 'interval')
                result('interval') = flywheel.ModelBase.serializeValue(obj.props_('interval'), 'integer');
            end
            if isKey(obj.props_, 'errors')
                result('errors') = flywheel.ModelBase.serializeValue(obj.props_('errors'), 'vector[char]');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'version')
                result.version = obj.props_('version');
            else
                result.version = [];
            end
            if isKey(obj.props_, 'interval')
                result.interval = obj.props_('interval');
            else
                result.interval = [];
            end
            if isKey(obj.props_, 'errors')
                result.errors = obj.props_('errors');
            else
                result.errors = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'version')
                    propList.version = obj.props_('version');
                else
                    propList.version = [];
                end
                if isKey(obj.props_, 'interval')
                    propList.interval = obj.props_('interval');
                else
                    propList.interval = [];
                end
                if isKey(obj.props_, 'errors')
                    propList.errors = obj.props_('errors');
                else
                    propList.errors = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DeviceSelfUpdate;
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'version')
                obj.props_('version') = flywheel.ModelBase.deserializeValue(json.version, 'char');
            end
            if isfield(json, 'interval')
                obj.props_('interval') = flywheel.ModelBase.deserializeValue(json.interval, 'integer');
            end
            if isfield(json, 'errors')
                obj.props_('errors') = flywheel.ModelBase.deserializeValue(json.errors, 'vector[char]');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DeviceSelfUpdate')
                    obj = flywheel.model.DeviceSelfUpdate(obj);
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'version')
                end
                if isKey(obj.props_, 'interval')
                end
                if isKey(obj.props_, 'errors')
                end
                if isKey(obj.props_, 'info')
                end
            end
        end
    end
end
