% DeviceStatusEntry
%
% DeviceStatusEntry Properties:
%    errors   
%    lastSeen 
%    status   
%
% DeviceStatusEntry Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DeviceStatusEntry < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'errors', 'lastSeen', 'status' }, ...
            { 'errors', 'last_seen', 'status' });
    end
    properties(Dependent)
        errors
        lastSeen
        status
    end
    methods
        function obj = DeviceStatusEntry(varargin)
            obj@flywheel.ModelBase(flywheel.model.DeviceStatusEntry.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'errors', []);
                addParameter(p, 'lastSeen', []);
                addParameter(p, 'status', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.errors)
                    obj.props_('errors') = p.Results.errors;
                end
                if ~isempty(p.Results.lastSeen)
                    obj.props_('last_seen') = p.Results.lastSeen;
                end
                if ~isempty(p.Results.status)
                    obj.props_('status') = p.Results.status;
                end
            end
        end
        function result = get.errors(obj)
            if ismethod(obj, 'get_errors')
                result = obj.get_errors();
            else
                if isKey(obj.props_, 'errors')
                    result = obj.props_('errors');
                else
                    result = [];
                end
            end
        end
        function obj = set.errors(obj, value)
            obj.props_('errors') = value;
        end
        function result = get.lastSeen(obj)
            if ismethod(obj, 'get_lastSeen')
                result = obj.get_lastSeen();
            else
                if isKey(obj.props_, 'last_seen')
                    result = obj.props_('last_seen');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastSeen(obj, value)
            obj.props_('last_seen') = value;
        end
        function result = get.status(obj)
            if ismethod(obj, 'get_status')
                result = obj.get_status();
            else
                if isKey(obj.props_, 'status')
                    result = obj.props_('status');
                else
                    result = [];
                end
            end
        end
        function obj = set.status(obj, value)
            obj.props_('status') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'errors')
                result('errors') = flywheel.ModelBase.serializeValue(obj.props_('errors'), 'vector[char]');
            end
            if isKey(obj.props_, 'last_seen')
                result('last_seen') = flywheel.ModelBase.serializeValue(obj.props_('last_seen'), 'datetime');
            end
            if isKey(obj.props_, 'status')
                result('status') = obj.props_('status').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'errors')
                result.errors = obj.props_('errors');
            else
                result.errors = [];
            end
            if isKey(obj.props_, 'last_seen')
                result.lastSeen = obj.props_('last_seen');
            else
                result.lastSeen = [];
            end
            if isKey(obj.props_, 'status')
                result.status = struct(obj.props_('status'));
            else
                result.status = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'errors')
                    propList.errors = obj.props_('errors');
                else
                    propList.errors = [];
                end
                if isKey(obj.props_, 'last_seen')
                    propList.lastSeen = obj.props_('last_seen');
                else
                    propList.lastSeen = [];
                end
                if isKey(obj.props_, 'status')
                    propList.status = obj.props_('status');
                else
                    propList.status = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DeviceStatusEntry;
            if isfield(json, 'errors')
                obj.props_('errors') = flywheel.ModelBase.deserializeValue(json.errors, 'vector[char]');
            end
            if isfield(json, 'last_seen')
                obj.props_('last_seen') = flywheel.ModelBase.deserializeValue(json.last_seen, 'datetime');
            end
            if isfield(json, 'status')
                obj.props_('status') = flywheel.model.StatusValue.fromJson(json.status, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DeviceStatusEntry')
                    obj = flywheel.model.DeviceStatusEntry(obj);
                end
                if isKey(obj.props_, 'errors')
                end
                if isKey(obj.props_, 'last_seen')
                end
                if isKey(obj.props_, 'status')
                    obj.props_('status') =  flywheel.model.StatusValue.ensureIsInstance(obj.props_('status'));
                end
            end
        end
    end
end
