% DeviceStorageStrategyUpdate
%
% DeviceStorageStrategyUpdate Properties:
%    storageStrategy 
%    provider        
%
% DeviceStorageStrategyUpdate Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DeviceStorageStrategyUpdate < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'storageStrategy', 'provider' }, ...
            { 'storage_strategy', 'provider' });
    end
    properties(Dependent)
        storageStrategy
        provider
    end
    methods
        function obj = DeviceStorageStrategyUpdate(varargin)
            obj@flywheel.ModelBase(flywheel.model.DeviceStorageStrategyUpdate.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'storageStrategy', []);
                addParameter(p, 'provider', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.storageStrategy)
                    obj.props_('storage_strategy') = p.Results.storageStrategy;
                end
                if ~isempty(p.Results.provider)
                    obj.props_('provider') = p.Results.provider;
                end
            end
        end
        function result = get.storageStrategy(obj)
            if ismethod(obj, 'get_storageStrategy')
                result = obj.get_storageStrategy();
            else
                if isKey(obj.props_, 'storage_strategy')
                    result = obj.props_('storage_strategy');
                else
                    result = [];
                end
            end
        end
        function obj = set.storageStrategy(obj, value)
            obj.props_('storage_strategy') = value;
        end
        function result = get.provider(obj)
            if ismethod(obj, 'get_provider')
                result = obj.get_provider();
            else
                if isKey(obj.props_, 'provider')
                    result = obj.props_('provider');
                else
                    result = [];
                end
            end
        end
        function obj = set.provider(obj, value)
            obj.props_('provider') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'storage_strategy')
                result('storage_strategy') = obj.props_('storage_strategy').toJson();
            end
            if isKey(obj.props_, 'provider')
                result('provider') = flywheel.ModelBase.serializeValue(obj.props_('provider'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'storage_strategy')
                result.storageStrategy = struct(obj.props_('storage_strategy'));
            else
                result.storageStrategy = [];
            end
            if isKey(obj.props_, 'provider')
                result.provider = obj.props_('provider');
            else
                result.provider = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'storage_strategy')
                    propList.storageStrategy = obj.props_('storage_strategy');
                else
                    propList.storageStrategy = [];
                end
                if isKey(obj.props_, 'provider')
                    propList.provider = obj.props_('provider');
                else
                    propList.provider = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DeviceStorageStrategyUpdate;
            if isfield(json, 'storage_strategy')
                obj.props_('storage_strategy') = flywheel.model.StorageStrategy.fromJson(json.storage_strategy, context);
            end
            if isfield(json, 'provider')
                obj.props_('provider') = flywheel.ModelBase.deserializeValue(json.provider, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DeviceStorageStrategyUpdate')
                    obj = flywheel.model.DeviceStorageStrategyUpdate(obj);
                end
                if isKey(obj.props_, 'storage_strategy')
                    obj.props_('storage_strategy') =  flywheel.model.StorageStrategy.ensureIsInstance(obj.props_('storage_strategy'));
                end
                if isKey(obj.props_, 'provider')
                end
            end
        end
    end
end
