% Download - Specifies a set of files to download
%
% Download Properties:
%    optional         
%    nodes            
%    containerFilters 
%    filters          
%
% Download Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Download < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'optional', 'nodes', 'containerFilters', 'filters' }, ...
            { 'optional', 'nodes', 'container_filters', 'filters' });
    end
    properties(Dependent)
        optional
        nodes
        containerFilters
        filters
    end
    methods
        function obj = Download(varargin)
            obj@flywheel.ModelBase(flywheel.model.Download.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'optional', []);
                addParameter(p, 'nodes', []);
                addParameter(p, 'containerFilters', []);
                addParameter(p, 'filters', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.optional)
                    obj.props_('optional') = p.Results.optional;
                end
                if ~isempty(p.Results.nodes)
                    obj.props_('nodes') = p.Results.nodes;
                end
                if ~isempty(p.Results.containerFilters)
                    obj.props_('container_filters') = p.Results.containerFilters;
                end
                if ~isempty(p.Results.filters)
                    obj.props_('filters') = p.Results.filters;
                end
            end
        end
        function result = get.optional(obj)
            if ismethod(obj, 'get_optional')
                result = obj.get_optional();
            else
                if isKey(obj.props_, 'optional')
                    result = obj.props_('optional');
                else
                    result = [];
                end
            end
        end
        function obj = set.optional(obj, value)
            obj.props_('optional') = value;
        end
        function result = get.nodes(obj)
            if ismethod(obj, 'get_nodes')
                result = obj.get_nodes();
            else
                if isKey(obj.props_, 'nodes')
                    result = obj.props_('nodes');
                else
                    result = [];
                end
            end
        end
        function obj = set.nodes(obj, value)
            obj.props_('nodes') = value;
        end
        function result = get.containerFilters(obj)
            if ismethod(obj, 'get_containerFilters')
                result = obj.get_containerFilters();
            else
                if isKey(obj.props_, 'container_filters')
                    result = obj.props_('container_filters');
                else
                    result = [];
                end
            end
        end
        function obj = set.containerFilters(obj, value)
            obj.props_('container_filters') = value;
        end
        function result = get.filters(obj)
            if ismethod(obj, 'get_filters')
                result = obj.get_filters();
            else
                if isKey(obj.props_, 'filters')
                    result = obj.props_('filters');
                else
                    result = [];
                end
            end
        end
        function obj = set.filters(obj, value)
            obj.props_('filters') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'optional')
                result('optional') = flywheel.ModelBase.serializeValue(obj.props_('optional'), 'logical');
            end
            if isKey(obj.props_, 'nodes')
                result('nodes') = flywheel.ModelBase.cellmap(@toJson, obj.props_('nodes'));
            end
            if isKey(obj.props_, 'container_filters')
                result('container_filters') = flywheel.ModelBase.cellmap(@toJson, obj.props_('container_filters'));
            end
            if isKey(obj.props_, 'filters')
                result('filters') = flywheel.ModelBase.cellmap(@toJson, obj.props_('filters'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'optional')
                result.optional = obj.props_('optional');
            else
                result.optional = [];
            end
            if isKey(obj.props_, 'nodes')
                result.nodes = flywheel.ModelBase.cellmap(@struct, obj.props_('nodes'));
            else
                result.nodes = [];
            end
            if isKey(obj.props_, 'container_filters')
                result.containerFilters = flywheel.ModelBase.cellmap(@struct, obj.props_('container_filters'));
            else
                result.containerFilters = [];
            end
            if isKey(obj.props_, 'filters')
                result.filters = flywheel.ModelBase.cellmap(@struct, obj.props_('filters'));
            else
                result.filters = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'optional')
                    propList.optional = obj.props_('optional');
                else
                    propList.optional = [];
                end
                if isKey(obj.props_, 'nodes')
                    propList.nodes = obj.props_('nodes');
                else
                    propList.nodes = [];
                end
                if isKey(obj.props_, 'container_filters')
                    propList.containerFilters = obj.props_('container_filters');
                else
                    propList.containerFilters = [];
                end
                if isKey(obj.props_, 'filters')
                    propList.filters = obj.props_('filters');
                else
                    propList.filters = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Download;
            if isfield(json, 'optional')
                obj.props_('optional') = flywheel.ModelBase.deserializeValue(json.optional, 'logical');
            end
            if isfield(json, 'nodes')
                obj.props_('nodes') = flywheel.ModelBase.cellmap(@(x) flywheel.model.DownloadNode.fromJson(x, context), json.nodes);
            end
            if isfield(json, 'container_filters')
                obj.props_('container_filters') = flywheel.ModelBase.cellmap(@(x) flywheel.model.DownloadContainerFilter.fromJson(x, context), json.container_filters);
            end
            if isfield(json, 'filters')
                obj.props_('filters') = flywheel.ModelBase.cellmap(@(x) flywheel.model.DownloadFilter.fromJson(x, context), json.filters);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Download')
                    obj = flywheel.model.Download(obj);
                end
                if isKey(obj.props_, 'optional')
                end
                if isKey(obj.props_, 'nodes')
                    obj.props_('nodes') = flywheel.ModelBase.cellmap(@flywheel.model.DownloadNode.ensureIsInstance, obj.props_('nodes'));
                end
                if isKey(obj.props_, 'container_filters')
                    obj.props_('container_filters') = flywheel.ModelBase.cellmap(@flywheel.model.DownloadContainerFilter.ensureIsInstance, obj.props_('container_filters'));
                end
                if isKey(obj.props_, 'filters')
                    obj.props_('filters') = flywheel.ModelBase.cellmap(@flywheel.model.DownloadFilter.ensureIsInstance, obj.props_('filters'));
                end
            end
        end
    end
end
