% DownloadContainerFilterDefinition
%
% DownloadContainerFilterDefinition Properties:
%    type  
%    plus   - A list of items to include or exclude from a download
%    minus  - A list of items to include or exclude from a download
%
% DownloadContainerFilterDefinition Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DownloadContainerFilterDefinition < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'type', 'plus', 'minus' }, ...
            { 'type', 'plus', 'minus' });
    end
    properties(Dependent)
        type
        plus
        minus
    end
    methods
        function obj = DownloadContainerFilterDefinition(varargin)
            obj@flywheel.ModelBase(flywheel.model.DownloadContainerFilterDefinition.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'type', []);
                addParameter(p, 'plus', []);
                addParameter(p, 'minus', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.plus)
                    obj.props_('plus') = p.Results.plus;
                end
                if ~isempty(p.Results.minus)
                    obj.props_('minus') = p.Results.minus;
                end
            end
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.plus(obj)
            if ismethod(obj, 'get_plus')
                result = obj.get_plus();
            else
                if isKey(obj.props_, 'plus')
                    result = obj.props_('plus');
                else
                    result = [];
                end
            end
        end
        function obj = set.plus(obj, value)
            obj.props_('plus') = value;
        end
        function result = get.minus(obj)
            if ismethod(obj, 'get_minus')
                result = obj.get_minus();
            else
                if isKey(obj.props_, 'minus')
                    result = obj.props_('minus');
                else
                    result = [];
                end
            end
        end
        function obj = set.minus(obj, value)
            obj.props_('minus') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'plus')
                result('plus') = flywheel.ModelBase.serializeValue(obj.props_('plus'), 'vector[char]');
            end
            if isKey(obj.props_, 'minus')
                result('minus') = flywheel.ModelBase.serializeValue(obj.props_('minus'), 'vector[char]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'plus')
                result.plus = obj.props_('plus');
            else
                result.plus = [];
            end
            if isKey(obj.props_, 'minus')
                result.minus = obj.props_('minus');
            else
                result.minus = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'plus')
                    propList.plus = obj.props_('plus');
                else
                    propList.plus = [];
                end
                if isKey(obj.props_, 'minus')
                    propList.minus = obj.props_('minus');
                else
                    propList.minus = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DownloadContainerFilterDefinition;
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'plus')
                obj.props_('plus') = flywheel.ModelBase.deserializeValue(json.plus, 'vector[char]');
            end
            if isfield(json, 'minus')
                obj.props_('minus') = flywheel.ModelBase.deserializeValue(json.minus, 'vector[char]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DownloadContainerFilterDefinition')
                    obj = flywheel.model.DownloadContainerFilterDefinition(obj);
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'plus')
                end
                if isKey(obj.props_, 'minus')
                end
            end
        end
    end
end
