% EgressProvider - Provider output model
%
% EgressProvider Properties:
%    id             
%    label          
%    deletionStatus 
%    providerClass  
%    providerType   
%    config         
%    modified       
%    created        
%    deleted        
%    accessType     
%
% EgressProvider Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef EgressProvider < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'label', 'deletionStatus', 'providerClass', 'providerType', 'config', 'modified', 'created', 'deleted', 'accessType' }, ...
            { '_id', 'label', 'deletion_status', 'provider_class', 'provider_type', 'config', 'modified', 'created', 'deleted', 'access_type' });
    end
    properties(Dependent)
        id
        label
        deletionStatus
        providerClass
        providerType
        config
        modified
        created
        deleted
        accessType
    end
    methods
        function obj = EgressProvider(varargin)
            obj@flywheel.ModelBase(flywheel.model.EgressProvider.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'label', []);
                addParameter(p, 'deletionStatus', []);
                addParameter(p, 'providerClass', []);
                addParameter(p, 'providerType', []);
                addParameter(p, 'config', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'created', []);
                addParameter(p, 'deleted', []);
                addParameter(p, 'accessType', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.deletionStatus)
                    obj.props_('deletion_status') = p.Results.deletionStatus;
                end
                if ~isempty(p.Results.providerClass)
                    obj.props_('provider_class') = p.Results.providerClass;
                end
                if ~isempty(p.Results.providerType)
                    obj.props_('provider_type') = p.Results.providerType;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.deleted)
                    obj.props_('deleted') = p.Results.deleted;
                end
                if ~isempty(p.Results.accessType)
                    obj.props_('access_type') = p.Results.accessType;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.deletionStatus(obj)
            if ismethod(obj, 'get_deletionStatus')
                result = obj.get_deletionStatus();
            else
                if isKey(obj.props_, 'deletion_status')
                    result = obj.props_('deletion_status');
                else
                    result = [];
                end
            end
        end
        function obj = set.deletionStatus(obj, value)
            obj.props_('deletion_status') = value;
        end
        function result = get.providerClass(obj)
            if ismethod(obj, 'get_providerClass')
                result = obj.get_providerClass();
            else
                if isKey(obj.props_, 'provider_class')
                    result = obj.props_('provider_class');
                else
                    result = [];
                end
            end
        end
        function obj = set.providerClass(obj, value)
            obj.props_('provider_class') = value;
        end
        function result = get.providerType(obj)
            if ismethod(obj, 'get_providerType')
                result = obj.get_providerType();
            else
                if isKey(obj.props_, 'provider_type')
                    result = obj.props_('provider_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.providerType(obj, value)
            obj.props_('provider_type') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.deleted(obj)
            if ismethod(obj, 'get_deleted')
                result = obj.get_deleted();
            else
                if isKey(obj.props_, 'deleted')
                    result = obj.props_('deleted');
                else
                    result = [];
                end
            end
        end
        function obj = set.deleted(obj, value)
            obj.props_('deleted') = value;
        end
        function result = get.accessType(obj)
            if ismethod(obj, 'get_accessType')
                result = obj.get_accessType();
            else
                if isKey(obj.props_, 'access_type')
                    result = obj.props_('access_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.accessType(obj, value)
            obj.props_('access_type') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'deletion_status')
                result('deletion_status') = obj.props_('deletion_status').toJson();
            end
            if isKey(obj.props_, 'provider_class')
                result('provider_class') = obj.props_('provider_class').toJson();
            end
            if isKey(obj.props_, 'provider_type')
                result('provider_type') = obj.props_('provider_type').toJson();
            end
            if isKey(obj.props_, 'config')
                result('config') = flywheel.ModelBase.serializeValue(obj.props_('config'), 'containers.Map');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'deleted')
                result('deleted') = flywheel.ModelBase.serializeValue(obj.props_('deleted'), 'datetime');
            end
            if isKey(obj.props_, 'access_type')
                result('access_type') = obj.props_('access_type').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'deletion_status')
                result.deletionStatus = struct(obj.props_('deletion_status'));
            else
                result.deletionStatus = [];
            end
            if isKey(obj.props_, 'provider_class')
                result.providerClass = struct(obj.props_('provider_class'));
            else
                result.providerClass = [];
            end
            if isKey(obj.props_, 'provider_type')
                result.providerType = struct(obj.props_('provider_type'));
            else
                result.providerType = [];
            end
            if isKey(obj.props_, 'config')
                result.config = obj.props_('config');
            else
                result.config = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'deleted')
                result.deleted = obj.props_('deleted');
            else
                result.deleted = [];
            end
            if isKey(obj.props_, 'access_type')
                result.accessType = struct(obj.props_('access_type'));
            else
                result.accessType = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'deletion_status')
                    propList.deletionStatus = obj.props_('deletion_status');
                else
                    propList.deletionStatus = [];
                end
                if isKey(obj.props_, 'provider_class')
                    propList.providerClass = obj.props_('provider_class');
                else
                    propList.providerClass = [];
                end
                if isKey(obj.props_, 'provider_type')
                    propList.providerType = obj.props_('provider_type');
                else
                    propList.providerType = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'deleted')
                    propList.deleted = obj.props_('deleted');
                else
                    propList.deleted = [];
                end
                if isKey(obj.props_, 'access_type')
                    propList.accessType = obj.props_('access_type');
                else
                    propList.accessType = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.EgressProvider;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'deletion_status')
                obj.props_('deletion_status') = flywheel.model.ProviderDeletionStatus.fromJson(json.deletion_status, context);
            end
            if isfield(json, 'provider_class')
                obj.props_('provider_class') = flywheel.model.ProviderClass.fromJson(json.provider_class, context);
            end
            if isfield(json, 'provider_type')
                obj.props_('provider_type') = flywheel.model.ProviderType.fromJson(json.provider_type, context);
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.ModelBase.deserializeValue(json.config, 'containers.Map');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'deleted')
                obj.props_('deleted') = flywheel.ModelBase.deserializeValue(json.deleted, 'datetime');
            end
            if isfield(json, 'access_type')
                obj.props_('access_type') = flywheel.model.ProviderAccessType.fromJson(json.access_type, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.EgressProvider')
                    obj = flywheel.model.EgressProvider(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'deletion_status')
                    obj.props_('deletion_status') =  flywheel.model.ProviderDeletionStatus.ensureIsInstance(obj.props_('deletion_status'));
                end
                if isKey(obj.props_, 'provider_class')
                    obj.props_('provider_class') =  flywheel.model.ProviderClass.ensureIsInstance(obj.props_('provider_class'));
                end
                if isKey(obj.props_, 'provider_type')
                    obj.props_('provider_type') =  flywheel.model.ProviderType.ensureIsInstance(obj.props_('provider_type'));
                end
                if isKey(obj.props_, 'config')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'deleted')
                end
                if isKey(obj.props_, 'access_type')
                    obj.props_('access_type') =  flywheel.model.ProviderAccessType.ensureIsInstance(obj.props_('access_type'));
                end
            end
        end
    end
end
