% ExchangeStorage
%
% ExchangeStorage Properties:
%    configType  
%    configClass 
%    siteId      
%    datasetId   
%
% ExchangeStorage Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ExchangeStorage < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'configType', 'configClass', 'siteId', 'datasetId' }, ...
            { 'config_type', 'config_class', 'site_id', 'dataset_id' });
    end
    properties(Dependent)
        configType
        configClass
        siteId
        datasetId
    end
    methods
        function obj = ExchangeStorage(varargin)
            obj@flywheel.ModelBase(flywheel.model.ExchangeStorage.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'configType', &#x27;exchange&#x27;);
                addParameter(p, 'configClass', &#x27;storage&#x27;);
                addParameter(p, 'siteId', []);
                addParameter(p, 'datasetId', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.configType)
                    obj.props_('config_type') = p.Results.configType;
                end
                if ~isempty(p.Results.configClass)
                    obj.props_('config_class') = p.Results.configClass;
                end
                if ~isempty(p.Results.siteId)
                    obj.props_('site_id') = p.Results.siteId;
                end
                if ~isempty(p.Results.datasetId)
                    obj.props_('dataset_id') = p.Results.datasetId;
                end
            end
        end
        function result = get.configType(obj)
            if ismethod(obj, 'get_configType')
                result = obj.get_configType();
            else
                if isKey(obj.props_, 'config_type')
                    result = obj.props_('config_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.configType(obj, value)
            obj.props_('config_type') = value;
        end
        function result = get.configClass(obj)
            if ismethod(obj, 'get_configClass')
                result = obj.get_configClass();
            else
                if isKey(obj.props_, 'config_class')
                    result = obj.props_('config_class');
                else
                    result = [];
                end
            end
        end
        function obj = set.configClass(obj, value)
            obj.props_('config_class') = value;
        end
        function result = get.siteId(obj)
            if ismethod(obj, 'get_siteId')
                result = obj.get_siteId();
            else
                if isKey(obj.props_, 'site_id')
                    result = obj.props_('site_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.siteId(obj, value)
            obj.props_('site_id') = value;
        end
        function result = get.datasetId(obj)
            if ismethod(obj, 'get_datasetId')
                result = obj.get_datasetId();
            else
                if isKey(obj.props_, 'dataset_id')
                    result = obj.props_('dataset_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.datasetId(obj, value)
            obj.props_('dataset_id') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'config_type')
                result('config_type') = flywheel.ModelBase.serializeValue(obj.props_('config_type'), 'char');
            end
            if isKey(obj.props_, 'config_class')
                result('config_class') = flywheel.ModelBase.serializeValue(obj.props_('config_class'), 'char');
            end
            if isKey(obj.props_, 'site_id')
                result('site_id') = flywheel.ModelBase.serializeValue(obj.props_('site_id'), 'char');
            end
            if isKey(obj.props_, 'dataset_id')
                result('dataset_id') = flywheel.ModelBase.serializeValue(obj.props_('dataset_id'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'config_type')
                result.configType = obj.props_('config_type');
            else
                result.configType = [];
            end
            if isKey(obj.props_, 'config_class')
                result.configClass = obj.props_('config_class');
            else
                result.configClass = [];
            end
            if isKey(obj.props_, 'site_id')
                result.siteId = obj.props_('site_id');
            else
                result.siteId = [];
            end
            if isKey(obj.props_, 'dataset_id')
                result.datasetId = obj.props_('dataset_id');
            else
                result.datasetId = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'config_type')
                    propList.configType = obj.props_('config_type');
                else
                    propList.configType = [];
                end
                if isKey(obj.props_, 'config_class')
                    propList.configClass = obj.props_('config_class');
                else
                    propList.configClass = [];
                end
                if isKey(obj.props_, 'site_id')
                    propList.siteId = obj.props_('site_id');
                else
                    propList.siteId = [];
                end
                if isKey(obj.props_, 'dataset_id')
                    propList.datasetId = obj.props_('dataset_id');
                else
                    propList.datasetId = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ExchangeStorage;
            if isfield(json, 'config_type')
                obj.props_('config_type') = flywheel.ModelBase.deserializeValue(json.config_type, 'char');
            end
            if isfield(json, 'config_class')
                obj.props_('config_class') = flywheel.ModelBase.deserializeValue(json.config_class, 'char');
            end
            if isfield(json, 'site_id')
                obj.props_('site_id') = flywheel.ModelBase.deserializeValue(json.site_id, 'char');
            end
            if isfield(json, 'dataset_id')
                obj.props_('dataset_id') = flywheel.ModelBase.deserializeValue(json.dataset_id, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ExchangeStorage')
                    obj = flywheel.model.ExchangeStorage(obj);
                end
                if isKey(obj.props_, 'config_type')
                end
                if isKey(obj.props_, 'config_class')
                end
                if isKey(obj.props_, 'site_id')
                end
                if isKey(obj.props_, 'dataset_id')
                end
            end
        end
    end
end
