% ExportTemplates - Contains export templates for data files and container data.
%
% ExportTemplates Properties:
%    file      
%    hierarchy 
%
% ExportTemplates Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ExportTemplates < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'file', 'hierarchy' }, ...
            { 'file', 'hierarchy' });
    end
    properties(Dependent)
        file
        hierarchy
    end
    methods
        function obj = ExportTemplates(varargin)
            obj@flywheel.ModelBase(flywheel.model.ExportTemplates.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'file', []);
                addParameter(p, 'hierarchy', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.file)
                    obj.props_('file') = p.Results.file;
                end
                if ~isempty(p.Results.hierarchy)
                    obj.props_('hierarchy') = p.Results.hierarchy;
                end
            end
        end
        function result = get.file(obj)
            if ismethod(obj, 'get_file')
                result = obj.get_file();
            else
                if isKey(obj.props_, 'file')
                    result = obj.props_('file');
                else
                    result = [];
                end
            end
        end
        function obj = set.file(obj, value)
            obj.props_('file') = value;
        end
        function result = get.hierarchy(obj)
            if ismethod(obj, 'get_hierarchy')
                result = obj.get_hierarchy();
            else
                if isKey(obj.props_, 'hierarchy')
                    result = obj.props_('hierarchy');
                else
                    result = [];
                end
            end
        end
        function obj = set.hierarchy(obj, value)
            obj.props_('hierarchy') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'file')
                result('file') = obj.props_('file').toJson();
            end
            if isKey(obj.props_, 'hierarchy')
                result('hierarchy') = obj.props_('hierarchy').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'file')
                result.file = struct(obj.props_('file'));
            else
                result.file = [];
            end
            if isKey(obj.props_, 'hierarchy')
                result.hierarchy = struct(obj.props_('hierarchy'));
            else
                result.hierarchy = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'file')
                    propList.file = obj.props_('file');
                else
                    propList.file = [];
                end
                if isKey(obj.props_, 'hierarchy')
                    propList.hierarchy = obj.props_('hierarchy');
                else
                    propList.hierarchy = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ExportTemplates;
            if isfield(json, 'file')
                obj.props_('file') = flywheel.model.FileExportTemplates.fromJson(json.file, context);
            end
            if isfield(json, 'hierarchy')
                obj.props_('hierarchy') = flywheel.model.HierarchyExportTemplates.fromJson(json.hierarchy, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ExportTemplates')
                    obj = flywheel.model.ExportTemplates(obj);
                end
                if isKey(obj.props_, 'file')
                    obj.props_('file') =  flywheel.model.FileExportTemplates.ensureIsInstance(obj.props_('file'));
                end
                if isKey(obj.props_, 'hierarchy')
                    obj.props_('hierarchy') =  flywheel.model.HierarchyExportTemplates.ensureIsInstance(obj.props_('hierarchy'));
                end
            end
        end
    end
end
