% Features
%
% Features Properties:
%    apiEnabledGearRules       
%    auth0                     
%    auditTrail                
%    azuremlIntegration        
%    coldJobLogs               
%    collections               
%    copyByReference           
%    coreApi                   
%    crawler                   
%    dataViewsNon21Cfr         
%    defaultViewerApps         
%    deidLog                   
%    deidProfile               
%    dicomWebUploaderNon21Cfr  
%    dimse                     
%    elasticSearchPrimary      
%    exchange                  
%    exchangeAdmin             
%    externalRouting           
%    gearAccess                
%    googleAnalytics           
%    healthcareApi             
%    jobAsk                    
%    jobPrioritization         
%    jobTickets                
%    jupyterIntegration        
%    jupyterhubExternalStorage 
%    ldapSync                  
%    multifactorAuth           
%    multipartSignedUrl        
%    multiproject              
%    ohifMultiSubjectView      
%    ohifMeteor                
%    ohifReact                 
%    ohifReactBeta             
%    ohifSliceOrder            
%    ohifV2AdhocIndexing       
%    ohifV3                    
%    ohifV3Beta                
%    ohifV3DefaultApp          
%    ohifV3Readonly            
%    projectExport             
%    projectImport             
%    projectListUsesStats      
%    projectLocking            
%    readerTasks               
%    rtsSync                   
%    sentryLogging             
%    sessionTemplatesNon21Cfr  
%    sharedProjects            
%    signedUrl                 
%    studyTaskStatus           
%    tagging                   
%    tagsInLists               
%    taskManagerDataViews      
%    transformSearchFields     
%    unsafeLogin               
%    urlAccessApps             
%    userpilot                 
%    validateClassification    
%    virusScan                 
%    legacyDicomUploader       
%
% Features Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Features < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'apiEnabledGearRules', 'auth0', 'auditTrail', 'azuremlIntegration', 'coldJobLogs', 'collections', 'copyByReference', 'coreApi', 'crawler', 'dataViewsNon21Cfr', 'defaultViewerApps', 'deidLog', 'deidProfile', 'dicomWebUploaderNon21Cfr', 'dimse', 'elasticSearchPrimary', 'exchange', 'exchangeAdmin', 'externalRouting', 'gearAccess', 'googleAnalytics', 'healthcareApi', 'jobAsk', 'jobPrioritization', 'jobTickets', 'jupyterIntegration', 'jupyterhubExternalStorage', 'ldapSync', 'multifactorAuth', 'multipartSignedUrl', 'multiproject', 'ohifMultiSubjectView', 'ohifMeteor', 'ohifReact', 'ohifReactBeta', 'ohifSliceOrder', 'ohifV2AdhocIndexing', 'ohifV3', 'ohifV3Beta', 'ohifV3DefaultApp', 'ohifV3Readonly', 'projectExport', 'projectImport', 'projectListUsesStats', 'projectLocking', 'readerTasks', 'rtsSync', 'sentryLogging', 'sessionTemplatesNon21Cfr', 'sharedProjects', 'signedUrl', 'studyTaskStatus', 'tagging', 'tagsInLists', 'taskManagerDataViews', 'transformSearchFields', 'unsafeLogin', 'urlAccessApps', 'userpilot', 'validateClassification', 'virusScan', 'legacyDicomUploader' }, ...
            { 'api_enabled_gear_rules', 'auth0', 'audit_trail', 'azureml_integration', 'cold_job_logs', 'collections', 'copy_by_reference', 'core_api', 'crawler', 'data_views_non_21CFR', 'default_viewer_apps', 'deid_log', 'deid_profile', 'dicom_web_uploader_non_21CFR', 'dimse', 'elastic_search_primary', 'exchange', 'exchange_admin', 'external_routing', 'gear_access', 'google_analytics', 'healthcare_api', 'job_ask', 'job_prioritization', 'job_tickets', 'jupyter_integration', 'jupyterhub_external_storage', 'ldap_sync', 'multifactor_auth', 'multipart_signed_url', 'multiproject', 'ohif_multi_subject_view', 'ohif_meteor', 'ohif_react', 'ohif_react_beta', 'ohif_slice_order', 'ohif_v2_adhoc_indexing', 'ohif_v3', 'ohif_v3_beta', 'ohif_v3_default_app', 'ohif_v3_readonly', 'project_export', 'project_import', 'project_list_uses_stats', 'project_locking', 'reader_tasks', 'rts_sync', 'sentry_logging', 'session_templates_non_21CFR', 'shared_projects', 'signed_url', 'study_task_status', 'tagging', 'tags_in_lists', 'task_manager_data_views', 'transform_search_fields', 'unsafe_login', 'url_access_apps', 'userpilot', 'validate_classification', 'virus_scan', 'legacy_dicom_uploader' });
    end
    properties(Dependent)
        apiEnabledGearRules
        auth0
        auditTrail
        azuremlIntegration
        coldJobLogs
        collections
        copyByReference
        coreApi
        crawler
        dataViewsNon21Cfr
        defaultViewerApps
        deidLog
        deidProfile
        dicomWebUploaderNon21Cfr
        dimse
        elasticSearchPrimary
        exchange
        exchangeAdmin
        externalRouting
        gearAccess
        googleAnalytics
        healthcareApi
        jobAsk
        jobPrioritization
        jobTickets
        jupyterIntegration
        jupyterhubExternalStorage
        ldapSync
        multifactorAuth
        multipartSignedUrl
        multiproject
        ohifMultiSubjectView
        ohifMeteor
        ohifReact
        ohifReactBeta
        ohifSliceOrder
        ohifV2AdhocIndexing
        ohifV3
        ohifV3Beta
        ohifV3DefaultApp
        ohifV3Readonly
        projectExport
        projectImport
        projectListUsesStats
        projectLocking
        readerTasks
        rtsSync
        sentryLogging
        sessionTemplatesNon21Cfr
        sharedProjects
        signedUrl
        studyTaskStatus
        tagging
        tagsInLists
        taskManagerDataViews
        transformSearchFields
        unsafeLogin
        urlAccessApps
        userpilot
        validateClassification
        virusScan
        legacyDicomUploader
    end
    methods
        function obj = Features(varargin)
            obj@flywheel.ModelBase(flywheel.model.Features.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'apiEnabledGearRules', true);
                addParameter(p, 'auth0', []);
                addParameter(p, 'auditTrail', false);
                addParameter(p, 'azuremlIntegration', false);
                addParameter(p, 'coldJobLogs', false);
                addParameter(p, 'collections', false);
                addParameter(p, 'copyByReference', true);
                addParameter(p, 'coreApi', true);
                addParameter(p, 'crawler', false);
                addParameter(p, 'dataViewsNon21Cfr', true);
                addParameter(p, 'defaultViewerApps', true);
                addParameter(p, 'deidLog', false);
                addParameter(p, 'deidProfile', false);
                addParameter(p, 'dicomWebUploaderNon21Cfr', true);
                addParameter(p, 'dimse', false);
                addParameter(p, 'elasticSearchPrimary', false);
                addParameter(p, 'exchange', false);
                addParameter(p, 'exchangeAdmin', false);
                addParameter(p, 'externalRouting', false);
                addParameter(p, 'gearAccess', true);
                addParameter(p, 'googleAnalytics', true);
                addParameter(p, 'healthcareApi', false);
                addParameter(p, 'jobAsk', true);
                addParameter(p, 'jobPrioritization', true);
                addParameter(p, 'jobTickets', true);
                addParameter(p, 'jupyterIntegration', false);
                addParameter(p, 'jupyterhubExternalStorage', true);
                addParameter(p, 'ldapSync', false);
                addParameter(p, 'multifactorAuth', false);
                addParameter(p, 'multipartSignedUrl', true);
                addParameter(p, 'multiproject', false);
                addParameter(p, 'ohifMultiSubjectView', false);
                addParameter(p, 'ohifMeteor', false);
                addParameter(p, 'ohifReact', false);
                addParameter(p, 'ohifReactBeta', false);
                addParameter(p, 'ohifSliceOrder', []);
                addParameter(p, 'ohifV2AdhocIndexing', true);
                addParameter(p, 'ohifV3', true);
                addParameter(p, 'ohifV3Beta', false);
                addParameter(p, 'ohifV3DefaultApp', false);
                addParameter(p, 'ohifV3Readonly', false);
                addParameter(p, 'projectExport', true);
                addParameter(p, 'projectImport', true);
                addParameter(p, 'projectListUsesStats', false);
                addParameter(p, 'projectLocking', false);
                addParameter(p, 'readerTasks', false);
                addParameter(p, 'rtsSync', false);
                addParameter(p, 'sentryLogging', []);
                addParameter(p, 'sessionTemplatesNon21Cfr', true);
                addParameter(p, 'sharedProjects', false);
                addParameter(p, 'signedUrl', false);
                addParameter(p, 'studyTaskStatus', false);
                addParameter(p, 'tagging', false);
                addParameter(p, 'tagsInLists', true);
                addParameter(p, 'taskManagerDataViews', true);
                addParameter(p, 'transformSearchFields', true);
                addParameter(p, 'unsafeLogin', false);
                addParameter(p, 'urlAccessApps', false);
                addParameter(p, 'userpilot', []);
                addParameter(p, 'validateClassification', false);
                addParameter(p, 'virusScan', false);
                addParameter(p, 'legacyDicomUploader', false);

                parse(p, varargin{:});

                if ~isempty(p.Results.apiEnabledGearRules)
                    obj.props_('api_enabled_gear_rules') = p.Results.apiEnabledGearRules;
                end
                if ~isempty(p.Results.auth0)
                    obj.props_('auth0') = p.Results.auth0;
                end
                if ~isempty(p.Results.auditTrail)
                    obj.props_('audit_trail') = p.Results.auditTrail;
                end
                if ~isempty(p.Results.azuremlIntegration)
                    obj.props_('azureml_integration') = p.Results.azuremlIntegration;
                end
                if ~isempty(p.Results.coldJobLogs)
                    obj.props_('cold_job_logs') = p.Results.coldJobLogs;
                end
                if ~isempty(p.Results.collections)
                    obj.props_('collections') = p.Results.collections;
                end
                if ~isempty(p.Results.copyByReference)
                    obj.props_('copy_by_reference') = p.Results.copyByReference;
                end
                if ~isempty(p.Results.coreApi)
                    obj.props_('core_api') = p.Results.coreApi;
                end
                if ~isempty(p.Results.crawler)
                    obj.props_('crawler') = p.Results.crawler;
                end
                if ~isempty(p.Results.dataViewsNon21Cfr)
                    obj.props_('data_views_non_21CFR') = p.Results.dataViewsNon21Cfr;
                end
                if ~isempty(p.Results.defaultViewerApps)
                    obj.props_('default_viewer_apps') = p.Results.defaultViewerApps;
                end
                if ~isempty(p.Results.deidLog)
                    obj.props_('deid_log') = p.Results.deidLog;
                end
                if ~isempty(p.Results.deidProfile)
                    obj.props_('deid_profile') = p.Results.deidProfile;
                end
                if ~isempty(p.Results.dicomWebUploaderNon21Cfr)
                    obj.props_('dicom_web_uploader_non_21CFR') = p.Results.dicomWebUploaderNon21Cfr;
                end
                if ~isempty(p.Results.dimse)
                    obj.props_('dimse') = p.Results.dimse;
                end
                if ~isempty(p.Results.elasticSearchPrimary)
                    obj.props_('elastic_search_primary') = p.Results.elasticSearchPrimary;
                end
                if ~isempty(p.Results.exchange)
                    obj.props_('exchange') = p.Results.exchange;
                end
                if ~isempty(p.Results.exchangeAdmin)
                    obj.props_('exchange_admin') = p.Results.exchangeAdmin;
                end
                if ~isempty(p.Results.externalRouting)
                    obj.props_('external_routing') = p.Results.externalRouting;
                end
                if ~isempty(p.Results.gearAccess)
                    obj.props_('gear_access') = p.Results.gearAccess;
                end
                if ~isempty(p.Results.googleAnalytics)
                    obj.props_('google_analytics') = p.Results.googleAnalytics;
                end
                if ~isempty(p.Results.healthcareApi)
                    obj.props_('healthcare_api') = p.Results.healthcareApi;
                end
                if ~isempty(p.Results.jobAsk)
                    obj.props_('job_ask') = p.Results.jobAsk;
                end
                if ~isempty(p.Results.jobPrioritization)
                    obj.props_('job_prioritization') = p.Results.jobPrioritization;
                end
                if ~isempty(p.Results.jobTickets)
                    obj.props_('job_tickets') = p.Results.jobTickets;
                end
                if ~isempty(p.Results.jupyterIntegration)
                    obj.props_('jupyter_integration') = p.Results.jupyterIntegration;
                end
                if ~isempty(p.Results.jupyterhubExternalStorage)
                    obj.props_('jupyterhub_external_storage') = p.Results.jupyterhubExternalStorage;
                end
                if ~isempty(p.Results.ldapSync)
                    obj.props_('ldap_sync') = p.Results.ldapSync;
                end
                if ~isempty(p.Results.multifactorAuth)
                    obj.props_('multifactor_auth') = p.Results.multifactorAuth;
                end
                if ~isempty(p.Results.multipartSignedUrl)
                    obj.props_('multipart_signed_url') = p.Results.multipartSignedUrl;
                end
                if ~isempty(p.Results.multiproject)
                    obj.props_('multiproject') = p.Results.multiproject;
                end
                if ~isempty(p.Results.ohifMultiSubjectView)
                    obj.props_('ohif_multi_subject_view') = p.Results.ohifMultiSubjectView;
                end
                if ~isempty(p.Results.ohifMeteor)
                    obj.props_('ohif_meteor') = p.Results.ohifMeteor;
                end
                if ~isempty(p.Results.ohifReact)
                    obj.props_('ohif_react') = p.Results.ohifReact;
                end
                if ~isempty(p.Results.ohifReactBeta)
                    obj.props_('ohif_react_beta') = p.Results.ohifReactBeta;
                end
                if ~isempty(p.Results.ohifSliceOrder)
                    obj.props_('ohif_slice_order') = p.Results.ohifSliceOrder;
                end
                if ~isempty(p.Results.ohifV2AdhocIndexing)
                    obj.props_('ohif_v2_adhoc_indexing') = p.Results.ohifV2AdhocIndexing;
                end
                if ~isempty(p.Results.ohifV3)
                    obj.props_('ohif_v3') = p.Results.ohifV3;
                end
                if ~isempty(p.Results.ohifV3Beta)
                    obj.props_('ohif_v3_beta') = p.Results.ohifV3Beta;
                end
                if ~isempty(p.Results.ohifV3DefaultApp)
                    obj.props_('ohif_v3_default_app') = p.Results.ohifV3DefaultApp;
                end
                if ~isempty(p.Results.ohifV3Readonly)
                    obj.props_('ohif_v3_readonly') = p.Results.ohifV3Readonly;
                end
                if ~isempty(p.Results.projectExport)
                    obj.props_('project_export') = p.Results.projectExport;
                end
                if ~isempty(p.Results.projectImport)
                    obj.props_('project_import') = p.Results.projectImport;
                end
                if ~isempty(p.Results.projectListUsesStats)
                    obj.props_('project_list_uses_stats') = p.Results.projectListUsesStats;
                end
                if ~isempty(p.Results.projectLocking)
                    obj.props_('project_locking') = p.Results.projectLocking;
                end
                if ~isempty(p.Results.readerTasks)
                    obj.props_('reader_tasks') = p.Results.readerTasks;
                end
                if ~isempty(p.Results.rtsSync)
                    obj.props_('rts_sync') = p.Results.rtsSync;
                end
                if ~isempty(p.Results.sentryLogging)
                    obj.props_('sentry_logging') = p.Results.sentryLogging;
                end
                if ~isempty(p.Results.sessionTemplatesNon21Cfr)
                    obj.props_('session_templates_non_21CFR') = p.Results.sessionTemplatesNon21Cfr;
                end
                if ~isempty(p.Results.sharedProjects)
                    obj.props_('shared_projects') = p.Results.sharedProjects;
                end
                if ~isempty(p.Results.signedUrl)
                    obj.props_('signed_url') = p.Results.signedUrl;
                end
                if ~isempty(p.Results.studyTaskStatus)
                    obj.props_('study_task_status') = p.Results.studyTaskStatus;
                end
                if ~isempty(p.Results.tagging)
                    obj.props_('tagging') = p.Results.tagging;
                end
                if ~isempty(p.Results.tagsInLists)
                    obj.props_('tags_in_lists') = p.Results.tagsInLists;
                end
                if ~isempty(p.Results.taskManagerDataViews)
                    obj.props_('task_manager_data_views') = p.Results.taskManagerDataViews;
                end
                if ~isempty(p.Results.transformSearchFields)
                    obj.props_('transform_search_fields') = p.Results.transformSearchFields;
                end
                if ~isempty(p.Results.unsafeLogin)
                    obj.props_('unsafe_login') = p.Results.unsafeLogin;
                end
                if ~isempty(p.Results.urlAccessApps)
                    obj.props_('url_access_apps') = p.Results.urlAccessApps;
                end
                if ~isempty(p.Results.userpilot)
                    obj.props_('userpilot') = p.Results.userpilot;
                end
                if ~isempty(p.Results.validateClassification)
                    obj.props_('validate_classification') = p.Results.validateClassification;
                end
                if ~isempty(p.Results.virusScan)
                    obj.props_('virus_scan') = p.Results.virusScan;
                end
                if ~isempty(p.Results.legacyDicomUploader)
                    obj.props_('legacy_dicom_uploader') = p.Results.legacyDicomUploader;
                end
            end
        end
        function result = get.apiEnabledGearRules(obj)
            if ismethod(obj, 'get_apiEnabledGearRules')
                result = obj.get_apiEnabledGearRules();
            else
                if isKey(obj.props_, 'api_enabled_gear_rules')
                    result = obj.props_('api_enabled_gear_rules');
                else
                    result = [];
                end
            end
        end
        function obj = set.apiEnabledGearRules(obj, value)
            obj.props_('api_enabled_gear_rules') = value;
        end
        function result = get.auth0(obj)
            if ismethod(obj, 'get_auth0')
                result = obj.get_auth0();
            else
                if isKey(obj.props_, 'auth0')
                    result = obj.props_('auth0');
                else
                    result = [];
                end
            end
        end
        function obj = set.auth0(obj, value)
            obj.props_('auth0') = value;
        end
        function result = get.auditTrail(obj)
            if ismethod(obj, 'get_auditTrail')
                result = obj.get_auditTrail();
            else
                if isKey(obj.props_, 'audit_trail')
                    result = obj.props_('audit_trail');
                else
                    result = [];
                end
            end
        end
        function obj = set.auditTrail(obj, value)
            obj.props_('audit_trail') = value;
        end
        function result = get.azuremlIntegration(obj)
            if ismethod(obj, 'get_azuremlIntegration')
                result = obj.get_azuremlIntegration();
            else
                if isKey(obj.props_, 'azureml_integration')
                    result = obj.props_('azureml_integration');
                else
                    result = [];
                end
            end
        end
        function obj = set.azuremlIntegration(obj, value)
            obj.props_('azureml_integration') = value;
        end
        function result = get.coldJobLogs(obj)
            if ismethod(obj, 'get_coldJobLogs')
                result = obj.get_coldJobLogs();
            else
                if isKey(obj.props_, 'cold_job_logs')
                    result = obj.props_('cold_job_logs');
                else
                    result = [];
                end
            end
        end
        function obj = set.coldJobLogs(obj, value)
            obj.props_('cold_job_logs') = value;
        end
        function result = get.collections(obj)
            if ismethod(obj, 'get_collections')
                result = obj.get_collections();
            else
                if isKey(obj.props_, 'collections')
                    result = obj.props_('collections');
                else
                    result = [];
                end
            end
        end
        function obj = set.collections(obj, value)
            obj.props_('collections') = value;
        end
        function result = get.copyByReference(obj)
            if ismethod(obj, 'get_copyByReference')
                result = obj.get_copyByReference();
            else
                if isKey(obj.props_, 'copy_by_reference')
                    result = obj.props_('copy_by_reference');
                else
                    result = [];
                end
            end
        end
        function obj = set.copyByReference(obj, value)
            obj.props_('copy_by_reference') = value;
        end
        function result = get.coreApi(obj)
            if ismethod(obj, 'get_coreApi')
                result = obj.get_coreApi();
            else
                if isKey(obj.props_, 'core_api')
                    result = obj.props_('core_api');
                else
                    result = [];
                end
            end
        end
        function obj = set.coreApi(obj, value)
            obj.props_('core_api') = value;
        end
        function result = get.crawler(obj)
            if ismethod(obj, 'get_crawler')
                result = obj.get_crawler();
            else
                if isKey(obj.props_, 'crawler')
                    result = obj.props_('crawler');
                else
                    result = [];
                end
            end
        end
        function obj = set.crawler(obj, value)
            obj.props_('crawler') = value;
        end
        function result = get.dataViewsNon21Cfr(obj)
            if ismethod(obj, 'get_dataViewsNon21Cfr')
                result = obj.get_dataViewsNon21Cfr();
            else
                if isKey(obj.props_, 'data_views_non_21CFR')
                    result = obj.props_('data_views_non_21CFR');
                else
                    result = [];
                end
            end
        end
        function obj = set.dataViewsNon21Cfr(obj, value)
            obj.props_('data_views_non_21CFR') = value;
        end
        function result = get.defaultViewerApps(obj)
            if ismethod(obj, 'get_defaultViewerApps')
                result = obj.get_defaultViewerApps();
            else
                if isKey(obj.props_, 'default_viewer_apps')
                    result = obj.props_('default_viewer_apps');
                else
                    result = [];
                end
            end
        end
        function obj = set.defaultViewerApps(obj, value)
            obj.props_('default_viewer_apps') = value;
        end
        function result = get.deidLog(obj)
            if ismethod(obj, 'get_deidLog')
                result = obj.get_deidLog();
            else
                if isKey(obj.props_, 'deid_log')
                    result = obj.props_('deid_log');
                else
                    result = [];
                end
            end
        end
        function obj = set.deidLog(obj, value)
            obj.props_('deid_log') = value;
        end
        function result = get.deidProfile(obj)
            if ismethod(obj, 'get_deidProfile')
                result = obj.get_deidProfile();
            else
                if isKey(obj.props_, 'deid_profile')
                    result = obj.props_('deid_profile');
                else
                    result = [];
                end
            end
        end
        function obj = set.deidProfile(obj, value)
            obj.props_('deid_profile') = value;
        end
        function result = get.dicomWebUploaderNon21Cfr(obj)
            if ismethod(obj, 'get_dicomWebUploaderNon21Cfr')
                result = obj.get_dicomWebUploaderNon21Cfr();
            else
                if isKey(obj.props_, 'dicom_web_uploader_non_21CFR')
                    result = obj.props_('dicom_web_uploader_non_21CFR');
                else
                    result = [];
                end
            end
        end
        function obj = set.dicomWebUploaderNon21Cfr(obj, value)
            obj.props_('dicom_web_uploader_non_21CFR') = value;
        end
        function result = get.dimse(obj)
            if ismethod(obj, 'get_dimse')
                result = obj.get_dimse();
            else
                if isKey(obj.props_, 'dimse')
                    result = obj.props_('dimse');
                else
                    result = [];
                end
            end
        end
        function obj = set.dimse(obj, value)
            obj.props_('dimse') = value;
        end
        function result = get.elasticSearchPrimary(obj)
            if ismethod(obj, 'get_elasticSearchPrimary')
                result = obj.get_elasticSearchPrimary();
            else
                if isKey(obj.props_, 'elastic_search_primary')
                    result = obj.props_('elastic_search_primary');
                else
                    result = [];
                end
            end
        end
        function obj = set.elasticSearchPrimary(obj, value)
            obj.props_('elastic_search_primary') = value;
        end
        function result = get.exchange(obj)
            if ismethod(obj, 'get_exchange')
                result = obj.get_exchange();
            else
                if isKey(obj.props_, 'exchange')
                    result = obj.props_('exchange');
                else
                    result = [];
                end
            end
        end
        function obj = set.exchange(obj, value)
            obj.props_('exchange') = value;
        end
        function result = get.exchangeAdmin(obj)
            if ismethod(obj, 'get_exchangeAdmin')
                result = obj.get_exchangeAdmin();
            else
                if isKey(obj.props_, 'exchange_admin')
                    result = obj.props_('exchange_admin');
                else
                    result = [];
                end
            end
        end
        function obj = set.exchangeAdmin(obj, value)
            obj.props_('exchange_admin') = value;
        end
        function result = get.externalRouting(obj)
            if ismethod(obj, 'get_externalRouting')
                result = obj.get_externalRouting();
            else
                if isKey(obj.props_, 'external_routing')
                    result = obj.props_('external_routing');
                else
                    result = [];
                end
            end
        end
        function obj = set.externalRouting(obj, value)
            obj.props_('external_routing') = value;
        end
        function result = get.gearAccess(obj)
            if ismethod(obj, 'get_gearAccess')
                result = obj.get_gearAccess();
            else
                if isKey(obj.props_, 'gear_access')
                    result = obj.props_('gear_access');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearAccess(obj, value)
            obj.props_('gear_access') = value;
        end
        function result = get.googleAnalytics(obj)
            if ismethod(obj, 'get_googleAnalytics')
                result = obj.get_googleAnalytics();
            else
                if isKey(obj.props_, 'google_analytics')
                    result = obj.props_('google_analytics');
                else
                    result = [];
                end
            end
        end
        function obj = set.googleAnalytics(obj, value)
            obj.props_('google_analytics') = value;
        end
        function result = get.healthcareApi(obj)
            if ismethod(obj, 'get_healthcareApi')
                result = obj.get_healthcareApi();
            else
                if isKey(obj.props_, 'healthcare_api')
                    result = obj.props_('healthcare_api');
                else
                    result = [];
                end
            end
        end
        function obj = set.healthcareApi(obj, value)
            obj.props_('healthcare_api') = value;
        end
        function result = get.jobAsk(obj)
            if ismethod(obj, 'get_jobAsk')
                result = obj.get_jobAsk();
            else
                if isKey(obj.props_, 'job_ask')
                    result = obj.props_('job_ask');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobAsk(obj, value)
            obj.props_('job_ask') = value;
        end
        function result = get.jobPrioritization(obj)
            if ismethod(obj, 'get_jobPrioritization')
                result = obj.get_jobPrioritization();
            else
                if isKey(obj.props_, 'job_prioritization')
                    result = obj.props_('job_prioritization');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobPrioritization(obj, value)
            obj.props_('job_prioritization') = value;
        end
        function result = get.jobTickets(obj)
            if ismethod(obj, 'get_jobTickets')
                result = obj.get_jobTickets();
            else
                if isKey(obj.props_, 'job_tickets')
                    result = obj.props_('job_tickets');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobTickets(obj, value)
            obj.props_('job_tickets') = value;
        end
        function result = get.jupyterIntegration(obj)
            if ismethod(obj, 'get_jupyterIntegration')
                result = obj.get_jupyterIntegration();
            else
                if isKey(obj.props_, 'jupyter_integration')
                    result = obj.props_('jupyter_integration');
                else
                    result = [];
                end
            end
        end
        function obj = set.jupyterIntegration(obj, value)
            obj.props_('jupyter_integration') = value;
        end
        function result = get.jupyterhubExternalStorage(obj)
            if ismethod(obj, 'get_jupyterhubExternalStorage')
                result = obj.get_jupyterhubExternalStorage();
            else
                if isKey(obj.props_, 'jupyterhub_external_storage')
                    result = obj.props_('jupyterhub_external_storage');
                else
                    result = [];
                end
            end
        end
        function obj = set.jupyterhubExternalStorage(obj, value)
            obj.props_('jupyterhub_external_storage') = value;
        end
        function result = get.ldapSync(obj)
            if ismethod(obj, 'get_ldapSync')
                result = obj.get_ldapSync();
            else
                if isKey(obj.props_, 'ldap_sync')
                    result = obj.props_('ldap_sync');
                else
                    result = [];
                end
            end
        end
        function obj = set.ldapSync(obj, value)
            obj.props_('ldap_sync') = value;
        end
        function result = get.multifactorAuth(obj)
            if ismethod(obj, 'get_multifactorAuth')
                result = obj.get_multifactorAuth();
            else
                if isKey(obj.props_, 'multifactor_auth')
                    result = obj.props_('multifactor_auth');
                else
                    result = [];
                end
            end
        end
        function obj = set.multifactorAuth(obj, value)
            obj.props_('multifactor_auth') = value;
        end
        function result = get.multipartSignedUrl(obj)
            if ismethod(obj, 'get_multipartSignedUrl')
                result = obj.get_multipartSignedUrl();
            else
                if isKey(obj.props_, 'multipart_signed_url')
                    result = obj.props_('multipart_signed_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.multipartSignedUrl(obj, value)
            obj.props_('multipart_signed_url') = value;
        end
        function result = get.multiproject(obj)
            if ismethod(obj, 'get_multiproject')
                result = obj.get_multiproject();
            else
                if isKey(obj.props_, 'multiproject')
                    result = obj.props_('multiproject');
                else
                    result = [];
                end
            end
        end
        function obj = set.multiproject(obj, value)
            obj.props_('multiproject') = value;
        end
        function result = get.ohifMultiSubjectView(obj)
            if ismethod(obj, 'get_ohifMultiSubjectView')
                result = obj.get_ohifMultiSubjectView();
            else
                if isKey(obj.props_, 'ohif_multi_subject_view')
                    result = obj.props_('ohif_multi_subject_view');
                else
                    result = [];
                end
            end
        end
        function obj = set.ohifMultiSubjectView(obj, value)
            obj.props_('ohif_multi_subject_view') = value;
        end
        function result = get.ohifMeteor(obj)
            if ismethod(obj, 'get_ohifMeteor')
                result = obj.get_ohifMeteor();
            else
                if isKey(obj.props_, 'ohif_meteor')
                    result = obj.props_('ohif_meteor');
                else
                    result = [];
                end
            end
        end
        function obj = set.ohifMeteor(obj, value)
            obj.props_('ohif_meteor') = value;
        end
        function result = get.ohifReact(obj)
            if ismethod(obj, 'get_ohifReact')
                result = obj.get_ohifReact();
            else
                if isKey(obj.props_, 'ohif_react')
                    result = obj.props_('ohif_react');
                else
                    result = [];
                end
            end
        end
        function obj = set.ohifReact(obj, value)
            obj.props_('ohif_react') = value;
        end
        function result = get.ohifReactBeta(obj)
            if ismethod(obj, 'get_ohifReactBeta')
                result = obj.get_ohifReactBeta();
            else
                if isKey(obj.props_, 'ohif_react_beta')
                    result = obj.props_('ohif_react_beta');
                else
                    result = [];
                end
            end
        end
        function obj = set.ohifReactBeta(obj, value)
            obj.props_('ohif_react_beta') = value;
        end
        function result = get.ohifSliceOrder(obj)
            if ismethod(obj, 'get_ohifSliceOrder')
                result = obj.get_ohifSliceOrder();
            else
                if isKey(obj.props_, 'ohif_slice_order')
                    result = obj.props_('ohif_slice_order');
                else
                    result = [];
                end
            end
        end
        function obj = set.ohifSliceOrder(obj, value)
            obj.props_('ohif_slice_order') = value;
        end
        function result = get.ohifV2AdhocIndexing(obj)
            if ismethod(obj, 'get_ohifV2AdhocIndexing')
                result = obj.get_ohifV2AdhocIndexing();
            else
                if isKey(obj.props_, 'ohif_v2_adhoc_indexing')
                    result = obj.props_('ohif_v2_adhoc_indexing');
                else
                    result = [];
                end
            end
        end
        function obj = set.ohifV2AdhocIndexing(obj, value)
            obj.props_('ohif_v2_adhoc_indexing') = value;
        end
        function result = get.ohifV3(obj)
            if ismethod(obj, 'get_ohifV3')
                result = obj.get_ohifV3();
            else
                if isKey(obj.props_, 'ohif_v3')
                    result = obj.props_('ohif_v3');
                else
                    result = [];
                end
            end
        end
        function obj = set.ohifV3(obj, value)
            obj.props_('ohif_v3') = value;
        end
        function result = get.ohifV3Beta(obj)
            if ismethod(obj, 'get_ohifV3Beta')
                result = obj.get_ohifV3Beta();
            else
                if isKey(obj.props_, 'ohif_v3_beta')
                    result = obj.props_('ohif_v3_beta');
                else
                    result = [];
                end
            end
        end
        function obj = set.ohifV3Beta(obj, value)
            obj.props_('ohif_v3_beta') = value;
        end
        function result = get.ohifV3DefaultApp(obj)
            if ismethod(obj, 'get_ohifV3DefaultApp')
                result = obj.get_ohifV3DefaultApp();
            else
                if isKey(obj.props_, 'ohif_v3_default_app')
                    result = obj.props_('ohif_v3_default_app');
                else
                    result = [];
                end
            end
        end
        function obj = set.ohifV3DefaultApp(obj, value)
            obj.props_('ohif_v3_default_app') = value;
        end
        function result = get.ohifV3Readonly(obj)
            if ismethod(obj, 'get_ohifV3Readonly')
                result = obj.get_ohifV3Readonly();
            else
                if isKey(obj.props_, 'ohif_v3_readonly')
                    result = obj.props_('ohif_v3_readonly');
                else
                    result = [];
                end
            end
        end
        function obj = set.ohifV3Readonly(obj, value)
            obj.props_('ohif_v3_readonly') = value;
        end
        function result = get.projectExport(obj)
            if ismethod(obj, 'get_projectExport')
                result = obj.get_projectExport();
            else
                if isKey(obj.props_, 'project_export')
                    result = obj.props_('project_export');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectExport(obj, value)
            obj.props_('project_export') = value;
        end
        function result = get.projectImport(obj)
            if ismethod(obj, 'get_projectImport')
                result = obj.get_projectImport();
            else
                if isKey(obj.props_, 'project_import')
                    result = obj.props_('project_import');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectImport(obj, value)
            obj.props_('project_import') = value;
        end
        function result = get.projectListUsesStats(obj)
            if ismethod(obj, 'get_projectListUsesStats')
                result = obj.get_projectListUsesStats();
            else
                if isKey(obj.props_, 'project_list_uses_stats')
                    result = obj.props_('project_list_uses_stats');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectListUsesStats(obj, value)
            obj.props_('project_list_uses_stats') = value;
        end
        function result = get.projectLocking(obj)
            if ismethod(obj, 'get_projectLocking')
                result = obj.get_projectLocking();
            else
                if isKey(obj.props_, 'project_locking')
                    result = obj.props_('project_locking');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectLocking(obj, value)
            obj.props_('project_locking') = value;
        end
        function result = get.readerTasks(obj)
            if ismethod(obj, 'get_readerTasks')
                result = obj.get_readerTasks();
            else
                if isKey(obj.props_, 'reader_tasks')
                    result = obj.props_('reader_tasks');
                else
                    result = [];
                end
            end
        end
        function obj = set.readerTasks(obj, value)
            obj.props_('reader_tasks') = value;
        end
        function result = get.rtsSync(obj)
            if ismethod(obj, 'get_rtsSync')
                result = obj.get_rtsSync();
            else
                if isKey(obj.props_, 'rts_sync')
                    result = obj.props_('rts_sync');
                else
                    result = [];
                end
            end
        end
        function obj = set.rtsSync(obj, value)
            obj.props_('rts_sync') = value;
        end
        function result = get.sentryLogging(obj)
            if ismethod(obj, 'get_sentryLogging')
                result = obj.get_sentryLogging();
            else
                if isKey(obj.props_, 'sentry_logging')
                    result = obj.props_('sentry_logging');
                else
                    result = [];
                end
            end
        end
        function obj = set.sentryLogging(obj, value)
            obj.props_('sentry_logging') = value;
        end
        function result = get.sessionTemplatesNon21Cfr(obj)
            if ismethod(obj, 'get_sessionTemplatesNon21Cfr')
                result = obj.get_sessionTemplatesNon21Cfr();
            else
                if isKey(obj.props_, 'session_templates_non_21CFR')
                    result = obj.props_('session_templates_non_21CFR');
                else
                    result = [];
                end
            end
        end
        function obj = set.sessionTemplatesNon21Cfr(obj, value)
            obj.props_('session_templates_non_21CFR') = value;
        end
        function result = get.sharedProjects(obj)
            if ismethod(obj, 'get_sharedProjects')
                result = obj.get_sharedProjects();
            else
                if isKey(obj.props_, 'shared_projects')
                    result = obj.props_('shared_projects');
                else
                    result = [];
                end
            end
        end
        function obj = set.sharedProjects(obj, value)
            obj.props_('shared_projects') = value;
        end
        function result = get.signedUrl(obj)
            if ismethod(obj, 'get_signedUrl')
                result = obj.get_signedUrl();
            else
                if isKey(obj.props_, 'signed_url')
                    result = obj.props_('signed_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.signedUrl(obj, value)
            obj.props_('signed_url') = value;
        end
        function result = get.studyTaskStatus(obj)
            if ismethod(obj, 'get_studyTaskStatus')
                result = obj.get_studyTaskStatus();
            else
                if isKey(obj.props_, 'study_task_status')
                    result = obj.props_('study_task_status');
                else
                    result = [];
                end
            end
        end
        function obj = set.studyTaskStatus(obj, value)
            obj.props_('study_task_status') = value;
        end
        function result = get.tagging(obj)
            if ismethod(obj, 'get_tagging')
                result = obj.get_tagging();
            else
                if isKey(obj.props_, 'tagging')
                    result = obj.props_('tagging');
                else
                    result = [];
                end
            end
        end
        function obj = set.tagging(obj, value)
            obj.props_('tagging') = value;
        end
        function result = get.tagsInLists(obj)
            if ismethod(obj, 'get_tagsInLists')
                result = obj.get_tagsInLists();
            else
                if isKey(obj.props_, 'tags_in_lists')
                    result = obj.props_('tags_in_lists');
                else
                    result = [];
                end
            end
        end
        function obj = set.tagsInLists(obj, value)
            obj.props_('tags_in_lists') = value;
        end
        function result = get.taskManagerDataViews(obj)
            if ismethod(obj, 'get_taskManagerDataViews')
                result = obj.get_taskManagerDataViews();
            else
                if isKey(obj.props_, 'task_manager_data_views')
                    result = obj.props_('task_manager_data_views');
                else
                    result = [];
                end
            end
        end
        function obj = set.taskManagerDataViews(obj, value)
            obj.props_('task_manager_data_views') = value;
        end
        function result = get.transformSearchFields(obj)
            if ismethod(obj, 'get_transformSearchFields')
                result = obj.get_transformSearchFields();
            else
                if isKey(obj.props_, 'transform_search_fields')
                    result = obj.props_('transform_search_fields');
                else
                    result = [];
                end
            end
        end
        function obj = set.transformSearchFields(obj, value)
            obj.props_('transform_search_fields') = value;
        end
        function result = get.unsafeLogin(obj)
            if ismethod(obj, 'get_unsafeLogin')
                result = obj.get_unsafeLogin();
            else
                if isKey(obj.props_, 'unsafe_login')
                    result = obj.props_('unsafe_login');
                else
                    result = [];
                end
            end
        end
        function obj = set.unsafeLogin(obj, value)
            obj.props_('unsafe_login') = value;
        end
        function result = get.urlAccessApps(obj)
            if ismethod(obj, 'get_urlAccessApps')
                result = obj.get_urlAccessApps();
            else
                if isKey(obj.props_, 'url_access_apps')
                    result = obj.props_('url_access_apps');
                else
                    result = [];
                end
            end
        end
        function obj = set.urlAccessApps(obj, value)
            obj.props_('url_access_apps') = value;
        end
        function result = get.userpilot(obj)
            if ismethod(obj, 'get_userpilot')
                result = obj.get_userpilot();
            else
                if isKey(obj.props_, 'userpilot')
                    result = obj.props_('userpilot');
                else
                    result = [];
                end
            end
        end
        function obj = set.userpilot(obj, value)
            obj.props_('userpilot') = value;
        end
        function result = get.validateClassification(obj)
            if ismethod(obj, 'get_validateClassification')
                result = obj.get_validateClassification();
            else
                if isKey(obj.props_, 'validate_classification')
                    result = obj.props_('validate_classification');
                else
                    result = [];
                end
            end
        end
        function obj = set.validateClassification(obj, value)
            obj.props_('validate_classification') = value;
        end
        function result = get.virusScan(obj)
            if ismethod(obj, 'get_virusScan')
                result = obj.get_virusScan();
            else
                if isKey(obj.props_, 'virus_scan')
                    result = obj.props_('virus_scan');
                else
                    result = [];
                end
            end
        end
        function obj = set.virusScan(obj, value)
            obj.props_('virus_scan') = value;
        end
        function result = get.legacyDicomUploader(obj)
            if ismethod(obj, 'get_legacyDicomUploader')
                result = obj.get_legacyDicomUploader();
            else
                if isKey(obj.props_, 'legacy_dicom_uploader')
                    result = obj.props_('legacy_dicom_uploader');
                else
                    result = [];
                end
            end
        end
        function obj = set.legacyDicomUploader(obj, value)
            obj.props_('legacy_dicom_uploader') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'api_enabled_gear_rules')
                result('api_enabled_gear_rules') = flywheel.ModelBase.serializeValue(obj.props_('api_enabled_gear_rules'), 'logical');
            end
            if isKey(obj.props_, 'auth0')
                result('auth0') = flywheel.ModelBase.serializeValue(obj.props_('auth0'), 'logical');
            end
            if isKey(obj.props_, 'audit_trail')
                result('audit_trail') = flywheel.ModelBase.serializeValue(obj.props_('audit_trail'), 'logical');
            end
            if isKey(obj.props_, 'azureml_integration')
                result('azureml_integration') = flywheel.ModelBase.serializeValue(obj.props_('azureml_integration'), 'logical');
            end
            if isKey(obj.props_, 'cold_job_logs')
                result('cold_job_logs') = flywheel.ModelBase.serializeValue(obj.props_('cold_job_logs'), 'logical');
            end
            if isKey(obj.props_, 'collections')
                result('collections') = flywheel.ModelBase.serializeValue(obj.props_('collections'), 'logical');
            end
            if isKey(obj.props_, 'copy_by_reference')
                result('copy_by_reference') = flywheel.ModelBase.serializeValue(obj.props_('copy_by_reference'), 'logical');
            end
            if isKey(obj.props_, 'core_api')
                result('core_api') = flywheel.ModelBase.serializeValue(obj.props_('core_api'), 'logical');
            end
            if isKey(obj.props_, 'crawler')
                result('crawler') = flywheel.ModelBase.serializeValue(obj.props_('crawler'), 'logical');
            end
            if isKey(obj.props_, 'data_views_non_21CFR')
                result('data_views_non_21CFR') = flywheel.ModelBase.serializeValue(obj.props_('data_views_non_21CFR'), 'logical');
            end
            if isKey(obj.props_, 'default_viewer_apps')
                result('default_viewer_apps') = flywheel.ModelBase.serializeValue(obj.props_('default_viewer_apps'), 'logical');
            end
            if isKey(obj.props_, 'deid_log')
                result('deid_log') = flywheel.ModelBase.serializeValue(obj.props_('deid_log'), 'logical');
            end
            if isKey(obj.props_, 'deid_profile')
                result('deid_profile') = flywheel.ModelBase.serializeValue(obj.props_('deid_profile'), 'logical');
            end
            if isKey(obj.props_, 'dicom_web_uploader_non_21CFR')
                result('dicom_web_uploader_non_21CFR') = flywheel.ModelBase.serializeValue(obj.props_('dicom_web_uploader_non_21CFR'), 'logical');
            end
            if isKey(obj.props_, 'dimse')
                result('dimse') = flywheel.ModelBase.serializeValue(obj.props_('dimse'), 'logical');
            end
            if isKey(obj.props_, 'elastic_search_primary')
                result('elastic_search_primary') = flywheel.ModelBase.serializeValue(obj.props_('elastic_search_primary'), 'logical');
            end
            if isKey(obj.props_, 'exchange')
                result('exchange') = flywheel.ModelBase.serializeValue(obj.props_('exchange'), 'logical');
            end
            if isKey(obj.props_, 'exchange_admin')
                result('exchange_admin') = flywheel.ModelBase.serializeValue(obj.props_('exchange_admin'), 'logical');
            end
            if isKey(obj.props_, 'external_routing')
                result('external_routing') = flywheel.ModelBase.serializeValue(obj.props_('external_routing'), 'logical');
            end
            if isKey(obj.props_, 'gear_access')
                result('gear_access') = flywheel.ModelBase.serializeValue(obj.props_('gear_access'), 'logical');
            end
            if isKey(obj.props_, 'google_analytics')
                result('google_analytics') = flywheel.ModelBase.serializeValue(obj.props_('google_analytics'), 'logical');
            end
            if isKey(obj.props_, 'healthcare_api')
                result('healthcare_api') = flywheel.ModelBase.serializeValue(obj.props_('healthcare_api'), 'logical');
            end
            if isKey(obj.props_, 'job_ask')
                result('job_ask') = flywheel.ModelBase.serializeValue(obj.props_('job_ask'), 'logical');
            end
            if isKey(obj.props_, 'job_prioritization')
                result('job_prioritization') = flywheel.ModelBase.serializeValue(obj.props_('job_prioritization'), 'logical');
            end
            if isKey(obj.props_, 'job_tickets')
                result('job_tickets') = flywheel.ModelBase.serializeValue(obj.props_('job_tickets'), 'logical');
            end
            if isKey(obj.props_, 'jupyter_integration')
                result('jupyter_integration') = flywheel.ModelBase.serializeValue(obj.props_('jupyter_integration'), 'logical');
            end
            if isKey(obj.props_, 'jupyterhub_external_storage')
                result('jupyterhub_external_storage') = flywheel.ModelBase.serializeValue(obj.props_('jupyterhub_external_storage'), 'logical');
            end
            if isKey(obj.props_, 'ldap_sync')
                result('ldap_sync') = flywheel.ModelBase.serializeValue(obj.props_('ldap_sync'), 'logical');
            end
            if isKey(obj.props_, 'multifactor_auth')
                result('multifactor_auth') = flywheel.ModelBase.serializeValue(obj.props_('multifactor_auth'), 'logical');
            end
            if isKey(obj.props_, 'multipart_signed_url')
                result('multipart_signed_url') = flywheel.ModelBase.serializeValue(obj.props_('multipart_signed_url'), 'logical');
            end
            if isKey(obj.props_, 'multiproject')
                result('multiproject') = flywheel.ModelBase.serializeValue(obj.props_('multiproject'), 'logical');
            end
            if isKey(obj.props_, 'ohif_multi_subject_view')
                result('ohif_multi_subject_view') = flywheel.ModelBase.serializeValue(obj.props_('ohif_multi_subject_view'), 'logical');
            end
            if isKey(obj.props_, 'ohif_meteor')
                result('ohif_meteor') = flywheel.ModelBase.serializeValue(obj.props_('ohif_meteor'), 'logical');
            end
            if isKey(obj.props_, 'ohif_react')
                result('ohif_react') = flywheel.ModelBase.serializeValue(obj.props_('ohif_react'), 'logical');
            end
            if isKey(obj.props_, 'ohif_react_beta')
                result('ohif_react_beta') = flywheel.ModelBase.serializeValue(obj.props_('ohif_react_beta'), 'logical');
            end
            if isKey(obj.props_, 'ohif_slice_order')
                result('ohif_slice_order') = flywheel.ModelBase.serializeValue(obj.props_('ohif_slice_order'), 'char');
            end
            if isKey(obj.props_, 'ohif_v2_adhoc_indexing')
                result('ohif_v2_adhoc_indexing') = flywheel.ModelBase.serializeValue(obj.props_('ohif_v2_adhoc_indexing'), 'logical');
            end
            if isKey(obj.props_, 'ohif_v3')
                result('ohif_v3') = flywheel.ModelBase.serializeValue(obj.props_('ohif_v3'), 'logical');
            end
            if isKey(obj.props_, 'ohif_v3_beta')
                result('ohif_v3_beta') = flywheel.ModelBase.serializeValue(obj.props_('ohif_v3_beta'), 'logical');
            end
            if isKey(obj.props_, 'ohif_v3_default_app')
                result('ohif_v3_default_app') = flywheel.ModelBase.serializeValue(obj.props_('ohif_v3_default_app'), 'logical');
            end
            if isKey(obj.props_, 'ohif_v3_readonly')
                result('ohif_v3_readonly') = flywheel.ModelBase.serializeValue(obj.props_('ohif_v3_readonly'), 'logical');
            end
            if isKey(obj.props_, 'project_export')
                result('project_export') = flywheel.ModelBase.serializeValue(obj.props_('project_export'), 'logical');
            end
            if isKey(obj.props_, 'project_import')
                result('project_import') = flywheel.ModelBase.serializeValue(obj.props_('project_import'), 'logical');
            end
            if isKey(obj.props_, 'project_list_uses_stats')
                result('project_list_uses_stats') = flywheel.ModelBase.serializeValue(obj.props_('project_list_uses_stats'), 'logical');
            end
            if isKey(obj.props_, 'project_locking')
                result('project_locking') = flywheel.ModelBase.serializeValue(obj.props_('project_locking'), 'logical');
            end
            if isKey(obj.props_, 'reader_tasks')
                result('reader_tasks') = flywheel.ModelBase.serializeValue(obj.props_('reader_tasks'), 'logical');
            end
            if isKey(obj.props_, 'rts_sync')
                result('rts_sync') = flywheel.ModelBase.serializeValue(obj.props_('rts_sync'), 'logical');
            end
            if isKey(obj.props_, 'sentry_logging')
                result('sentry_logging') = flywheel.ModelBase.serializeValue(obj.props_('sentry_logging'), 'logical');
            end
            if isKey(obj.props_, 'session_templates_non_21CFR')
                result('session_templates_non_21CFR') = flywheel.ModelBase.serializeValue(obj.props_('session_templates_non_21CFR'), 'logical');
            end
            if isKey(obj.props_, 'shared_projects')
                result('shared_projects') = flywheel.ModelBase.serializeValue(obj.props_('shared_projects'), 'logical');
            end
            if isKey(obj.props_, 'signed_url')
                result('signed_url') = flywheel.ModelBase.serializeValue(obj.props_('signed_url'), 'logical');
            end
            if isKey(obj.props_, 'study_task_status')
                result('study_task_status') = flywheel.ModelBase.serializeValue(obj.props_('study_task_status'), 'logical');
            end
            if isKey(obj.props_, 'tagging')
                result('tagging') = flywheel.ModelBase.serializeValue(obj.props_('tagging'), 'logical');
            end
            if isKey(obj.props_, 'tags_in_lists')
                result('tags_in_lists') = flywheel.ModelBase.serializeValue(obj.props_('tags_in_lists'), 'logical');
            end
            if isKey(obj.props_, 'task_manager_data_views')
                result('task_manager_data_views') = flywheel.ModelBase.serializeValue(obj.props_('task_manager_data_views'), 'logical');
            end
            if isKey(obj.props_, 'transform_search_fields')
                result('transform_search_fields') = flywheel.ModelBase.serializeValue(obj.props_('transform_search_fields'), 'logical');
            end
            if isKey(obj.props_, 'unsafe_login')
                result('unsafe_login') = flywheel.ModelBase.serializeValue(obj.props_('unsafe_login'), 'logical');
            end
            if isKey(obj.props_, 'url_access_apps')
                result('url_access_apps') = flywheel.ModelBase.serializeValue(obj.props_('url_access_apps'), 'logical');
            end
            if isKey(obj.props_, 'userpilot')
                result('userpilot') = flywheel.ModelBase.serializeValue(obj.props_('userpilot'), 'logical');
            end
            if isKey(obj.props_, 'validate_classification')
                result('validate_classification') = flywheel.ModelBase.serializeValue(obj.props_('validate_classification'), 'logical');
            end
            if isKey(obj.props_, 'virus_scan')
                result('virus_scan') = flywheel.ModelBase.serializeValue(obj.props_('virus_scan'), 'logical');
            end
            if isKey(obj.props_, 'legacy_dicom_uploader')
                result('legacy_dicom_uploader') = flywheel.ModelBase.serializeValue(obj.props_('legacy_dicom_uploader'), 'logical');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'api_enabled_gear_rules')
                result.apiEnabledGearRules = obj.props_('api_enabled_gear_rules');
            else
                result.apiEnabledGearRules = [];
            end
            if isKey(obj.props_, 'auth0')
                result.auth0 = obj.props_('auth0');
            else
                result.auth0 = [];
            end
            if isKey(obj.props_, 'audit_trail')
                result.auditTrail = obj.props_('audit_trail');
            else
                result.auditTrail = [];
            end
            if isKey(obj.props_, 'azureml_integration')
                result.azuremlIntegration = obj.props_('azureml_integration');
            else
                result.azuremlIntegration = [];
            end
            if isKey(obj.props_, 'cold_job_logs')
                result.coldJobLogs = obj.props_('cold_job_logs');
            else
                result.coldJobLogs = [];
            end
            if isKey(obj.props_, 'collections')
                result.collections = obj.props_('collections');
            else
                result.collections = [];
            end
            if isKey(obj.props_, 'copy_by_reference')
                result.copyByReference = obj.props_('copy_by_reference');
            else
                result.copyByReference = [];
            end
            if isKey(obj.props_, 'core_api')
                result.coreApi = obj.props_('core_api');
            else
                result.coreApi = [];
            end
            if isKey(obj.props_, 'crawler')
                result.crawler = obj.props_('crawler');
            else
                result.crawler = [];
            end
            if isKey(obj.props_, 'data_views_non_21CFR')
                result.dataViewsNon21Cfr = obj.props_('data_views_non_21CFR');
            else
                result.dataViewsNon21Cfr = [];
            end
            if isKey(obj.props_, 'default_viewer_apps')
                result.defaultViewerApps = obj.props_('default_viewer_apps');
            else
                result.defaultViewerApps = [];
            end
            if isKey(obj.props_, 'deid_log')
                result.deidLog = obj.props_('deid_log');
            else
                result.deidLog = [];
            end
            if isKey(obj.props_, 'deid_profile')
                result.deidProfile = obj.props_('deid_profile');
            else
                result.deidProfile = [];
            end
            if isKey(obj.props_, 'dicom_web_uploader_non_21CFR')
                result.dicomWebUploaderNon21Cfr = obj.props_('dicom_web_uploader_non_21CFR');
            else
                result.dicomWebUploaderNon21Cfr = [];
            end
            if isKey(obj.props_, 'dimse')
                result.dimse = obj.props_('dimse');
            else
                result.dimse = [];
            end
            if isKey(obj.props_, 'elastic_search_primary')
                result.elasticSearchPrimary = obj.props_('elastic_search_primary');
            else
                result.elasticSearchPrimary = [];
            end
            if isKey(obj.props_, 'exchange')
                result.exchange = obj.props_('exchange');
            else
                result.exchange = [];
            end
            if isKey(obj.props_, 'exchange_admin')
                result.exchangeAdmin = obj.props_('exchange_admin');
            else
                result.exchangeAdmin = [];
            end
            if isKey(obj.props_, 'external_routing')
                result.externalRouting = obj.props_('external_routing');
            else
                result.externalRouting = [];
            end
            if isKey(obj.props_, 'gear_access')
                result.gearAccess = obj.props_('gear_access');
            else
                result.gearAccess = [];
            end
            if isKey(obj.props_, 'google_analytics')
                result.googleAnalytics = obj.props_('google_analytics');
            else
                result.googleAnalytics = [];
            end
            if isKey(obj.props_, 'healthcare_api')
                result.healthcareApi = obj.props_('healthcare_api');
            else
                result.healthcareApi = [];
            end
            if isKey(obj.props_, 'job_ask')
                result.jobAsk = obj.props_('job_ask');
            else
                result.jobAsk = [];
            end
            if isKey(obj.props_, 'job_prioritization')
                result.jobPrioritization = obj.props_('job_prioritization');
            else
                result.jobPrioritization = [];
            end
            if isKey(obj.props_, 'job_tickets')
                result.jobTickets = obj.props_('job_tickets');
            else
                result.jobTickets = [];
            end
            if isKey(obj.props_, 'jupyter_integration')
                result.jupyterIntegration = obj.props_('jupyter_integration');
            else
                result.jupyterIntegration = [];
            end
            if isKey(obj.props_, 'jupyterhub_external_storage')
                result.jupyterhubExternalStorage = obj.props_('jupyterhub_external_storage');
            else
                result.jupyterhubExternalStorage = [];
            end
            if isKey(obj.props_, 'ldap_sync')
                result.ldapSync = obj.props_('ldap_sync');
            else
                result.ldapSync = [];
            end
            if isKey(obj.props_, 'multifactor_auth')
                result.multifactorAuth = obj.props_('multifactor_auth');
            else
                result.multifactorAuth = [];
            end
            if isKey(obj.props_, 'multipart_signed_url')
                result.multipartSignedUrl = obj.props_('multipart_signed_url');
            else
                result.multipartSignedUrl = [];
            end
            if isKey(obj.props_, 'multiproject')
                result.multiproject = obj.props_('multiproject');
            else
                result.multiproject = [];
            end
            if isKey(obj.props_, 'ohif_multi_subject_view')
                result.ohifMultiSubjectView = obj.props_('ohif_multi_subject_view');
            else
                result.ohifMultiSubjectView = [];
            end
            if isKey(obj.props_, 'ohif_meteor')
                result.ohifMeteor = obj.props_('ohif_meteor');
            else
                result.ohifMeteor = [];
            end
            if isKey(obj.props_, 'ohif_react')
                result.ohifReact = obj.props_('ohif_react');
            else
                result.ohifReact = [];
            end
            if isKey(obj.props_, 'ohif_react_beta')
                result.ohifReactBeta = obj.props_('ohif_react_beta');
            else
                result.ohifReactBeta = [];
            end
            if isKey(obj.props_, 'ohif_slice_order')
                result.ohifSliceOrder = obj.props_('ohif_slice_order');
            else
                result.ohifSliceOrder = [];
            end
            if isKey(obj.props_, 'ohif_v2_adhoc_indexing')
                result.ohifV2AdhocIndexing = obj.props_('ohif_v2_adhoc_indexing');
            else
                result.ohifV2AdhocIndexing = [];
            end
            if isKey(obj.props_, 'ohif_v3')
                result.ohifV3 = obj.props_('ohif_v3');
            else
                result.ohifV3 = [];
            end
            if isKey(obj.props_, 'ohif_v3_beta')
                result.ohifV3Beta = obj.props_('ohif_v3_beta');
            else
                result.ohifV3Beta = [];
            end
            if isKey(obj.props_, 'ohif_v3_default_app')
                result.ohifV3DefaultApp = obj.props_('ohif_v3_default_app');
            else
                result.ohifV3DefaultApp = [];
            end
            if isKey(obj.props_, 'ohif_v3_readonly')
                result.ohifV3Readonly = obj.props_('ohif_v3_readonly');
            else
                result.ohifV3Readonly = [];
            end
            if isKey(obj.props_, 'project_export')
                result.projectExport = obj.props_('project_export');
            else
                result.projectExport = [];
            end
            if isKey(obj.props_, 'project_import')
                result.projectImport = obj.props_('project_import');
            else
                result.projectImport = [];
            end
            if isKey(obj.props_, 'project_list_uses_stats')
                result.projectListUsesStats = obj.props_('project_list_uses_stats');
            else
                result.projectListUsesStats = [];
            end
            if isKey(obj.props_, 'project_locking')
                result.projectLocking = obj.props_('project_locking');
            else
                result.projectLocking = [];
            end
            if isKey(obj.props_, 'reader_tasks')
                result.readerTasks = obj.props_('reader_tasks');
            else
                result.readerTasks = [];
            end
            if isKey(obj.props_, 'rts_sync')
                result.rtsSync = obj.props_('rts_sync');
            else
                result.rtsSync = [];
            end
            if isKey(obj.props_, 'sentry_logging')
                result.sentryLogging = obj.props_('sentry_logging');
            else
                result.sentryLogging = [];
            end
            if isKey(obj.props_, 'session_templates_non_21CFR')
                result.sessionTemplatesNon21Cfr = obj.props_('session_templates_non_21CFR');
            else
                result.sessionTemplatesNon21Cfr = [];
            end
            if isKey(obj.props_, 'shared_projects')
                result.sharedProjects = obj.props_('shared_projects');
            else
                result.sharedProjects = [];
            end
            if isKey(obj.props_, 'signed_url')
                result.signedUrl = obj.props_('signed_url');
            else
                result.signedUrl = [];
            end
            if isKey(obj.props_, 'study_task_status')
                result.studyTaskStatus = obj.props_('study_task_status');
            else
                result.studyTaskStatus = [];
            end
            if isKey(obj.props_, 'tagging')
                result.tagging = obj.props_('tagging');
            else
                result.tagging = [];
            end
            if isKey(obj.props_, 'tags_in_lists')
                result.tagsInLists = obj.props_('tags_in_lists');
            else
                result.tagsInLists = [];
            end
            if isKey(obj.props_, 'task_manager_data_views')
                result.taskManagerDataViews = obj.props_('task_manager_data_views');
            else
                result.taskManagerDataViews = [];
            end
            if isKey(obj.props_, 'transform_search_fields')
                result.transformSearchFields = obj.props_('transform_search_fields');
            else
                result.transformSearchFields = [];
            end
            if isKey(obj.props_, 'unsafe_login')
                result.unsafeLogin = obj.props_('unsafe_login');
            else
                result.unsafeLogin = [];
            end
            if isKey(obj.props_, 'url_access_apps')
                result.urlAccessApps = obj.props_('url_access_apps');
            else
                result.urlAccessApps = [];
            end
            if isKey(obj.props_, 'userpilot')
                result.userpilot = obj.props_('userpilot');
            else
                result.userpilot = [];
            end
            if isKey(obj.props_, 'validate_classification')
                result.validateClassification = obj.props_('validate_classification');
            else
                result.validateClassification = [];
            end
            if isKey(obj.props_, 'virus_scan')
                result.virusScan = obj.props_('virus_scan');
            else
                result.virusScan = [];
            end
            if isKey(obj.props_, 'legacy_dicom_uploader')
                result.legacyDicomUploader = obj.props_('legacy_dicom_uploader');
            else
                result.legacyDicomUploader = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'api_enabled_gear_rules')
                    propList.apiEnabledGearRules = obj.props_('api_enabled_gear_rules');
                else
                    propList.apiEnabledGearRules = [];
                end
                if isKey(obj.props_, 'auth0')
                    propList.auth0 = obj.props_('auth0');
                else
                    propList.auth0 = [];
                end
                if isKey(obj.props_, 'audit_trail')
                    propList.auditTrail = obj.props_('audit_trail');
                else
                    propList.auditTrail = [];
                end
                if isKey(obj.props_, 'azureml_integration')
                    propList.azuremlIntegration = obj.props_('azureml_integration');
                else
                    propList.azuremlIntegration = [];
                end
                if isKey(obj.props_, 'cold_job_logs')
                    propList.coldJobLogs = obj.props_('cold_job_logs');
                else
                    propList.coldJobLogs = [];
                end
                if isKey(obj.props_, 'collections')
                    propList.collections = obj.props_('collections');
                else
                    propList.collections = [];
                end
                if isKey(obj.props_, 'copy_by_reference')
                    propList.copyByReference = obj.props_('copy_by_reference');
                else
                    propList.copyByReference = [];
                end
                if isKey(obj.props_, 'core_api')
                    propList.coreApi = obj.props_('core_api');
                else
                    propList.coreApi = [];
                end
                if isKey(obj.props_, 'crawler')
                    propList.crawler = obj.props_('crawler');
                else
                    propList.crawler = [];
                end
                if isKey(obj.props_, 'data_views_non_21CFR')
                    propList.dataViewsNon21Cfr = obj.props_('data_views_non_21CFR');
                else
                    propList.dataViewsNon21Cfr = [];
                end
                if isKey(obj.props_, 'default_viewer_apps')
                    propList.defaultViewerApps = obj.props_('default_viewer_apps');
                else
                    propList.defaultViewerApps = [];
                end
                if isKey(obj.props_, 'deid_log')
                    propList.deidLog = obj.props_('deid_log');
                else
                    propList.deidLog = [];
                end
                if isKey(obj.props_, 'deid_profile')
                    propList.deidProfile = obj.props_('deid_profile');
                else
                    propList.deidProfile = [];
                end
                if isKey(obj.props_, 'dicom_web_uploader_non_21CFR')
                    propList.dicomWebUploaderNon21Cfr = obj.props_('dicom_web_uploader_non_21CFR');
                else
                    propList.dicomWebUploaderNon21Cfr = [];
                end
                if isKey(obj.props_, 'dimse')
                    propList.dimse = obj.props_('dimse');
                else
                    propList.dimse = [];
                end
                if isKey(obj.props_, 'elastic_search_primary')
                    propList.elasticSearchPrimary = obj.props_('elastic_search_primary');
                else
                    propList.elasticSearchPrimary = [];
                end
                if isKey(obj.props_, 'exchange')
                    propList.exchange = obj.props_('exchange');
                else
                    propList.exchange = [];
                end
                if isKey(obj.props_, 'exchange_admin')
                    propList.exchangeAdmin = obj.props_('exchange_admin');
                else
                    propList.exchangeAdmin = [];
                end
                if isKey(obj.props_, 'external_routing')
                    propList.externalRouting = obj.props_('external_routing');
                else
                    propList.externalRouting = [];
                end
                if isKey(obj.props_, 'gear_access')
                    propList.gearAccess = obj.props_('gear_access');
                else
                    propList.gearAccess = [];
                end
                if isKey(obj.props_, 'google_analytics')
                    propList.googleAnalytics = obj.props_('google_analytics');
                else
                    propList.googleAnalytics = [];
                end
                if isKey(obj.props_, 'healthcare_api')
                    propList.healthcareApi = obj.props_('healthcare_api');
                else
                    propList.healthcareApi = [];
                end
                if isKey(obj.props_, 'job_ask')
                    propList.jobAsk = obj.props_('job_ask');
                else
                    propList.jobAsk = [];
                end
                if isKey(obj.props_, 'job_prioritization')
                    propList.jobPrioritization = obj.props_('job_prioritization');
                else
                    propList.jobPrioritization = [];
                end
                if isKey(obj.props_, 'job_tickets')
                    propList.jobTickets = obj.props_('job_tickets');
                else
                    propList.jobTickets = [];
                end
                if isKey(obj.props_, 'jupyter_integration')
                    propList.jupyterIntegration = obj.props_('jupyter_integration');
                else
                    propList.jupyterIntegration = [];
                end
                if isKey(obj.props_, 'jupyterhub_external_storage')
                    propList.jupyterhubExternalStorage = obj.props_('jupyterhub_external_storage');
                else
                    propList.jupyterhubExternalStorage = [];
                end
                if isKey(obj.props_, 'ldap_sync')
                    propList.ldapSync = obj.props_('ldap_sync');
                else
                    propList.ldapSync = [];
                end
                if isKey(obj.props_, 'multifactor_auth')
                    propList.multifactorAuth = obj.props_('multifactor_auth');
                else
                    propList.multifactorAuth = [];
                end
                if isKey(obj.props_, 'multipart_signed_url')
                    propList.multipartSignedUrl = obj.props_('multipart_signed_url');
                else
                    propList.multipartSignedUrl = [];
                end
                if isKey(obj.props_, 'multiproject')
                    propList.multiproject = obj.props_('multiproject');
                else
                    propList.multiproject = [];
                end
                if isKey(obj.props_, 'ohif_multi_subject_view')
                    propList.ohifMultiSubjectView = obj.props_('ohif_multi_subject_view');
                else
                    propList.ohifMultiSubjectView = [];
                end
                if isKey(obj.props_, 'ohif_meteor')
                    propList.ohifMeteor = obj.props_('ohif_meteor');
                else
                    propList.ohifMeteor = [];
                end
                if isKey(obj.props_, 'ohif_react')
                    propList.ohifReact = obj.props_('ohif_react');
                else
                    propList.ohifReact = [];
                end
                if isKey(obj.props_, 'ohif_react_beta')
                    propList.ohifReactBeta = obj.props_('ohif_react_beta');
                else
                    propList.ohifReactBeta = [];
                end
                if isKey(obj.props_, 'ohif_slice_order')
                    propList.ohifSliceOrder = obj.props_('ohif_slice_order');
                else
                    propList.ohifSliceOrder = [];
                end
                if isKey(obj.props_, 'ohif_v2_adhoc_indexing')
                    propList.ohifV2AdhocIndexing = obj.props_('ohif_v2_adhoc_indexing');
                else
                    propList.ohifV2AdhocIndexing = [];
                end
                if isKey(obj.props_, 'ohif_v3')
                    propList.ohifV3 = obj.props_('ohif_v3');
                else
                    propList.ohifV3 = [];
                end
                if isKey(obj.props_, 'ohif_v3_beta')
                    propList.ohifV3Beta = obj.props_('ohif_v3_beta');
                else
                    propList.ohifV3Beta = [];
                end
                if isKey(obj.props_, 'ohif_v3_default_app')
                    propList.ohifV3DefaultApp = obj.props_('ohif_v3_default_app');
                else
                    propList.ohifV3DefaultApp = [];
                end
                if isKey(obj.props_, 'ohif_v3_readonly')
                    propList.ohifV3Readonly = obj.props_('ohif_v3_readonly');
                else
                    propList.ohifV3Readonly = [];
                end
                if isKey(obj.props_, 'project_export')
                    propList.projectExport = obj.props_('project_export');
                else
                    propList.projectExport = [];
                end
                if isKey(obj.props_, 'project_import')
                    propList.projectImport = obj.props_('project_import');
                else
                    propList.projectImport = [];
                end
                if isKey(obj.props_, 'project_list_uses_stats')
                    propList.projectListUsesStats = obj.props_('project_list_uses_stats');
                else
                    propList.projectListUsesStats = [];
                end
                if isKey(obj.props_, 'project_locking')
                    propList.projectLocking = obj.props_('project_locking');
                else
                    propList.projectLocking = [];
                end
                if isKey(obj.props_, 'reader_tasks')
                    propList.readerTasks = obj.props_('reader_tasks');
                else
                    propList.readerTasks = [];
                end
                if isKey(obj.props_, 'rts_sync')
                    propList.rtsSync = obj.props_('rts_sync');
                else
                    propList.rtsSync = [];
                end
                if isKey(obj.props_, 'sentry_logging')
                    propList.sentryLogging = obj.props_('sentry_logging');
                else
                    propList.sentryLogging = [];
                end
                if isKey(obj.props_, 'session_templates_non_21CFR')
                    propList.sessionTemplatesNon21Cfr = obj.props_('session_templates_non_21CFR');
                else
                    propList.sessionTemplatesNon21Cfr = [];
                end
                if isKey(obj.props_, 'shared_projects')
                    propList.sharedProjects = obj.props_('shared_projects');
                else
                    propList.sharedProjects = [];
                end
                if isKey(obj.props_, 'signed_url')
                    propList.signedUrl = obj.props_('signed_url');
                else
                    propList.signedUrl = [];
                end
                if isKey(obj.props_, 'study_task_status')
                    propList.studyTaskStatus = obj.props_('study_task_status');
                else
                    propList.studyTaskStatus = [];
                end
                if isKey(obj.props_, 'tagging')
                    propList.tagging = obj.props_('tagging');
                else
                    propList.tagging = [];
                end
                if isKey(obj.props_, 'tags_in_lists')
                    propList.tagsInLists = obj.props_('tags_in_lists');
                else
                    propList.tagsInLists = [];
                end
                if isKey(obj.props_, 'task_manager_data_views')
                    propList.taskManagerDataViews = obj.props_('task_manager_data_views');
                else
                    propList.taskManagerDataViews = [];
                end
                if isKey(obj.props_, 'transform_search_fields')
                    propList.transformSearchFields = obj.props_('transform_search_fields');
                else
                    propList.transformSearchFields = [];
                end
                if isKey(obj.props_, 'unsafe_login')
                    propList.unsafeLogin = obj.props_('unsafe_login');
                else
                    propList.unsafeLogin = [];
                end
                if isKey(obj.props_, 'url_access_apps')
                    propList.urlAccessApps = obj.props_('url_access_apps');
                else
                    propList.urlAccessApps = [];
                end
                if isKey(obj.props_, 'userpilot')
                    propList.userpilot = obj.props_('userpilot');
                else
                    propList.userpilot = [];
                end
                if isKey(obj.props_, 'validate_classification')
                    propList.validateClassification = obj.props_('validate_classification');
                else
                    propList.validateClassification = [];
                end
                if isKey(obj.props_, 'virus_scan')
                    propList.virusScan = obj.props_('virus_scan');
                else
                    propList.virusScan = [];
                end
                if isKey(obj.props_, 'legacy_dicom_uploader')
                    propList.legacyDicomUploader = obj.props_('legacy_dicom_uploader');
                else
                    propList.legacyDicomUploader = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Features;
            if isfield(json, 'api_enabled_gear_rules')
                obj.props_('api_enabled_gear_rules') = flywheel.ModelBase.deserializeValue(json.api_enabled_gear_rules, 'logical');
            end
            if isfield(json, 'auth0')
                obj.props_('auth0') = flywheel.ModelBase.deserializeValue(json.auth0, 'logical');
            end
            if isfield(json, 'audit_trail')
                obj.props_('audit_trail') = flywheel.ModelBase.deserializeValue(json.audit_trail, 'logical');
            end
            if isfield(json, 'azureml_integration')
                obj.props_('azureml_integration') = flywheel.ModelBase.deserializeValue(json.azureml_integration, 'logical');
            end
            if isfield(json, 'cold_job_logs')
                obj.props_('cold_job_logs') = flywheel.ModelBase.deserializeValue(json.cold_job_logs, 'logical');
            end
            if isfield(json, 'collections')
                obj.props_('collections') = flywheel.ModelBase.deserializeValue(json.collections, 'logical');
            end
            if isfield(json, 'copy_by_reference')
                obj.props_('copy_by_reference') = flywheel.ModelBase.deserializeValue(json.copy_by_reference, 'logical');
            end
            if isfield(json, 'core_api')
                obj.props_('core_api') = flywheel.ModelBase.deserializeValue(json.core_api, 'logical');
            end
            if isfield(json, 'crawler')
                obj.props_('crawler') = flywheel.ModelBase.deserializeValue(json.crawler, 'logical');
            end
            if isfield(json, 'data_views_non_21CFR')
                obj.props_('data_views_non_21CFR') = flywheel.ModelBase.deserializeValue(json.data_views_non_21CFR, 'logical');
            end
            if isfield(json, 'default_viewer_apps')
                obj.props_('default_viewer_apps') = flywheel.ModelBase.deserializeValue(json.default_viewer_apps, 'logical');
            end
            if isfield(json, 'deid_log')
                obj.props_('deid_log') = flywheel.ModelBase.deserializeValue(json.deid_log, 'logical');
            end
            if isfield(json, 'deid_profile')
                obj.props_('deid_profile') = flywheel.ModelBase.deserializeValue(json.deid_profile, 'logical');
            end
            if isfield(json, 'dicom_web_uploader_non_21CFR')
                obj.props_('dicom_web_uploader_non_21CFR') = flywheel.ModelBase.deserializeValue(json.dicom_web_uploader_non_21CFR, 'logical');
            end
            if isfield(json, 'dimse')
                obj.props_('dimse') = flywheel.ModelBase.deserializeValue(json.dimse, 'logical');
            end
            if isfield(json, 'elastic_search_primary')
                obj.props_('elastic_search_primary') = flywheel.ModelBase.deserializeValue(json.elastic_search_primary, 'logical');
            end
            if isfield(json, 'exchange')
                obj.props_('exchange') = flywheel.ModelBase.deserializeValue(json.exchange, 'logical');
            end
            if isfield(json, 'exchange_admin')
                obj.props_('exchange_admin') = flywheel.ModelBase.deserializeValue(json.exchange_admin, 'logical');
            end
            if isfield(json, 'external_routing')
                obj.props_('external_routing') = flywheel.ModelBase.deserializeValue(json.external_routing, 'logical');
            end
            if isfield(json, 'gear_access')
                obj.props_('gear_access') = flywheel.ModelBase.deserializeValue(json.gear_access, 'logical');
            end
            if isfield(json, 'google_analytics')
                obj.props_('google_analytics') = flywheel.ModelBase.deserializeValue(json.google_analytics, 'logical');
            end
            if isfield(json, 'healthcare_api')
                obj.props_('healthcare_api') = flywheel.ModelBase.deserializeValue(json.healthcare_api, 'logical');
            end
            if isfield(json, 'job_ask')
                obj.props_('job_ask') = flywheel.ModelBase.deserializeValue(json.job_ask, 'logical');
            end
            if isfield(json, 'job_prioritization')
                obj.props_('job_prioritization') = flywheel.ModelBase.deserializeValue(json.job_prioritization, 'logical');
            end
            if isfield(json, 'job_tickets')
                obj.props_('job_tickets') = flywheel.ModelBase.deserializeValue(json.job_tickets, 'logical');
            end
            if isfield(json, 'jupyter_integration')
                obj.props_('jupyter_integration') = flywheel.ModelBase.deserializeValue(json.jupyter_integration, 'logical');
            end
            if isfield(json, 'jupyterhub_external_storage')
                obj.props_('jupyterhub_external_storage') = flywheel.ModelBase.deserializeValue(json.jupyterhub_external_storage, 'logical');
            end
            if isfield(json, 'ldap_sync')
                obj.props_('ldap_sync') = flywheel.ModelBase.deserializeValue(json.ldap_sync, 'logical');
            end
            if isfield(json, 'multifactor_auth')
                obj.props_('multifactor_auth') = flywheel.ModelBase.deserializeValue(json.multifactor_auth, 'logical');
            end
            if isfield(json, 'multipart_signed_url')
                obj.props_('multipart_signed_url') = flywheel.ModelBase.deserializeValue(json.multipart_signed_url, 'logical');
            end
            if isfield(json, 'multiproject')
                obj.props_('multiproject') = flywheel.ModelBase.deserializeValue(json.multiproject, 'logical');
            end
            if isfield(json, 'ohif_multi_subject_view')
                obj.props_('ohif_multi_subject_view') = flywheel.ModelBase.deserializeValue(json.ohif_multi_subject_view, 'logical');
            end
            if isfield(json, 'ohif_meteor')
                obj.props_('ohif_meteor') = flywheel.ModelBase.deserializeValue(json.ohif_meteor, 'logical');
            end
            if isfield(json, 'ohif_react')
                obj.props_('ohif_react') = flywheel.ModelBase.deserializeValue(json.ohif_react, 'logical');
            end
            if isfield(json, 'ohif_react_beta')
                obj.props_('ohif_react_beta') = flywheel.ModelBase.deserializeValue(json.ohif_react_beta, 'logical');
            end
            if isfield(json, 'ohif_slice_order')
                obj.props_('ohif_slice_order') = flywheel.ModelBase.deserializeValue(json.ohif_slice_order, 'char');
            end
            if isfield(json, 'ohif_v2_adhoc_indexing')
                obj.props_('ohif_v2_adhoc_indexing') = flywheel.ModelBase.deserializeValue(json.ohif_v2_adhoc_indexing, 'logical');
            end
            if isfield(json, 'ohif_v3')
                obj.props_('ohif_v3') = flywheel.ModelBase.deserializeValue(json.ohif_v3, 'logical');
            end
            if isfield(json, 'ohif_v3_beta')
                obj.props_('ohif_v3_beta') = flywheel.ModelBase.deserializeValue(json.ohif_v3_beta, 'logical');
            end
            if isfield(json, 'ohif_v3_default_app')
                obj.props_('ohif_v3_default_app') = flywheel.ModelBase.deserializeValue(json.ohif_v3_default_app, 'logical');
            end
            if isfield(json, 'ohif_v3_readonly')
                obj.props_('ohif_v3_readonly') = flywheel.ModelBase.deserializeValue(json.ohif_v3_readonly, 'logical');
            end
            if isfield(json, 'project_export')
                obj.props_('project_export') = flywheel.ModelBase.deserializeValue(json.project_export, 'logical');
            end
            if isfield(json, 'project_import')
                obj.props_('project_import') = flywheel.ModelBase.deserializeValue(json.project_import, 'logical');
            end
            if isfield(json, 'project_list_uses_stats')
                obj.props_('project_list_uses_stats') = flywheel.ModelBase.deserializeValue(json.project_list_uses_stats, 'logical');
            end
            if isfield(json, 'project_locking')
                obj.props_('project_locking') = flywheel.ModelBase.deserializeValue(json.project_locking, 'logical');
            end
            if isfield(json, 'reader_tasks')
                obj.props_('reader_tasks') = flywheel.ModelBase.deserializeValue(json.reader_tasks, 'logical');
            end
            if isfield(json, 'rts_sync')
                obj.props_('rts_sync') = flywheel.ModelBase.deserializeValue(json.rts_sync, 'logical');
            end
            if isfield(json, 'sentry_logging')
                obj.props_('sentry_logging') = flywheel.ModelBase.deserializeValue(json.sentry_logging, 'logical');
            end
            if isfield(json, 'session_templates_non_21CFR')
                obj.props_('session_templates_non_21CFR') = flywheel.ModelBase.deserializeValue(json.session_templates_non_21CFR, 'logical');
            end
            if isfield(json, 'shared_projects')
                obj.props_('shared_projects') = flywheel.ModelBase.deserializeValue(json.shared_projects, 'logical');
            end
            if isfield(json, 'signed_url')
                obj.props_('signed_url') = flywheel.ModelBase.deserializeValue(json.signed_url, 'logical');
            end
            if isfield(json, 'study_task_status')
                obj.props_('study_task_status') = flywheel.ModelBase.deserializeValue(json.study_task_status, 'logical');
            end
            if isfield(json, 'tagging')
                obj.props_('tagging') = flywheel.ModelBase.deserializeValue(json.tagging, 'logical');
            end
            if isfield(json, 'tags_in_lists')
                obj.props_('tags_in_lists') = flywheel.ModelBase.deserializeValue(json.tags_in_lists, 'logical');
            end
            if isfield(json, 'task_manager_data_views')
                obj.props_('task_manager_data_views') = flywheel.ModelBase.deserializeValue(json.task_manager_data_views, 'logical');
            end
            if isfield(json, 'transform_search_fields')
                obj.props_('transform_search_fields') = flywheel.ModelBase.deserializeValue(json.transform_search_fields, 'logical');
            end
            if isfield(json, 'unsafe_login')
                obj.props_('unsafe_login') = flywheel.ModelBase.deserializeValue(json.unsafe_login, 'logical');
            end
            if isfield(json, 'url_access_apps')
                obj.props_('url_access_apps') = flywheel.ModelBase.deserializeValue(json.url_access_apps, 'logical');
            end
            if isfield(json, 'userpilot')
                obj.props_('userpilot') = flywheel.ModelBase.deserializeValue(json.userpilot, 'logical');
            end
            if isfield(json, 'validate_classification')
                obj.props_('validate_classification') = flywheel.ModelBase.deserializeValue(json.validate_classification, 'logical');
            end
            if isfield(json, 'virus_scan')
                obj.props_('virus_scan') = flywheel.ModelBase.deserializeValue(json.virus_scan, 'logical');
            end
            if isfield(json, 'legacy_dicom_uploader')
                obj.props_('legacy_dicom_uploader') = flywheel.ModelBase.deserializeValue(json.legacy_dicom_uploader, 'logical');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Features')
                    obj = flywheel.model.Features(obj);
                end
                if isKey(obj.props_, 'api_enabled_gear_rules')
                end
                if isKey(obj.props_, 'auth0')
                end
                if isKey(obj.props_, 'audit_trail')
                end
                if isKey(obj.props_, 'azureml_integration')
                end
                if isKey(obj.props_, 'cold_job_logs')
                end
                if isKey(obj.props_, 'collections')
                end
                if isKey(obj.props_, 'copy_by_reference')
                end
                if isKey(obj.props_, 'core_api')
                end
                if isKey(obj.props_, 'crawler')
                end
                if isKey(obj.props_, 'data_views_non_21CFR')
                end
                if isKey(obj.props_, 'default_viewer_apps')
                end
                if isKey(obj.props_, 'deid_log')
                end
                if isKey(obj.props_, 'deid_profile')
                end
                if isKey(obj.props_, 'dicom_web_uploader_non_21CFR')
                end
                if isKey(obj.props_, 'dimse')
                end
                if isKey(obj.props_, 'elastic_search_primary')
                end
                if isKey(obj.props_, 'exchange')
                end
                if isKey(obj.props_, 'exchange_admin')
                end
                if isKey(obj.props_, 'external_routing')
                end
                if isKey(obj.props_, 'gear_access')
                end
                if isKey(obj.props_, 'google_analytics')
                end
                if isKey(obj.props_, 'healthcare_api')
                end
                if isKey(obj.props_, 'job_ask')
                end
                if isKey(obj.props_, 'job_prioritization')
                end
                if isKey(obj.props_, 'job_tickets')
                end
                if isKey(obj.props_, 'jupyter_integration')
                end
                if isKey(obj.props_, 'jupyterhub_external_storage')
                end
                if isKey(obj.props_, 'ldap_sync')
                end
                if isKey(obj.props_, 'multifactor_auth')
                end
                if isKey(obj.props_, 'multipart_signed_url')
                end
                if isKey(obj.props_, 'multiproject')
                end
                if isKey(obj.props_, 'ohif_multi_subject_view')
                end
                if isKey(obj.props_, 'ohif_meteor')
                end
                if isKey(obj.props_, 'ohif_react')
                end
                if isKey(obj.props_, 'ohif_react_beta')
                end
                if isKey(obj.props_, 'ohif_slice_order')
                end
                if isKey(obj.props_, 'ohif_v2_adhoc_indexing')
                end
                if isKey(obj.props_, 'ohif_v3')
                end
                if isKey(obj.props_, 'ohif_v3_beta')
                end
                if isKey(obj.props_, 'ohif_v3_default_app')
                end
                if isKey(obj.props_, 'ohif_v3_readonly')
                end
                if isKey(obj.props_, 'project_export')
                end
                if isKey(obj.props_, 'project_import')
                end
                if isKey(obj.props_, 'project_list_uses_stats')
                end
                if isKey(obj.props_, 'project_locking')
                end
                if isKey(obj.props_, 'reader_tasks')
                end
                if isKey(obj.props_, 'rts_sync')
                end
                if isKey(obj.props_, 'sentry_logging')
                end
                if isKey(obj.props_, 'session_templates_non_21CFR')
                end
                if isKey(obj.props_, 'shared_projects')
                end
                if isKey(obj.props_, 'signed_url')
                end
                if isKey(obj.props_, 'study_task_status')
                end
                if isKey(obj.props_, 'tagging')
                end
                if isKey(obj.props_, 'tags_in_lists')
                end
                if isKey(obj.props_, 'task_manager_data_views')
                end
                if isKey(obj.props_, 'transform_search_fields')
                end
                if isKey(obj.props_, 'unsafe_login')
                end
                if isKey(obj.props_, 'url_access_apps')
                end
                if isKey(obj.props_, 'userpilot')
                end
                if isKey(obj.props_, 'validate_classification')
                end
                if isKey(obj.props_, 'virus_scan')
                end
                if isKey(obj.props_, 'legacy_dicom_uploader')
                end
            end
        end
    end
end
