% FieldChange
%
% FieldChange Properties:
%    method   
%    value    
%    created  
%    revision 
%    origin   
%
% FieldChange Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FieldChange < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'method', 'value', 'created', 'revision', 'origin' }, ...
            { 'method', 'value', 'created', 'revision', 'origin' });
    end
    properties(Dependent)
        method
        value
        created
        revision
        origin
    end
    methods
        function obj = FieldChange(varargin)
            obj@flywheel.ModelBase(flywheel.model.FieldChange.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'method', []);
                addParameter(p, 'value', []);
                addParameter(p, 'created', []);
                addParameter(p, 'revision', []);
                addParameter(p, 'origin', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.method)
                    obj.props_('method') = p.Results.method;
                end
                if ~isempty(p.Results.value)
                    obj.props_('value') = p.Results.value;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.revision)
                    obj.props_('revision') = p.Results.revision;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
            end
        end
        function result = get.method(obj)
            if ismethod(obj, 'get_method')
                result = obj.get_method();
            else
                if isKey(obj.props_, 'method')
                    result = obj.props_('method');
                else
                    result = [];
                end
            end
        end
        function obj = set.method(obj, value)
            obj.props_('method') = value;
        end
        function result = get.value(obj)
            if ismethod(obj, 'get_value')
                result = obj.get_value();
            else
                if isKey(obj.props_, 'value')
                    result = obj.props_('value');
                else
                    result = [];
                end
            end
        end
        function obj = set.value(obj, value)
            obj.props_('value') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.revision(obj)
            if ismethod(obj, 'get_revision')
                result = obj.get_revision();
            else
                if isKey(obj.props_, 'revision')
                    result = obj.props_('revision');
                else
                    result = [];
                end
            end
        end
        function obj = set.revision(obj, value)
            obj.props_('revision') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'method')
                result('method') = obj.props_('method').toJson();
            end
            if isKey(obj.props_, 'value')
                result('value') = flywheel.ModelBase.serializeValue(obj.props_('value'), 'containers.Map');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'revision')
                result('revision') = flywheel.ModelBase.serializeValue(obj.props_('revision'), 'integer');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'method')
                result.method = struct(obj.props_('method'));
            else
                result.method = [];
            end
            if isKey(obj.props_, 'value')
                result.value = obj.props_('value');
            else
                result.value = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'revision')
                result.revision = obj.props_('revision');
            else
                result.revision = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'method')
                    propList.method = obj.props_('method');
                else
                    propList.method = [];
                end
                if isKey(obj.props_, 'value')
                    propList.value = obj.props_('value');
                else
                    propList.value = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'revision')
                    propList.revision = obj.props_('revision');
                else
                    propList.revision = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FieldChange;
            if isfield(json, 'method')
                obj.props_('method') = flywheel.model.ChangeMethod.fromJson(json.method, context);
            end
            if isfield(json, 'value')
                obj.props_('value') = flywheel.ModelBase.deserializeValue(json.value, 'containers.Map');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'revision')
                obj.props_('revision') = flywheel.ModelBase.deserializeValue(json.revision, 'integer');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FieldChange')
                    obj = flywheel.model.FieldChange(obj);
                end
                if isKey(obj.props_, 'method')
                    obj.props_('method') =  flywheel.model.ChangeMethod.ensureIsInstance(obj.props_('method'));
                end
                if isKey(obj.props_, 'value')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'revision')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
            end
        end
    end
end
