% FieldChangeLogDocument
%
% FieldChangeLogDocument Properties:
%    containerType 
%    containerId   
%    fileVersion   
%    changes       
%
% FieldChangeLogDocument Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FieldChangeLogDocument < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'containerType', 'containerId', 'fileVersion', 'changes' }, ...
            { 'container_type', 'container_id', 'file_version', 'changes' });
    end
    properties(Dependent)
        containerType
        containerId
        fileVersion
        changes
    end
    methods
        function obj = FieldChangeLogDocument(varargin)
            obj@flywheel.ModelBase(flywheel.model.FieldChangeLogDocument.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'containerType', []);
                addParameter(p, 'containerId', []);
                addParameter(p, 'fileVersion', []);
                addParameter(p, 'changes', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.containerType)
                    obj.props_('container_type') = p.Results.containerType;
                end
                if ~isempty(p.Results.containerId)
                    obj.props_('container_id') = p.Results.containerId;
                end
                if ~isempty(p.Results.fileVersion)
                    obj.props_('file_version') = p.Results.fileVersion;
                end
                if ~isempty(p.Results.changes)
                    obj.props_('changes') = p.Results.changes;
                end
            end
        end
        function result = get.containerType(obj)
            if ismethod(obj, 'get_containerType')
                result = obj.get_containerType();
            else
                if isKey(obj.props_, 'container_type')
                    result = obj.props_('container_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.containerType(obj, value)
            obj.props_('container_type') = value;
        end
        function result = get.containerId(obj)
            if ismethod(obj, 'get_containerId')
                result = obj.get_containerId();
            else
                if isKey(obj.props_, 'container_id')
                    result = obj.props_('container_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.containerId(obj, value)
            obj.props_('container_id') = value;
        end
        function result = get.fileVersion(obj)
            if ismethod(obj, 'get_fileVersion')
                result = obj.get_fileVersion();
            else
                if isKey(obj.props_, 'file_version')
                    result = obj.props_('file_version');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileVersion(obj, value)
            obj.props_('file_version') = value;
        end
        function result = get.changes(obj)
            if ismethod(obj, 'get_changes')
                result = obj.get_changes();
            else
                if isKey(obj.props_, 'changes')
                    result = obj.props_('changes');
                else
                    result = [];
                end
            end
        end
        function obj = set.changes(obj, value)
            obj.props_('changes') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'container_type')
                result('container_type') = obj.props_('container_type').toJson();
            end
            if isKey(obj.props_, 'container_id')
                result('container_id') = flywheel.ModelBase.serializeValue(obj.props_('container_id'), 'char');
            end
            if isKey(obj.props_, 'file_version')
                result('file_version') = flywheel.ModelBase.serializeValue(obj.props_('file_version'), 'integer');
            end
            if isKey(obj.props_, 'changes')
                result('changes') = flywheel.ModelBase.cellmap(@toJson, obj.props_('changes'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'container_type')
                result.containerType = struct(obj.props_('container_type'));
            else
                result.containerType = [];
            end
            if isKey(obj.props_, 'container_id')
                result.containerId = obj.props_('container_id');
            else
                result.containerId = [];
            end
            if isKey(obj.props_, 'file_version')
                result.fileVersion = obj.props_('file_version');
            else
                result.fileVersion = [];
            end
            if isKey(obj.props_, 'changes')
                result.changes = flywheel.ModelBase.cellmap(@struct, obj.props_('changes'));
            else
                result.changes = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'container_type')
                    propList.containerType = obj.props_('container_type');
                else
                    propList.containerType = [];
                end
                if isKey(obj.props_, 'container_id')
                    propList.containerId = obj.props_('container_id');
                else
                    propList.containerId = [];
                end
                if isKey(obj.props_, 'file_version')
                    propList.fileVersion = obj.props_('file_version');
                else
                    propList.fileVersion = [];
                end
                if isKey(obj.props_, 'changes')
                    propList.changes = obj.props_('changes');
                else
                    propList.changes = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FieldChangeLogDocument;
            if isfield(json, 'container_type')
                obj.props_('container_type') = flywheel.model.AnyOfFieldChangeLogDocumentContainerType.fromJson(json.container_type, context);
            end
            if isfield(json, 'container_id')
                obj.props_('container_id') = flywheel.ModelBase.deserializeValue(json.container_id, 'char');
            end
            if isfield(json, 'file_version')
                obj.props_('file_version') = flywheel.ModelBase.deserializeValue(json.file_version, 'integer');
            end
            if isfield(json, 'changes')
                obj.props_('changes') = flywheel.ModelBase.cellmap(@(x) flywheel.model.FieldChange.fromJson(x, context), json.changes);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FieldChangeLogDocument')
                    obj = flywheel.model.FieldChangeLogDocument(obj);
                end
                if isKey(obj.props_, 'container_type')
                    obj.props_('container_type') =  flywheel.model.AnyOfFieldChangeLogDocumentContainerType.ensureIsInstance(obj.props_('container_type'));
                end
                if isKey(obj.props_, 'container_id')
                end
                if isKey(obj.props_, 'file_version')
                end
                if isKey(obj.props_, 'changes')
                    obj.props_('changes') = flywheel.ModelBase.cellmap(@flywheel.model.FieldChange.ensureIsInstance, obj.props_('changes'));
                end
            end
        end
    end
end
