% FileClassificationDelta - Represents a set of changes to be applied to the file classification using the modality classification as the schema
%
% FileClassificationDelta Properties:
%    modality 
%    add      
%    delete   
%    replace  
%
% FileClassificationDelta Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FileClassificationDelta < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'modality', 'add', 'delete', 'replace' }, ...
            { 'modality', 'add', 'delete', 'replace' });
    end
    properties(Dependent)
        modality
        add
        delete
        replace
    end
    methods
        function obj = FileClassificationDelta(varargin)
            obj@flywheel.ModelBase(flywheel.model.FileClassificationDelta.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'modality', []);
                addParameter(p, 'add', []);
                addParameter(p, 'delete', []);
                addParameter(p, 'replace', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.modality)
                    obj.props_('modality') = p.Results.modality;
                end
                if ~isempty(p.Results.add)
                    obj.props_('add') = p.Results.add;
                end
                if ~isempty(p.Results.delete)
                    obj.props_('delete') = p.Results.delete;
                end
                if ~isempty(p.Results.replace)
                    obj.props_('replace') = p.Results.replace;
                end
            end
        end
        function result = get.modality(obj)
            if ismethod(obj, 'get_modality')
                result = obj.get_modality();
            else
                if isKey(obj.props_, 'modality')
                    result = obj.props_('modality');
                else
                    result = [];
                end
            end
        end
        function obj = set.modality(obj, value)
            obj.props_('modality') = value;
        end
        function result = get.add(obj)
            if ismethod(obj, 'get_add')
                result = obj.get_add();
            else
                if isKey(obj.props_, 'add')
                    result = obj.props_('add');
                else
                    result = [];
                end
            end
        end
        function obj = set.add(obj, value)
            obj.props_('add') = value;
        end
        function result = get.delete(obj)
            if ismethod(obj, 'get_delete')
                result = obj.get_delete();
            else
                if isKey(obj.props_, 'delete')
                    result = obj.props_('delete');
                else
                    result = [];
                end
            end
        end
        function obj = set.delete(obj, value)
            obj.props_('delete') = value;
        end
        function result = get.replace(obj)
            if ismethod(obj, 'get_replace')
                result = obj.get_replace();
            else
                if isKey(obj.props_, 'replace')
                    result = obj.props_('replace');
                else
                    result = [];
                end
            end
        end
        function obj = set.replace(obj, value)
            obj.props_('replace') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'modality')
                result('modality') = flywheel.ModelBase.serializeValue(obj.props_('modality'), 'char');
            end
            if isKey(obj.props_, 'add')
                result('add') = flywheel.ModelBase.serializeValue(obj.props_('add'), 'containers.Map[String, vector[char]]');
            end
            if isKey(obj.props_, 'delete')
                result('delete') = flywheel.ModelBase.serializeValue(obj.props_('delete'), 'containers.Map[String, vector[char]]');
            end
            if isKey(obj.props_, 'replace')
                result('replace') = flywheel.ModelBase.serializeValue(obj.props_('replace'), 'containers.Map[String, vector[char]]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'modality')
                result.modality = obj.props_('modality');
            else
                result.modality = [];
            end
            if isKey(obj.props_, 'add')
                result.add = obj.props_('add');
            else
                result.add = [];
            end
            if isKey(obj.props_, 'delete')
                result.delete = obj.props_('delete');
            else
                result.delete = [];
            end
            if isKey(obj.props_, 'replace')
                result.replace = obj.props_('replace');
            else
                result.replace = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'modality')
                    propList.modality = obj.props_('modality');
                else
                    propList.modality = [];
                end
                if isKey(obj.props_, 'add')
                    propList.add = obj.props_('add');
                else
                    propList.add = [];
                end
                if isKey(obj.props_, 'delete')
                    propList.delete = obj.props_('delete');
                else
                    propList.delete = [];
                end
                if isKey(obj.props_, 'replace')
                    propList.replace = obj.props_('replace');
                else
                    propList.replace = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FileClassificationDelta;
            if isfield(json, 'modality')
                obj.props_('modality') = flywheel.ModelBase.deserializeValue(json.modality, 'char');
            end
            if isfield(json, 'add')
                obj.props_('add') = flywheel.ModelBase.deserializeValue(json.add, 'containers.Map[String, vector[char]]');
            end
            if isfield(json, 'delete')
                obj.props_('delete') = flywheel.ModelBase.deserializeValue(json.delete, 'containers.Map[String, vector[char]]');
            end
            if isfield(json, 'replace')
                obj.props_('replace') = flywheel.ModelBase.deserializeValue(json.replace, 'containers.Map[String, vector[char]]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FileClassificationDelta')
                    obj = flywheel.model.FileClassificationDelta(obj);
                end
                if isKey(obj.props_, 'modality')
                end
                if isKey(obj.props_, 'add')
                end
                if isKey(obj.props_, 'delete')
                end
                if isKey(obj.props_, 'replace')
                end
            end
        end
    end
end
