% FileListOutput
%
% FileListOutput Properties:
%    id                
%    name              
%    type              
%    mimetype          
%    fileId            
%    version           
%    modality          
%    deidLogId         
%    deidLogSkipReason 
%    classification    
%    tags              
%    providerId        
%    path              
%    reference         
%    restoredFrom      
%    restoredBy        
%    parentRef         
%    parents           
%    origin            
%    virusScan         
%    created           
%    modified          
%    replaced          
%    deleted           
%    size              
%    hash              
%    info              
%    infoExists        
%    zipMemberCount    
%    gearInfo          
%    copyOf            
%    originalCopyOf    
%    clientHash        
%
% FileListOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FileListOutput < flywheel.ModelBase & flywheel.mixins.FileMixin
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'name', 'type', 'mimetype', 'fileId', 'version', 'modality', 'deidLogId', 'deidLogSkipReason', 'classification', 'tags', 'providerId', 'path', 'reference', 'restoredFrom', 'restoredBy', 'parentRef', 'parents', 'origin', 'virusScan', 'created', 'modified', 'replaced', 'deleted', 'size', 'hash', 'info', 'infoExists', 'zipMemberCount', 'gearInfo', 'copyOf', 'originalCopyOf', 'clientHash' }, ...
            { '_id', 'name', 'type', 'mimetype', 'file_id', 'version', 'modality', 'deid_log_id', 'deid_log_skip_reason', 'classification', 'tags', 'provider_id', 'path', 'reference', 'restored_from', 'restored_by', 'parent_ref', 'parents', 'origin', 'virus_scan', 'created', 'modified', 'replaced', 'deleted', 'size', 'hash', 'info', 'info_exists', 'zip_member_count', 'gear_info', 'copy_of', 'original_copy_of', 'client_hash' });
    end
    properties(Dependent)
        id
        name
        type
        mimetype
        fileId
        version
        modality
        deidLogId
        deidLogSkipReason
        classification
        tags
        providerId
        path
        reference
        restoredFrom
        restoredBy
        parentRef
        parents
        origin
        virusScan
        created
        modified
        replaced
        deleted
        size
        hash
        info
        infoExists
        zipMemberCount
        gearInfo
        copyOf
        originalCopyOf
        clientHash
    end
    methods
        function obj = FileListOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.FileListOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'name', []);
                addParameter(p, 'type', []);
                addParameter(p, 'mimetype', []);
                addParameter(p, 'fileId', []);
                addParameter(p, 'version', []);
                addParameter(p, 'modality', []);
                addParameter(p, 'deidLogId', []);
                addParameter(p, 'deidLogSkipReason', []);
                addParameter(p, 'classification', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'providerId', []);
                addParameter(p, 'path', []);
                addParameter(p, 'reference', []);
                addParameter(p, 'restoredFrom', []);
                addParameter(p, 'restoredBy', []);
                addParameter(p, 'parentRef', []);
                addParameter(p, 'parents', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'virusScan', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'replaced', []);
                addParameter(p, 'deleted', []);
                addParameter(p, 'size', []);
                addParameter(p, 'hash', []);
                addParameter(p, 'info', []);
                addParameter(p, 'infoExists', false);
                addParameter(p, 'zipMemberCount', []);
                addParameter(p, 'gearInfo', []);
                addParameter(p, 'copyOf', []);
                addParameter(p, 'originalCopyOf', []);
                addParameter(p, 'clientHash', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.mimetype)
                    obj.props_('mimetype') = p.Results.mimetype;
                end
                if ~isempty(p.Results.fileId)
                    obj.props_('file_id') = p.Results.fileId;
                end
                if ~isempty(p.Results.version)
                    obj.props_('version') = p.Results.version;
                end
                if ~isempty(p.Results.modality)
                    obj.props_('modality') = p.Results.modality;
                end
                if ~isempty(p.Results.deidLogId)
                    obj.props_('deid_log_id') = p.Results.deidLogId;
                end
                if ~isempty(p.Results.deidLogSkipReason)
                    obj.props_('deid_log_skip_reason') = p.Results.deidLogSkipReason;
                end
                if ~isempty(p.Results.classification)
                    obj.props_('classification') = p.Results.classification;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.providerId)
                    obj.props_('provider_id') = p.Results.providerId;
                end
                if ~isempty(p.Results.path)
                    obj.props_('path') = p.Results.path;
                end
                if ~isempty(p.Results.reference)
                    obj.props_('reference') = p.Results.reference;
                end
                if ~isempty(p.Results.restoredFrom)
                    obj.props_('restored_from') = p.Results.restoredFrom;
                end
                if ~isempty(p.Results.restoredBy)
                    obj.props_('restored_by') = p.Results.restoredBy;
                end
                if ~isempty(p.Results.parentRef)
                    obj.props_('parent_ref') = p.Results.parentRef;
                end
                if ~isempty(p.Results.parents)
                    obj.props_('parents') = p.Results.parents;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.virusScan)
                    obj.props_('virus_scan') = p.Results.virusScan;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.replaced)
                    obj.props_('replaced') = p.Results.replaced;
                end
                if ~isempty(p.Results.deleted)
                    obj.props_('deleted') = p.Results.deleted;
                end
                if ~isempty(p.Results.size)
                    obj.props_('size') = p.Results.size;
                end
                if ~isempty(p.Results.hash)
                    obj.props_('hash') = p.Results.hash;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
                if ~isempty(p.Results.infoExists)
                    obj.props_('info_exists') = p.Results.infoExists;
                end
                if ~isempty(p.Results.zipMemberCount)
                    obj.props_('zip_member_count') = p.Results.zipMemberCount;
                end
                if ~isempty(p.Results.gearInfo)
                    obj.props_('gear_info') = p.Results.gearInfo;
                end
                if ~isempty(p.Results.copyOf)
                    obj.props_('copy_of') = p.Results.copyOf;
                end
                if ~isempty(p.Results.originalCopyOf)
                    obj.props_('original_copy_of') = p.Results.originalCopyOf;
                end
                if ~isempty(p.Results.clientHash)
                    obj.props_('client_hash') = p.Results.clientHash;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.mimetype(obj)
            if ismethod(obj, 'get_mimetype')
                result = obj.get_mimetype();
            else
                if isKey(obj.props_, 'mimetype')
                    result = obj.props_('mimetype');
                else
                    result = [];
                end
            end
        end
        function obj = set.mimetype(obj, value)
            obj.props_('mimetype') = value;
        end
        function result = get.fileId(obj)
            if ismethod(obj, 'get_fileId')
                result = obj.get_fileId();
            else
                if isKey(obj.props_, 'file_id')
                    result = obj.props_('file_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileId(obj, value)
            obj.props_('file_id') = value;
        end
        function result = get.version(obj)
            if ismethod(obj, 'get_version')
                result = obj.get_version();
            else
                if isKey(obj.props_, 'version')
                    result = obj.props_('version');
                else
                    result = [];
                end
            end
        end
        function obj = set.version(obj, value)
            obj.props_('version') = value;
        end
        function result = get.modality(obj)
            if ismethod(obj, 'get_modality')
                result = obj.get_modality();
            else
                if isKey(obj.props_, 'modality')
                    result = obj.props_('modality');
                else
                    result = [];
                end
            end
        end
        function obj = set.modality(obj, value)
            obj.props_('modality') = value;
        end
        function result = get.deidLogId(obj)
            if ismethod(obj, 'get_deidLogId')
                result = obj.get_deidLogId();
            else
                if isKey(obj.props_, 'deid_log_id')
                    result = obj.props_('deid_log_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.deidLogId(obj, value)
            obj.props_('deid_log_id') = value;
        end
        function result = get.deidLogSkipReason(obj)
            if ismethod(obj, 'get_deidLogSkipReason')
                result = obj.get_deidLogSkipReason();
            else
                if isKey(obj.props_, 'deid_log_skip_reason')
                    result = obj.props_('deid_log_skip_reason');
                else
                    result = [];
                end
            end
        end
        function obj = set.deidLogSkipReason(obj, value)
            obj.props_('deid_log_skip_reason') = value;
        end
        function result = get.classification(obj)
            if ismethod(obj, 'get_classification')
                result = obj.get_classification();
            else
                if isKey(obj.props_, 'classification')
                    result = obj.props_('classification');
                else
                    result = [];
                end
            end
        end
        function obj = set.classification(obj, value)
            obj.props_('classification') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.providerId(obj)
            if ismethod(obj, 'get_providerId')
                result = obj.get_providerId();
            else
                if isKey(obj.props_, 'provider_id')
                    result = obj.props_('provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.providerId(obj, value)
            obj.props_('provider_id') = value;
        end
        function result = get.path(obj)
            if ismethod(obj, 'get_path')
                result = obj.get_path();
            else
                if isKey(obj.props_, 'path')
                    result = obj.props_('path');
                else
                    result = [];
                end
            end
        end
        function obj = set.path(obj, value)
            obj.props_('path') = value;
        end
        function result = get.reference(obj)
            if ismethod(obj, 'get_reference')
                result = obj.get_reference();
            else
                if isKey(obj.props_, 'reference')
                    result = obj.props_('reference');
                else
                    result = [];
                end
            end
        end
        function obj = set.reference(obj, value)
            obj.props_('reference') = value;
        end
        function result = get.restoredFrom(obj)
            if ismethod(obj, 'get_restoredFrom')
                result = obj.get_restoredFrom();
            else
                if isKey(obj.props_, 'restored_from')
                    result = obj.props_('restored_from');
                else
                    result = [];
                end
            end
        end
        function obj = set.restoredFrom(obj, value)
            obj.props_('restored_from') = value;
        end
        function result = get.restoredBy(obj)
            if ismethod(obj, 'get_restoredBy')
                result = obj.get_restoredBy();
            else
                if isKey(obj.props_, 'restored_by')
                    result = obj.props_('restored_by');
                else
                    result = [];
                end
            end
        end
        function obj = set.restoredBy(obj, value)
            obj.props_('restored_by') = value;
        end
        function result = get.parentRef(obj)
            if ismethod(obj, 'get_parentRef')
                result = obj.get_parentRef();
            else
                if isKey(obj.props_, 'parent_ref')
                    result = obj.props_('parent_ref');
                else
                    result = [];
                end
            end
        end
        function obj = set.parentRef(obj, value)
            obj.props_('parent_ref') = value;
        end
        function result = get.parents(obj)
            if ismethod(obj, 'get_parents')
                result = obj.get_parents();
            else
                if isKey(obj.props_, 'parents')
                    result = obj.props_('parents');
                else
                    result = [];
                end
            end
        end
        function obj = set.parents(obj, value)
            obj.props_('parents') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.virusScan(obj)
            if ismethod(obj, 'get_virusScan')
                result = obj.get_virusScan();
            else
                if isKey(obj.props_, 'virus_scan')
                    result = obj.props_('virus_scan');
                else
                    result = [];
                end
            end
        end
        function obj = set.virusScan(obj, value)
            obj.props_('virus_scan') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.replaced(obj)
            if ismethod(obj, 'get_replaced')
                result = obj.get_replaced();
            else
                if isKey(obj.props_, 'replaced')
                    result = obj.props_('replaced');
                else
                    result = [];
                end
            end
        end
        function obj = set.replaced(obj, value)
            obj.props_('replaced') = value;
        end
        function result = get.deleted(obj)
            if ismethod(obj, 'get_deleted')
                result = obj.get_deleted();
            else
                if isKey(obj.props_, 'deleted')
                    result = obj.props_('deleted');
                else
                    result = [];
                end
            end
        end
        function obj = set.deleted(obj, value)
            obj.props_('deleted') = value;
        end
        function result = get.size(obj)
            if ismethod(obj, 'get_size')
                result = obj.get_size();
            else
                if isKey(obj.props_, 'size')
                    result = obj.props_('size');
                else
                    result = [];
                end
            end
        end
        function obj = set.size(obj, value)
            obj.props_('size') = value;
        end
        function result = get.hash(obj)
            if ismethod(obj, 'get_hash')
                result = obj.get_hash();
            else
                if isKey(obj.props_, 'hash')
                    result = obj.props_('hash');
                else
                    result = [];
                end
            end
        end
        function obj = set.hash(obj, value)
            obj.props_('hash') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = get.infoExists(obj)
            if ismethod(obj, 'get_infoExists')
                result = obj.get_infoExists();
            else
                if isKey(obj.props_, 'info_exists')
                    result = obj.props_('info_exists');
                else
                    result = [];
                end
            end
        end
        function obj = set.infoExists(obj, value)
            obj.props_('info_exists') = value;
        end
        function result = get.zipMemberCount(obj)
            if ismethod(obj, 'get_zipMemberCount')
                result = obj.get_zipMemberCount();
            else
                if isKey(obj.props_, 'zip_member_count')
                    result = obj.props_('zip_member_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.zipMemberCount(obj, value)
            obj.props_('zip_member_count') = value;
        end
        function result = get.gearInfo(obj)
            if ismethod(obj, 'get_gearInfo')
                result = obj.get_gearInfo();
            else
                if isKey(obj.props_, 'gear_info')
                    result = obj.props_('gear_info');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearInfo(obj, value)
            obj.props_('gear_info') = value;
        end
        function result = get.copyOf(obj)
            if ismethod(obj, 'get_copyOf')
                result = obj.get_copyOf();
            else
                if isKey(obj.props_, 'copy_of')
                    result = obj.props_('copy_of');
                else
                    result = [];
                end
            end
        end
        function obj = set.copyOf(obj, value)
            obj.props_('copy_of') = value;
        end
        function result = get.originalCopyOf(obj)
            if ismethod(obj, 'get_originalCopyOf')
                result = obj.get_originalCopyOf();
            else
                if isKey(obj.props_, 'original_copy_of')
                    result = obj.props_('original_copy_of');
                else
                    result = [];
                end
            end
        end
        function obj = set.originalCopyOf(obj, value)
            obj.props_('original_copy_of') = value;
        end
        function result = get.clientHash(obj)
            if ismethod(obj, 'get_clientHash')
                result = obj.get_clientHash();
            else
                if isKey(obj.props_, 'client_hash')
                    result = obj.props_('client_hash');
                else
                    result = [];
                end
            end
        end
        function obj = set.clientHash(obj, value)
            obj.props_('client_hash') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'mimetype')
                result('mimetype') = flywheel.ModelBase.serializeValue(obj.props_('mimetype'), 'char');
            end
            if isKey(obj.props_, 'file_id')
                result('file_id') = flywheel.ModelBase.serializeValue(obj.props_('file_id'), 'char');
            end
            if isKey(obj.props_, 'version')
                result('version') = flywheel.ModelBase.serializeValue(obj.props_('version'), 'integer');
            end
            if isKey(obj.props_, 'modality')
                result('modality') = flywheel.ModelBase.serializeValue(obj.props_('modality'), 'char');
            end
            if isKey(obj.props_, 'deid_log_id')
                result('deid_log_id') = flywheel.ModelBase.serializeValue(obj.props_('deid_log_id'), 'char');
            end
            if isKey(obj.props_, 'deid_log_skip_reason')
                result('deid_log_skip_reason') = obj.props_('deid_log_skip_reason').toJson();
            end
            if isKey(obj.props_, 'classification')
                result('classification') = flywheel.ModelBase.serializeValue(obj.props_('classification'), 'containers.Map[String, vector[char]]');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
            if isKey(obj.props_, 'provider_id')
                result('provider_id') = flywheel.ModelBase.serializeValue(obj.props_('provider_id'), 'char');
            end
            if isKey(obj.props_, 'path')
                result('path') = flywheel.ModelBase.serializeValue(obj.props_('path'), 'char');
            end
            if isKey(obj.props_, 'reference')
                result('reference') = flywheel.ModelBase.serializeValue(obj.props_('reference'), 'logical');
            end
            if isKey(obj.props_, 'restored_from')
                result('restored_from') = flywheel.ModelBase.serializeValue(obj.props_('restored_from'), 'integer');
            end
            if isKey(obj.props_, 'restored_by')
                result('restored_by') = obj.props_('restored_by').toJson();
            end
            if isKey(obj.props_, 'parent_ref')
                result('parent_ref') = obj.props_('parent_ref').toJson();
            end
            if isKey(obj.props_, 'parents')
                result('parents') = obj.props_('parents').toJson();
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'virus_scan')
                result('virus_scan') = obj.props_('virus_scan').toJson();
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'replaced')
                result('replaced') = flywheel.ModelBase.serializeValue(obj.props_('replaced'), 'datetime');
            end
            if isKey(obj.props_, 'deleted')
                result('deleted') = flywheel.ModelBase.serializeValue(obj.props_('deleted'), 'datetime');
            end
            if isKey(obj.props_, 'size')
                result('size') = flywheel.ModelBase.serializeValue(obj.props_('size'), 'integer');
            end
            if isKey(obj.props_, 'hash')
                result('hash') = flywheel.ModelBase.serializeValue(obj.props_('hash'), 'char');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
            if isKey(obj.props_, 'info_exists')
                result('info_exists') = flywheel.ModelBase.serializeValue(obj.props_('info_exists'), 'logical');
            end
            if isKey(obj.props_, 'zip_member_count')
                result('zip_member_count') = flywheel.ModelBase.serializeValue(obj.props_('zip_member_count'), 'integer');
            end
            if isKey(obj.props_, 'gear_info')
                result('gear_info') = obj.props_('gear_info').toJson();
            end
            if isKey(obj.props_, 'copy_of')
                result('copy_of') = obj.props_('copy_of').toJson();
            end
            if isKey(obj.props_, 'original_copy_of')
                result('original_copy_of') = obj.props_('original_copy_of').toJson();
            end
            if isKey(obj.props_, 'client_hash')
                result('client_hash') = flywheel.ModelBase.serializeValue(obj.props_('client_hash'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'mimetype')
                result.mimetype = obj.props_('mimetype');
            else
                result.mimetype = [];
            end
            if isKey(obj.props_, 'file_id')
                result.fileId = obj.props_('file_id');
            else
                result.fileId = [];
            end
            if isKey(obj.props_, 'version')
                result.version = obj.props_('version');
            else
                result.version = [];
            end
            if isKey(obj.props_, 'modality')
                result.modality = obj.props_('modality');
            else
                result.modality = [];
            end
            if isKey(obj.props_, 'deid_log_id')
                result.deidLogId = obj.props_('deid_log_id');
            else
                result.deidLogId = [];
            end
            if isKey(obj.props_, 'deid_log_skip_reason')
                result.deidLogSkipReason = struct(obj.props_('deid_log_skip_reason'));
            else
                result.deidLogSkipReason = [];
            end
            if isKey(obj.props_, 'classification')
                result.classification = obj.props_('classification');
            else
                result.classification = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'provider_id')
                result.providerId = obj.props_('provider_id');
            else
                result.providerId = [];
            end
            if isKey(obj.props_, 'path')
                result.path = obj.props_('path');
            else
                result.path = [];
            end
            if isKey(obj.props_, 'reference')
                result.reference = obj.props_('reference');
            else
                result.reference = [];
            end
            if isKey(obj.props_, 'restored_from')
                result.restoredFrom = obj.props_('restored_from');
            else
                result.restoredFrom = [];
            end
            if isKey(obj.props_, 'restored_by')
                result.restoredBy = struct(obj.props_('restored_by'));
            else
                result.restoredBy = [];
            end
            if isKey(obj.props_, 'parent_ref')
                result.parentRef = struct(obj.props_('parent_ref'));
            else
                result.parentRef = [];
            end
            if isKey(obj.props_, 'parents')
                result.parents = struct(obj.props_('parents'));
            else
                result.parents = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'virus_scan')
                result.virusScan = struct(obj.props_('virus_scan'));
            else
                result.virusScan = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'replaced')
                result.replaced = obj.props_('replaced');
            else
                result.replaced = [];
            end
            if isKey(obj.props_, 'deleted')
                result.deleted = obj.props_('deleted');
            else
                result.deleted = [];
            end
            if isKey(obj.props_, 'size')
                result.size = obj.props_('size');
            else
                result.size = [];
            end
            if isKey(obj.props_, 'hash')
                result.hash = obj.props_('hash');
            else
                result.hash = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
            if isKey(obj.props_, 'info_exists')
                result.infoExists = obj.props_('info_exists');
            else
                result.infoExists = [];
            end
            if isKey(obj.props_, 'zip_member_count')
                result.zipMemberCount = obj.props_('zip_member_count');
            else
                result.zipMemberCount = [];
            end
            if isKey(obj.props_, 'gear_info')
                result.gearInfo = struct(obj.props_('gear_info'));
            else
                result.gearInfo = [];
            end
            if isKey(obj.props_, 'copy_of')
                result.copyOf = struct(obj.props_('copy_of'));
            else
                result.copyOf = [];
            end
            if isKey(obj.props_, 'original_copy_of')
                result.originalCopyOf = struct(obj.props_('original_copy_of'));
            else
                result.originalCopyOf = [];
            end
            if isKey(obj.props_, 'client_hash')
                result.clientHash = obj.props_('client_hash');
            else
                result.clientHash = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'mimetype')
                    propList.mimetype = obj.props_('mimetype');
                else
                    propList.mimetype = [];
                end
                if isKey(obj.props_, 'file_id')
                    propList.fileId = obj.props_('file_id');
                else
                    propList.fileId = [];
                end
                if isKey(obj.props_, 'version')
                    propList.version = obj.props_('version');
                else
                    propList.version = [];
                end
                if isKey(obj.props_, 'modality')
                    propList.modality = obj.props_('modality');
                else
                    propList.modality = [];
                end
                if isKey(obj.props_, 'deid_log_id')
                    propList.deidLogId = obj.props_('deid_log_id');
                else
                    propList.deidLogId = [];
                end
                if isKey(obj.props_, 'deid_log_skip_reason')
                    propList.deidLogSkipReason = obj.props_('deid_log_skip_reason');
                else
                    propList.deidLogSkipReason = [];
                end
                if isKey(obj.props_, 'classification')
                    propList.classification = obj.props_('classification');
                else
                    propList.classification = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'provider_id')
                    propList.providerId = obj.props_('provider_id');
                else
                    propList.providerId = [];
                end
                if isKey(obj.props_, 'path')
                    propList.path = obj.props_('path');
                else
                    propList.path = [];
                end
                if isKey(obj.props_, 'reference')
                    propList.reference = obj.props_('reference');
                else
                    propList.reference = [];
                end
                if isKey(obj.props_, 'restored_from')
                    propList.restoredFrom = obj.props_('restored_from');
                else
                    propList.restoredFrom = [];
                end
                if isKey(obj.props_, 'restored_by')
                    propList.restoredBy = obj.props_('restored_by');
                else
                    propList.restoredBy = [];
                end
                if isKey(obj.props_, 'parent_ref')
                    propList.parentRef = obj.props_('parent_ref');
                else
                    propList.parentRef = [];
                end
                if isKey(obj.props_, 'parents')
                    propList.parents = obj.props_('parents');
                else
                    propList.parents = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'virus_scan')
                    propList.virusScan = obj.props_('virus_scan');
                else
                    propList.virusScan = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'replaced')
                    propList.replaced = obj.props_('replaced');
                else
                    propList.replaced = [];
                end
                if isKey(obj.props_, 'deleted')
                    propList.deleted = obj.props_('deleted');
                else
                    propList.deleted = [];
                end
                if isKey(obj.props_, 'size')
                    propList.size = obj.props_('size');
                else
                    propList.size = [];
                end
                if isKey(obj.props_, 'hash')
                    propList.hash = obj.props_('hash');
                else
                    propList.hash = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                if isKey(obj.props_, 'info_exists')
                    propList.infoExists = obj.props_('info_exists');
                else
                    propList.infoExists = [];
                end
                if isKey(obj.props_, 'zip_member_count')
                    propList.zipMemberCount = obj.props_('zip_member_count');
                else
                    propList.zipMemberCount = [];
                end
                if isKey(obj.props_, 'gear_info')
                    propList.gearInfo = obj.props_('gear_info');
                else
                    propList.gearInfo = [];
                end
                if isKey(obj.props_, 'copy_of')
                    propList.copyOf = obj.props_('copy_of');
                else
                    propList.copyOf = [];
                end
                if isKey(obj.props_, 'original_copy_of')
                    propList.originalCopyOf = obj.props_('original_copy_of');
                else
                    propList.originalCopyOf = [];
                end
                if isKey(obj.props_, 'client_hash')
                    propList.clientHash = obj.props_('client_hash');
                else
                    propList.clientHash = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FileListOutput;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'mimetype')
                obj.props_('mimetype') = flywheel.ModelBase.deserializeValue(json.mimetype, 'char');
            end
            if isfield(json, 'file_id')
                obj.props_('file_id') = flywheel.ModelBase.deserializeValue(json.file_id, 'char');
            end
            if isfield(json, 'version')
                obj.props_('version') = flywheel.ModelBase.deserializeValue(json.version, 'integer');
            end
            if isfield(json, 'modality')
                obj.props_('modality') = flywheel.ModelBase.deserializeValue(json.modality, 'char');
            end
            if isfield(json, 'deid_log_id')
                obj.props_('deid_log_id') = flywheel.ModelBase.deserializeValue(json.deid_log_id, 'char');
            end
            if isfield(json, 'deid_log_skip_reason')
                obj.props_('deid_log_skip_reason') = flywheel.model.DeidLogSkipReason.fromJson(json.deid_log_skip_reason, context);
            end
            if isfield(json, 'classification')
                obj.props_('classification') = flywheel.ModelBase.deserializeValue(json.classification, 'containers.Map[String, vector[char]]');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isfield(json, 'provider_id')
                obj.props_('provider_id') = flywheel.ModelBase.deserializeValue(json.provider_id, 'char');
            end
            if isfield(json, 'path')
                obj.props_('path') = flywheel.ModelBase.deserializeValue(json.path, 'char');
            end
            if isfield(json, 'reference')
                obj.props_('reference') = flywheel.ModelBase.deserializeValue(json.reference, 'logical');
            end
            if isfield(json, 'restored_from')
                obj.props_('restored_from') = flywheel.ModelBase.deserializeValue(json.restored_from, 'integer');
            end
            if isfield(json, 'restored_by')
                obj.props_('restored_by') = flywheel.model.Origin.fromJson(json.restored_by, context);
            end
            if isfield(json, 'parent_ref')
                obj.props_('parent_ref') = flywheel.model.ContainerReference.fromJson(json.parent_ref, context);
            end
            if isfield(json, 'parents')
                obj.props_('parents') = flywheel.model.FileParents.fromJson(json.parents, context);
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'virus_scan')
                obj.props_('virus_scan') = flywheel.model.VirusScan.fromJson(json.virus_scan, context);
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'replaced')
                obj.props_('replaced') = flywheel.ModelBase.deserializeValue(json.replaced, 'datetime');
            end
            if isfield(json, 'deleted')
                obj.props_('deleted') = flywheel.ModelBase.deserializeValue(json.deleted, 'datetime');
            end
            if isfield(json, 'size')
                obj.props_('size') = flywheel.ModelBase.deserializeValue(json.size, 'integer');
            end
            if isfield(json, 'hash')
                obj.props_('hash') = flywheel.ModelBase.deserializeValue(json.hash, 'char');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isfield(json, 'info_exists')
                obj.props_('info_exists') = flywheel.ModelBase.deserializeValue(json.info_exists, 'logical');
            end
            if isfield(json, 'zip_member_count')
                obj.props_('zip_member_count') = flywheel.ModelBase.deserializeValue(json.zip_member_count, 'integer');
            end
            if isfield(json, 'gear_info')
                obj.props_('gear_info') = flywheel.model.FileGearInfo.fromJson(json.gear_info, context);
            end
            if isfield(json, 'copy_of')
                obj.props_('copy_of') = flywheel.model.FileVersionCopyOf.fromJson(json.copy_of, context);
            end
            if isfield(json, 'original_copy_of')
                obj.props_('original_copy_of') = flywheel.model.FileVersion.fromJson(json.original_copy_of, context);
            end
            if isfield(json, 'client_hash')
                obj.props_('client_hash') = flywheel.ModelBase.deserializeValue(json.client_hash, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FileListOutput')
                    obj = flywheel.model.FileListOutput(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'mimetype')
                end
                if isKey(obj.props_, 'file_id')
                end
                if isKey(obj.props_, 'version')
                end
                if isKey(obj.props_, 'modality')
                end
                if isKey(obj.props_, 'deid_log_id')
                end
                if isKey(obj.props_, 'deid_log_skip_reason')
                    obj.props_('deid_log_skip_reason') =  flywheel.model.DeidLogSkipReason.ensureIsInstance(obj.props_('deid_log_skip_reason'));
                end
                if isKey(obj.props_, 'classification')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'provider_id')
                end
                if isKey(obj.props_, 'path')
                end
                if isKey(obj.props_, 'reference')
                end
                if isKey(obj.props_, 'restored_from')
                end
                if isKey(obj.props_, 'restored_by')
                    obj.props_('restored_by') =  flywheel.model.Origin.ensureIsInstance(obj.props_('restored_by'));
                end
                if isKey(obj.props_, 'parent_ref')
                    obj.props_('parent_ref') =  flywheel.model.ContainerReference.ensureIsInstance(obj.props_('parent_ref'));
                end
                if isKey(obj.props_, 'parents')
                    obj.props_('parents') =  flywheel.model.FileParents.ensureIsInstance(obj.props_('parents'));
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'virus_scan')
                    obj.props_('virus_scan') =  flywheel.model.VirusScan.ensureIsInstance(obj.props_('virus_scan'));
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'replaced')
                end
                if isKey(obj.props_, 'deleted')
                end
                if isKey(obj.props_, 'size')
                end
                if isKey(obj.props_, 'hash')
                end
                if isKey(obj.props_, 'info')
                end
                if isKey(obj.props_, 'info_exists')
                end
                if isKey(obj.props_, 'zip_member_count')
                end
                if isKey(obj.props_, 'gear_info')
                    obj.props_('gear_info') =  flywheel.model.FileGearInfo.ensureIsInstance(obj.props_('gear_info'));
                end
                if isKey(obj.props_, 'copy_of')
                    obj.props_('copy_of') =  flywheel.model.FileVersionCopyOf.ensureIsInstance(obj.props_('copy_of'));
                end
                if isKey(obj.props_, 'original_copy_of')
                    obj.props_('original_copy_of') =  flywheel.model.FileVersion.ensureIsInstance(obj.props_('original_copy_of'));
                end
                if isKey(obj.props_, 'client_hash')
                end
            end
        end
    end
end
