% FileModifyInput - User input for modifying a file
%
% FileModifyInput Properties:
%    type     
%    modality 
%
% FileModifyInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FileModifyInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'type', 'modality' }, ...
            { 'type', 'modality' });
    end
    properties(Dependent)
        type
        modality
    end
    methods
        function obj = FileModifyInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.FileModifyInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'type', []);
                addParameter(p, 'modality', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.modality)
                    obj.props_('modality') = p.Results.modality;
                end
            end
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.modality(obj)
            if ismethod(obj, 'get_modality')
                result = obj.get_modality();
            else
                if isKey(obj.props_, 'modality')
                    result = obj.props_('modality');
                else
                    result = [];
                end
            end
        end
        function obj = set.modality(obj, value)
            obj.props_('modality') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'modality')
                result('modality') = flywheel.ModelBase.serializeValue(obj.props_('modality'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'modality')
                result.modality = obj.props_('modality');
            else
                result.modality = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'modality')
                    propList.modality = obj.props_('modality');
                else
                    propList.modality = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FileModifyInput;
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'modality')
                obj.props_('modality') = flywheel.ModelBase.deserializeValue(json.modality, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FileModifyInput')
                    obj = flywheel.model.FileModifyInput(obj);
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'modality')
                end
            end
        end
    end
end
