% FileMoveInput
%
% FileMoveInput Properties:
%    containerReference 
%    name               
%    runGearRules       
%
% FileMoveInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FileMoveInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'containerReference', 'name', 'runGearRules' }, ...
            { 'container_reference', 'name', 'run_gear_rules' });
    end
    properties(Dependent)
        containerReference
        name
        runGearRules
    end
    methods
        function obj = FileMoveInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.FileMoveInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'containerReference', []);
                addParameter(p, 'name', []);
                addParameter(p, 'runGearRules', false);

                parse(p, varargin{:});

                if ~isempty(p.Results.containerReference)
                    obj.props_('container_reference') = p.Results.containerReference;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.runGearRules)
                    obj.props_('run_gear_rules') = p.Results.runGearRules;
                end
            end
        end
        function result = get.containerReference(obj)
            if ismethod(obj, 'get_containerReference')
                result = obj.get_containerReference();
            else
                if isKey(obj.props_, 'container_reference')
                    result = obj.props_('container_reference');
                else
                    result = [];
                end
            end
        end
        function obj = set.containerReference(obj, value)
            obj.props_('container_reference') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.runGearRules(obj)
            if ismethod(obj, 'get_runGearRules')
                result = obj.get_runGearRules();
            else
                if isKey(obj.props_, 'run_gear_rules')
                    result = obj.props_('run_gear_rules');
                else
                    result = [];
                end
            end
        end
        function obj = set.runGearRules(obj, value)
            obj.props_('run_gear_rules') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'container_reference')
                result('container_reference') = obj.props_('container_reference').toJson();
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'run_gear_rules')
                result('run_gear_rules') = flywheel.ModelBase.serializeValue(obj.props_('run_gear_rules'), 'logical');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'container_reference')
                result.containerReference = struct(obj.props_('container_reference'));
            else
                result.containerReference = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'run_gear_rules')
                result.runGearRules = obj.props_('run_gear_rules');
            else
                result.runGearRules = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'container_reference')
                    propList.containerReference = obj.props_('container_reference');
                else
                    propList.containerReference = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'run_gear_rules')
                    propList.runGearRules = obj.props_('run_gear_rules');
                else
                    propList.runGearRules = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FileMoveInput;
            if isfield(json, 'container_reference')
                obj.props_('container_reference') = flywheel.model.ContainerReference.fromJson(json.container_reference, context);
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'run_gear_rules')
                obj.props_('run_gear_rules') = flywheel.ModelBase.deserializeValue(json.run_gear_rules, 'logical');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FileMoveInput')
                    obj = flywheel.model.FileMoveInput(obj);
                end
                if isKey(obj.props_, 'container_reference')
                    obj.props_('container_reference') =  flywheel.model.ContainerReference.ensureIsInstance(obj.props_('container_reference'));
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'run_gear_rules')
                end
            end
        end
    end
end
