% FileOrigin
%
% FileOrigin Properties:
%    id      - Database ID of joined name and method
%    method  - Method of file origin
%    type    - Type of file origin (e.g. device, user, job)
%    name    - Name of device, user or job that originated the file
%    via    
%
% FileOrigin Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FileOrigin < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'method', 'type', 'name', 'via' }, ...
            { 'id', 'method', 'type', 'name', 'via' });
    end
    properties(Dependent)
        id
        method
        type
        name
        via
    end
    methods
        function obj = FileOrigin(varargin)
            obj@flywheel.ModelBase(flywheel.model.FileOrigin.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'method', []);
                addParameter(p, 'type', []);
                addParameter(p, 'name', []);
                addParameter(p, 'via', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('id') = p.Results.id;
                end
                if ~isempty(p.Results.method)
                    obj.props_('method') = p.Results.method;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.via)
                    obj.props_('via') = p.Results.via;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, 'id')
                    result = obj.props_('id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('id') = value;
        end
        function result = get.method(obj)
            if ismethod(obj, 'get_method')
                result = obj.get_method();
            else
                if isKey(obj.props_, 'method')
                    result = obj.props_('method');
                else
                    result = [];
                end
            end
        end
        function obj = set.method(obj, value)
            obj.props_('method') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.via(obj)
            if ismethod(obj, 'get_via')
                result = obj.get_via();
            else
                if isKey(obj.props_, 'via')
                    result = obj.props_('via');
                else
                    result = [];
                end
            end
        end
        function obj = set.via(obj, value)
            obj.props_('via') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'id')
                result('id') = flywheel.ModelBase.serializeValue(obj.props_('id'), 'char');
            end
            if isKey(obj.props_, 'method')
                result('method') = flywheel.ModelBase.serializeValue(obj.props_('method'), 'char');
            end
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'via')
                result('via') = obj.props_('via').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'id')
                result.id = obj.props_('id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'method')
                result.method = obj.props_('method');
            else
                result.method = [];
            end
            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'via')
                result.via = struct(obj.props_('via'));
            else
                result.via = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'id')
                    propList.id = obj.props_('id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'method')
                    propList.method = obj.props_('method');
                else
                    propList.method = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'via')
                    propList.via = obj.props_('via');
                else
                    propList.via = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FileOrigin;
            if isfield(json, 'id')
                obj.props_('id') = flywheel.ModelBase.deserializeValue(json.id, 'char');
            end
            if isfield(json, 'method')
                obj.props_('method') = flywheel.ModelBase.deserializeValue(json.method, 'char');
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'via')
                obj.props_('via') = flywheel.model.FileVia.fromJson(json.via, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FileOrigin')
                    obj = flywheel.model.FileOrigin(obj);
                end
                if isKey(obj.props_, 'id')
                end
                if isKey(obj.props_, 'method')
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'via')
                    obj.props_('via') =  flywheel.model.FileVia.ensureIsInstance(obj.props_('via'));
                end
            end
        end
    end
end
