% FileTemplateOptions
%
% FileTemplateOptions Properties:
%    minimum        
%    maximum        
%    mimetype       
%    modality       
%    tags           
%    classification 
%
% FileTemplateOptions Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FileTemplateOptions < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'minimum', 'maximum', 'mimetype', 'modality', 'tags', 'classification' }, ...
            { 'minimum', 'maximum', 'mimetype', 'modality', 'tags', 'classification' });
    end
    properties(Dependent)
        minimum
        maximum
        mimetype
        modality
        tags
        classification
    end
    methods
        function obj = FileTemplateOptions(varargin)
            obj@flywheel.ModelBase(flywheel.model.FileTemplateOptions.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'minimum', []);
                addParameter(p, 'maximum', []);
                addParameter(p, 'mimetype', []);
                addParameter(p, 'modality', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'classification', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.minimum)
                    obj.props_('minimum') = p.Results.minimum;
                end
                if ~isempty(p.Results.maximum)
                    obj.props_('maximum') = p.Results.maximum;
                end
                if ~isempty(p.Results.mimetype)
                    obj.props_('mimetype') = p.Results.mimetype;
                end
                if ~isempty(p.Results.modality)
                    obj.props_('modality') = p.Results.modality;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.classification)
                    obj.props_('classification') = p.Results.classification;
                end
            end
        end
        function result = get.minimum(obj)
            if ismethod(obj, 'get_minimum')
                result = obj.get_minimum();
            else
                if isKey(obj.props_, 'minimum')
                    result = obj.props_('minimum');
                else
                    result = [];
                end
            end
        end
        function obj = set.minimum(obj, value)
            obj.props_('minimum') = value;
        end
        function result = get.maximum(obj)
            if ismethod(obj, 'get_maximum')
                result = obj.get_maximum();
            else
                if isKey(obj.props_, 'maximum')
                    result = obj.props_('maximum');
                else
                    result = [];
                end
            end
        end
        function obj = set.maximum(obj, value)
            obj.props_('maximum') = value;
        end
        function result = get.mimetype(obj)
            if ismethod(obj, 'get_mimetype')
                result = obj.get_mimetype();
            else
                if isKey(obj.props_, 'mimetype')
                    result = obj.props_('mimetype');
                else
                    result = [];
                end
            end
        end
        function obj = set.mimetype(obj, value)
            obj.props_('mimetype') = value;
        end
        function result = get.modality(obj)
            if ismethod(obj, 'get_modality')
                result = obj.get_modality();
            else
                if isKey(obj.props_, 'modality')
                    result = obj.props_('modality');
                else
                    result = [];
                end
            end
        end
        function obj = set.modality(obj, value)
            obj.props_('modality') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.classification(obj)
            if ismethod(obj, 'get_classification')
                result = obj.get_classification();
            else
                if isKey(obj.props_, 'classification')
                    result = obj.props_('classification');
                else
                    result = [];
                end
            end
        end
        function obj = set.classification(obj, value)
            obj.props_('classification') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'minimum')
                result('minimum') = flywheel.ModelBase.serializeValue(obj.props_('minimum'), 'integer');
            end
            if isKey(obj.props_, 'maximum')
                result('maximum') = flywheel.ModelBase.serializeValue(obj.props_('maximum'), 'integer');
            end
            if isKey(obj.props_, 'mimetype')
                result('mimetype') = flywheel.ModelBase.serializeValue(obj.props_('mimetype'), 'char');
            end
            if isKey(obj.props_, 'modality')
                result('modality') = flywheel.ModelBase.serializeValue(obj.props_('modality'), 'char');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'char');
            end
            if isKey(obj.props_, 'classification')
                result('classification') = flywheel.ModelBase.serializeValue(obj.props_('classification'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'minimum')
                result.minimum = obj.props_('minimum');
            else
                result.minimum = [];
            end
            if isKey(obj.props_, 'maximum')
                result.maximum = obj.props_('maximum');
            else
                result.maximum = [];
            end
            if isKey(obj.props_, 'mimetype')
                result.mimetype = obj.props_('mimetype');
            else
                result.mimetype = [];
            end
            if isKey(obj.props_, 'modality')
                result.modality = obj.props_('modality');
            else
                result.modality = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'classification')
                result.classification = obj.props_('classification');
            else
                result.classification = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'minimum')
                    propList.minimum = obj.props_('minimum');
                else
                    propList.minimum = [];
                end
                if isKey(obj.props_, 'maximum')
                    propList.maximum = obj.props_('maximum');
                else
                    propList.maximum = [];
                end
                if isKey(obj.props_, 'mimetype')
                    propList.mimetype = obj.props_('mimetype');
                else
                    propList.mimetype = [];
                end
                if isKey(obj.props_, 'modality')
                    propList.modality = obj.props_('modality');
                else
                    propList.modality = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'classification')
                    propList.classification = obj.props_('classification');
                else
                    propList.classification = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FileTemplateOptions;
            if isfield(json, 'minimum')
                obj.props_('minimum') = flywheel.ModelBase.deserializeValue(json.minimum, 'integer');
            end
            if isfield(json, 'maximum')
                obj.props_('maximum') = flywheel.ModelBase.deserializeValue(json.maximum, 'integer');
            end
            if isfield(json, 'mimetype')
                obj.props_('mimetype') = flywheel.ModelBase.deserializeValue(json.mimetype, 'char');
            end
            if isfield(json, 'modality')
                obj.props_('modality') = flywheel.ModelBase.deserializeValue(json.modality, 'char');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'char');
            end
            if isfield(json, 'classification')
                obj.props_('classification') = flywheel.ModelBase.deserializeValue(json.classification, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FileTemplateOptions')
                    obj = flywheel.model.FileTemplateOptions(obj);
                end
                if isKey(obj.props_, 'minimum')
                end
                if isKey(obj.props_, 'maximum')
                end
                if isKey(obj.props_, 'mimetype')
                end
                if isKey(obj.props_, 'modality')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'classification')
                end
            end
        end
    end
end
