% FileUpsertInput - File upsert payload
%
% FileUpsertInput Properties:
%    providerId      - Unique database ID
%    uuid            - Hyphen-separated universally unique identifier
%    path           
%    reference      
%    clientHash     
%    name            - The name of the file on disk
%    size           
%    type            - A descriptive file type (e.g. dicom, image, document, ...)
%    mimetype        - A MIME Content-Type of the file
%    modality        - The type of instrument that originated the file (e.g. MR, CT, ...)
%    classification 
%    info            - Free-form information storage
%    zipMemberCount  - Number of entries in the zip archive
%    tags           
%    parentRef      
%    origin         
%    source         
%
% FileUpsertInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FileUpsertInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'providerId', 'uuid', 'path', 'reference', 'clientHash', 'name', 'size', 'type', 'mimetype', 'modality', 'classification', 'info', 'zipMemberCount', 'tags', 'parentRef', 'origin', 'source' }, ...
            { 'provider_id', 'uuid', 'path', 'reference', 'client_hash', 'name', 'size', 'type', 'mimetype', 'modality', 'classification', 'info', 'zip_member_count', 'tags', 'parent_ref', 'origin', 'source' });
    end
    properties(Dependent)
        providerId
        uuid
        path
        reference
        clientHash
        name
        size
        type
        mimetype
        modality
        classification
        info
        zipMemberCount
        tags
        parentRef
        origin
        source
    end
    methods
        function obj = FileUpsertInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.FileUpsertInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'providerId', []);
                addParameter(p, 'uuid', []);
                addParameter(p, 'path', []);
                addParameter(p, 'reference', []);
                addParameter(p, 'clientHash', []);
                addParameter(p, 'name', []);
                addParameter(p, 'size', []);
                addParameter(p, 'type', []);
                addParameter(p, 'mimetype', []);
                addParameter(p, 'modality', []);
                addParameter(p, 'classification', []);
                addParameter(p, 'info', []);
                addParameter(p, 'zipMemberCount', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'parentRef', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'source', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.providerId)
                    obj.props_('provider_id') = p.Results.providerId;
                end
                if ~isempty(p.Results.uuid)
                    obj.props_('uuid') = p.Results.uuid;
                end
                if ~isempty(p.Results.path)
                    obj.props_('path') = p.Results.path;
                end
                if ~isempty(p.Results.reference)
                    obj.props_('reference') = p.Results.reference;
                end
                if ~isempty(p.Results.clientHash)
                    obj.props_('client_hash') = p.Results.clientHash;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.size)
                    obj.props_('size') = p.Results.size;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.mimetype)
                    obj.props_('mimetype') = p.Results.mimetype;
                end
                if ~isempty(p.Results.modality)
                    obj.props_('modality') = p.Results.modality;
                end
                if ~isempty(p.Results.classification)
                    obj.props_('classification') = p.Results.classification;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
                if ~isempty(p.Results.zipMemberCount)
                    obj.props_('zip_member_count') = p.Results.zipMemberCount;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.parentRef)
                    obj.props_('parent_ref') = p.Results.parentRef;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.source)
                    obj.props_('source') = p.Results.source;
                end
            end
        end
        function result = get.providerId(obj)
            if ismethod(obj, 'get_providerId')
                result = obj.get_providerId();
            else
                if isKey(obj.props_, 'provider_id')
                    result = obj.props_('provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.providerId(obj, value)
            obj.props_('provider_id') = value;
        end
        function result = get.uuid(obj)
            if ismethod(obj, 'get_uuid')
                result = obj.get_uuid();
            else
                if isKey(obj.props_, 'uuid')
                    result = obj.props_('uuid');
                else
                    result = [];
                end
            end
        end
        function obj = set.uuid(obj, value)
            obj.props_('uuid') = value;
        end
        function result = get.path(obj)
            if ismethod(obj, 'get_path')
                result = obj.get_path();
            else
                if isKey(obj.props_, 'path')
                    result = obj.props_('path');
                else
                    result = [];
                end
            end
        end
        function obj = set.path(obj, value)
            obj.props_('path') = value;
        end
        function result = get.reference(obj)
            if ismethod(obj, 'get_reference')
                result = obj.get_reference();
            else
                if isKey(obj.props_, 'reference')
                    result = obj.props_('reference');
                else
                    result = [];
                end
            end
        end
        function obj = set.reference(obj, value)
            obj.props_('reference') = value;
        end
        function result = get.clientHash(obj)
            if ismethod(obj, 'get_clientHash')
                result = obj.get_clientHash();
            else
                if isKey(obj.props_, 'client_hash')
                    result = obj.props_('client_hash');
                else
                    result = [];
                end
            end
        end
        function obj = set.clientHash(obj, value)
            obj.props_('client_hash') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.size(obj)
            if ismethod(obj, 'get_size')
                result = obj.get_size();
            else
                if isKey(obj.props_, 'size')
                    result = obj.props_('size');
                else
                    result = [];
                end
            end
        end
        function obj = set.size(obj, value)
            obj.props_('size') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.mimetype(obj)
            if ismethod(obj, 'get_mimetype')
                result = obj.get_mimetype();
            else
                if isKey(obj.props_, 'mimetype')
                    result = obj.props_('mimetype');
                else
                    result = [];
                end
            end
        end
        function obj = set.mimetype(obj, value)
            obj.props_('mimetype') = value;
        end
        function result = get.modality(obj)
            if ismethod(obj, 'get_modality')
                result = obj.get_modality();
            else
                if isKey(obj.props_, 'modality')
                    result = obj.props_('modality');
                else
                    result = [];
                end
            end
        end
        function obj = set.modality(obj, value)
            obj.props_('modality') = value;
        end
        function result = get.classification(obj)
            if ismethod(obj, 'get_classification')
                result = obj.get_classification();
            else
                if isKey(obj.props_, 'classification')
                    result = obj.props_('classification');
                else
                    result = [];
                end
            end
        end
        function obj = set.classification(obj, value)
            obj.props_('classification') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = get.zipMemberCount(obj)
            if ismethod(obj, 'get_zipMemberCount')
                result = obj.get_zipMemberCount();
            else
                if isKey(obj.props_, 'zip_member_count')
                    result = obj.props_('zip_member_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.zipMemberCount(obj, value)
            obj.props_('zip_member_count') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.parentRef(obj)
            if ismethod(obj, 'get_parentRef')
                result = obj.get_parentRef();
            else
                if isKey(obj.props_, 'parent_ref')
                    result = obj.props_('parent_ref');
                else
                    result = [];
                end
            end
        end
        function obj = set.parentRef(obj, value)
            obj.props_('parent_ref') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.source(obj)
            if ismethod(obj, 'get_source')
                result = obj.get_source();
            else
                if isKey(obj.props_, 'source')
                    result = obj.props_('source');
                else
                    result = [];
                end
            end
        end
        function obj = set.source(obj, value)
            obj.props_('source') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'provider_id')
                result('provider_id') = flywheel.ModelBase.serializeValue(obj.props_('provider_id'), 'char');
            end
            if isKey(obj.props_, 'uuid')
                result('uuid') = flywheel.ModelBase.serializeValue(obj.props_('uuid'), 'char');
            end
            if isKey(obj.props_, 'path')
                result('path') = flywheel.ModelBase.serializeValue(obj.props_('path'), 'char');
            end
            if isKey(obj.props_, 'reference')
                result('reference') = flywheel.ModelBase.serializeValue(obj.props_('reference'), 'logical');
            end
            if isKey(obj.props_, 'client_hash')
                result('client_hash') = flywheel.ModelBase.serializeValue(obj.props_('client_hash'), 'char');
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'size')
                result('size') = flywheel.ModelBase.serializeValue(obj.props_('size'), 'integer');
            end
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'mimetype')
                result('mimetype') = flywheel.ModelBase.serializeValue(obj.props_('mimetype'), 'char');
            end
            if isKey(obj.props_, 'modality')
                result('modality') = flywheel.ModelBase.serializeValue(obj.props_('modality'), 'char');
            end
            if isKey(obj.props_, 'classification')
                result('classification') = flywheel.ModelBase.serializeValue(obj.props_('classification'), 'containers.Map[String, vector[char]]');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
            if isKey(obj.props_, 'zip_member_count')
                result('zip_member_count') = flywheel.ModelBase.serializeValue(obj.props_('zip_member_count'), 'integer');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
            if isKey(obj.props_, 'parent_ref')
                result('parent_ref') = obj.props_('parent_ref').toJson();
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'source')
                result('source') = obj.props_('source').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'provider_id')
                result.providerId = obj.props_('provider_id');
            else
                result.providerId = [];
            end
            if isKey(obj.props_, 'uuid')
                result.uuid = obj.props_('uuid');
            else
                result.uuid = [];
            end
            if isKey(obj.props_, 'path')
                result.path = obj.props_('path');
            else
                result.path = [];
            end
            if isKey(obj.props_, 'reference')
                result.reference = obj.props_('reference');
            else
                result.reference = [];
            end
            if isKey(obj.props_, 'client_hash')
                result.clientHash = obj.props_('client_hash');
            else
                result.clientHash = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'size')
                result.size = obj.props_('size');
            else
                result.size = [];
            end
            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'mimetype')
                result.mimetype = obj.props_('mimetype');
            else
                result.mimetype = [];
            end
            if isKey(obj.props_, 'modality')
                result.modality = obj.props_('modality');
            else
                result.modality = [];
            end
            if isKey(obj.props_, 'classification')
                result.classification = obj.props_('classification');
            else
                result.classification = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
            if isKey(obj.props_, 'zip_member_count')
                result.zipMemberCount = obj.props_('zip_member_count');
            else
                result.zipMemberCount = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'parent_ref')
                result.parentRef = struct(obj.props_('parent_ref'));
            else
                result.parentRef = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'source')
                result.source = struct(obj.props_('source'));
            else
                result.source = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'provider_id')
                    propList.providerId = obj.props_('provider_id');
                else
                    propList.providerId = [];
                end
                if isKey(obj.props_, 'uuid')
                    propList.uuid = obj.props_('uuid');
                else
                    propList.uuid = [];
                end
                if isKey(obj.props_, 'path')
                    propList.path = obj.props_('path');
                else
                    propList.path = [];
                end
                if isKey(obj.props_, 'reference')
                    propList.reference = obj.props_('reference');
                else
                    propList.reference = [];
                end
                if isKey(obj.props_, 'client_hash')
                    propList.clientHash = obj.props_('client_hash');
                else
                    propList.clientHash = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'size')
                    propList.size = obj.props_('size');
                else
                    propList.size = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'mimetype')
                    propList.mimetype = obj.props_('mimetype');
                else
                    propList.mimetype = [];
                end
                if isKey(obj.props_, 'modality')
                    propList.modality = obj.props_('modality');
                else
                    propList.modality = [];
                end
                if isKey(obj.props_, 'classification')
                    propList.classification = obj.props_('classification');
                else
                    propList.classification = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                if isKey(obj.props_, 'zip_member_count')
                    propList.zipMemberCount = obj.props_('zip_member_count');
                else
                    propList.zipMemberCount = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'parent_ref')
                    propList.parentRef = obj.props_('parent_ref');
                else
                    propList.parentRef = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'source')
                    propList.source = obj.props_('source');
                else
                    propList.source = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FileUpsertInput;
            if isfield(json, 'provider_id')
                obj.props_('provider_id') = flywheel.ModelBase.deserializeValue(json.provider_id, 'char');
            end
            if isfield(json, 'uuid')
                obj.props_('uuid') = flywheel.ModelBase.deserializeValue(json.uuid, 'char');
            end
            if isfield(json, 'path')
                obj.props_('path') = flywheel.ModelBase.deserializeValue(json.path, 'char');
            end
            if isfield(json, 'reference')
                obj.props_('reference') = flywheel.ModelBase.deserializeValue(json.reference, 'logical');
            end
            if isfield(json, 'client_hash')
                obj.props_('client_hash') = flywheel.ModelBase.deserializeValue(json.client_hash, 'char');
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'size')
                obj.props_('size') = flywheel.ModelBase.deserializeValue(json.size, 'integer');
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'mimetype')
                obj.props_('mimetype') = flywheel.ModelBase.deserializeValue(json.mimetype, 'char');
            end
            if isfield(json, 'modality')
                obj.props_('modality') = flywheel.ModelBase.deserializeValue(json.modality, 'char');
            end
            if isfield(json, 'classification')
                obj.props_('classification') = flywheel.ModelBase.deserializeValue(json.classification, 'containers.Map[String, vector[char]]');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isfield(json, 'zip_member_count')
                obj.props_('zip_member_count') = flywheel.ModelBase.deserializeValue(json.zip_member_count, 'integer');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isfield(json, 'parent_ref')
                obj.props_('parent_ref') = flywheel.model.ContainerReference.fromJson(json.parent_ref, context);
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'source')
                obj.props_('source') = flywheel.model.CoreModelsCommonSource.fromJson(json.source, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FileUpsertInput')
                    obj = flywheel.model.FileUpsertInput(obj);
                end
                if isKey(obj.props_, 'provider_id')
                end
                if isKey(obj.props_, 'uuid')
                end
                if isKey(obj.props_, 'path')
                end
                if isKey(obj.props_, 'reference')
                end
                if isKey(obj.props_, 'client_hash')
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'size')
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'mimetype')
                end
                if isKey(obj.props_, 'modality')
                end
                if isKey(obj.props_, 'classification')
                end
                if isKey(obj.props_, 'info')
                end
                if isKey(obj.props_, 'zip_member_count')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'parent_ref')
                    obj.props_('parent_ref') =  flywheel.model.ContainerReference.ensureIsInstance(obj.props_('parent_ref'));
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'source')
                    obj.props_('source') =  flywheel.model.CoreModelsCommonSource.ensureIsInstance(obj.props_('source'));
                end
            end
        end
    end
end
