% FileVersionCopyOf - Used to display a copied files version and metadata.
%
% FileVersionCopyOf Properties:
%    fileId       
%    version      
%    parents      
%    projectLabel 
%    groupLabel   
%
% FileVersionCopyOf Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FileVersionCopyOf < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'fileId', 'version', 'parents', 'projectLabel', 'groupLabel' }, ...
            { 'file_id', 'version', 'parents', 'project_label', 'group_label' });
    end
    properties(Dependent)
        fileId
        version
        parents
        projectLabel
        groupLabel
    end
    methods
        function obj = FileVersionCopyOf(varargin)
            obj@flywheel.ModelBase(flywheel.model.FileVersionCopyOf.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'fileId', []);
                addParameter(p, 'version', []);
                addParameter(p, 'parents', []);
                addParameter(p, 'projectLabel', []);
                addParameter(p, 'groupLabel', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.fileId)
                    obj.props_('file_id') = p.Results.fileId;
                end
                if ~isempty(p.Results.version)
                    obj.props_('version') = p.Results.version;
                end
                if ~isempty(p.Results.parents)
                    obj.props_('parents') = p.Results.parents;
                end
                if ~isempty(p.Results.projectLabel)
                    obj.props_('project_label') = p.Results.projectLabel;
                end
                if ~isempty(p.Results.groupLabel)
                    obj.props_('group_label') = p.Results.groupLabel;
                end
            end
        end
        function result = get.fileId(obj)
            if ismethod(obj, 'get_fileId')
                result = obj.get_fileId();
            else
                if isKey(obj.props_, 'file_id')
                    result = obj.props_('file_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileId(obj, value)
            obj.props_('file_id') = value;
        end
        function result = get.version(obj)
            if ismethod(obj, 'get_version')
                result = obj.get_version();
            else
                if isKey(obj.props_, 'version')
                    result = obj.props_('version');
                else
                    result = [];
                end
            end
        end
        function obj = set.version(obj, value)
            obj.props_('version') = value;
        end
        function result = get.parents(obj)
            if ismethod(obj, 'get_parents')
                result = obj.get_parents();
            else
                if isKey(obj.props_, 'parents')
                    result = obj.props_('parents');
                else
                    result = [];
                end
            end
        end
        function obj = set.parents(obj, value)
            obj.props_('parents') = value;
        end
        function result = get.projectLabel(obj)
            if ismethod(obj, 'get_projectLabel')
                result = obj.get_projectLabel();
            else
                if isKey(obj.props_, 'project_label')
                    result = obj.props_('project_label');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectLabel(obj, value)
            obj.props_('project_label') = value;
        end
        function result = get.groupLabel(obj)
            if ismethod(obj, 'get_groupLabel')
                result = obj.get_groupLabel();
            else
                if isKey(obj.props_, 'group_label')
                    result = obj.props_('group_label');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupLabel(obj, value)
            obj.props_('group_label') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'file_id')
                result('file_id') = flywheel.ModelBase.serializeValue(obj.props_('file_id'), 'char');
            end
            if isKey(obj.props_, 'version')
                result('version') = flywheel.ModelBase.serializeValue(obj.props_('version'), 'integer');
            end
            if isKey(obj.props_, 'parents')
                result('parents') = obj.props_('parents').toJson();
            end
            if isKey(obj.props_, 'project_label')
                result('project_label') = flywheel.ModelBase.serializeValue(obj.props_('project_label'), 'char');
            end
            if isKey(obj.props_, 'group_label')
                result('group_label') = flywheel.ModelBase.serializeValue(obj.props_('group_label'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'file_id')
                result.fileId = obj.props_('file_id');
            else
                result.fileId = [];
            end
            if isKey(obj.props_, 'version')
                result.version = obj.props_('version');
            else
                result.version = [];
            end
            if isKey(obj.props_, 'parents')
                result.parents = struct(obj.props_('parents'));
            else
                result.parents = [];
            end
            if isKey(obj.props_, 'project_label')
                result.projectLabel = obj.props_('project_label');
            else
                result.projectLabel = [];
            end
            if isKey(obj.props_, 'group_label')
                result.groupLabel = obj.props_('group_label');
            else
                result.groupLabel = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'file_id')
                    propList.fileId = obj.props_('file_id');
                else
                    propList.fileId = [];
                end
                if isKey(obj.props_, 'version')
                    propList.version = obj.props_('version');
                else
                    propList.version = [];
                end
                if isKey(obj.props_, 'parents')
                    propList.parents = obj.props_('parents');
                else
                    propList.parents = [];
                end
                if isKey(obj.props_, 'project_label')
                    propList.projectLabel = obj.props_('project_label');
                else
                    propList.projectLabel = [];
                end
                if isKey(obj.props_, 'group_label')
                    propList.groupLabel = obj.props_('group_label');
                else
                    propList.groupLabel = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FileVersionCopyOf;
            if isfield(json, 'file_id')
                obj.props_('file_id') = flywheel.ModelBase.deserializeValue(json.file_id, 'char');
            end
            if isfield(json, 'version')
                obj.props_('version') = flywheel.ModelBase.deserializeValue(json.version, 'integer');
            end
            if isfield(json, 'parents')
                obj.props_('parents') = flywheel.model.FileParents.fromJson(json.parents, context);
            end
            if isfield(json, 'project_label')
                obj.props_('project_label') = flywheel.ModelBase.deserializeValue(json.project_label, 'char');
            end
            if isfield(json, 'group_label')
                obj.props_('group_label') = flywheel.ModelBase.deserializeValue(json.group_label, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FileVersionCopyOf')
                    obj = flywheel.model.FileVersionCopyOf(obj);
                end
                if isKey(obj.props_, 'file_id')
                end
                if isKey(obj.props_, 'version')
                end
                if isKey(obj.props_, 'parents')
                    obj.props_('parents') =  flywheel.model.FileParents.ensureIsInstance(obj.props_('parents'));
                end
                if isKey(obj.props_, 'project_label')
                end
                if isKey(obj.props_, 'group_label')
                end
            end
        end
    end
end
