% FileVersionOutput - Used by frontend to display all versions of a file
%
% FileVersionOutput Properties:
%    created      
%    deleted      
%    fileId       
%    origin       
%    restoredFrom 
%    restoredBy   
%    version      
%
% FileVersionOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FileVersionOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'created', 'deleted', 'fileId', 'origin', 'restoredFrom', 'restoredBy', 'version' }, ...
            { 'created', 'deleted', 'file_id', 'origin', 'restored_from', 'restored_by', 'version' });
    end
    properties(Dependent)
        created
        deleted
        fileId
        origin
        restoredFrom
        restoredBy
        version
    end
    methods
        function obj = FileVersionOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.FileVersionOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'created', []);
                addParameter(p, 'deleted', []);
                addParameter(p, 'fileId', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'restoredFrom', []);
                addParameter(p, 'restoredBy', []);
                addParameter(p, 'version', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.deleted)
                    obj.props_('deleted') = p.Results.deleted;
                end
                if ~isempty(p.Results.fileId)
                    obj.props_('file_id') = p.Results.fileId;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.restoredFrom)
                    obj.props_('restored_from') = p.Results.restoredFrom;
                end
                if ~isempty(p.Results.restoredBy)
                    obj.props_('restored_by') = p.Results.restoredBy;
                end
                if ~isempty(p.Results.version)
                    obj.props_('version') = p.Results.version;
                end
            end
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.deleted(obj)
            if ismethod(obj, 'get_deleted')
                result = obj.get_deleted();
            else
                if isKey(obj.props_, 'deleted')
                    result = obj.props_('deleted');
                else
                    result = [];
                end
            end
        end
        function obj = set.deleted(obj, value)
            obj.props_('deleted') = value;
        end
        function result = get.fileId(obj)
            if ismethod(obj, 'get_fileId')
                result = obj.get_fileId();
            else
                if isKey(obj.props_, 'file_id')
                    result = obj.props_('file_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileId(obj, value)
            obj.props_('file_id') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.restoredFrom(obj)
            if ismethod(obj, 'get_restoredFrom')
                result = obj.get_restoredFrom();
            else
                if isKey(obj.props_, 'restored_from')
                    result = obj.props_('restored_from');
                else
                    result = [];
                end
            end
        end
        function obj = set.restoredFrom(obj, value)
            obj.props_('restored_from') = value;
        end
        function result = get.restoredBy(obj)
            if ismethod(obj, 'get_restoredBy')
                result = obj.get_restoredBy();
            else
                if isKey(obj.props_, 'restored_by')
                    result = obj.props_('restored_by');
                else
                    result = [];
                end
            end
        end
        function obj = set.restoredBy(obj, value)
            obj.props_('restored_by') = value;
        end
        function result = get.version(obj)
            if ismethod(obj, 'get_version')
                result = obj.get_version();
            else
                if isKey(obj.props_, 'version')
                    result = obj.props_('version');
                else
                    result = [];
                end
            end
        end
        function obj = set.version(obj, value)
            obj.props_('version') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'deleted')
                result('deleted') = flywheel.ModelBase.serializeValue(obj.props_('deleted'), 'datetime');
            end
            if isKey(obj.props_, 'file_id')
                result('file_id') = flywheel.ModelBase.serializeValue(obj.props_('file_id'), 'char');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'restored_from')
                result('restored_from') = flywheel.ModelBase.serializeValue(obj.props_('restored_from'), 'integer');
            end
            if isKey(obj.props_, 'restored_by')
                result('restored_by') = obj.props_('restored_by').toJson();
            end
            if isKey(obj.props_, 'version')
                result('version') = flywheel.ModelBase.serializeValue(obj.props_('version'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'deleted')
                result.deleted = obj.props_('deleted');
            else
                result.deleted = [];
            end
            if isKey(obj.props_, 'file_id')
                result.fileId = obj.props_('file_id');
            else
                result.fileId = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'restored_from')
                result.restoredFrom = obj.props_('restored_from');
            else
                result.restoredFrom = [];
            end
            if isKey(obj.props_, 'restored_by')
                result.restoredBy = struct(obj.props_('restored_by'));
            else
                result.restoredBy = [];
            end
            if isKey(obj.props_, 'version')
                result.version = obj.props_('version');
            else
                result.version = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'deleted')
                    propList.deleted = obj.props_('deleted');
                else
                    propList.deleted = [];
                end
                if isKey(obj.props_, 'file_id')
                    propList.fileId = obj.props_('file_id');
                else
                    propList.fileId = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'restored_from')
                    propList.restoredFrom = obj.props_('restored_from');
                else
                    propList.restoredFrom = [];
                end
                if isKey(obj.props_, 'restored_by')
                    propList.restoredBy = obj.props_('restored_by');
                else
                    propList.restoredBy = [];
                end
                if isKey(obj.props_, 'version')
                    propList.version = obj.props_('version');
                else
                    propList.version = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FileVersionOutput;
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'deleted')
                obj.props_('deleted') = flywheel.ModelBase.deserializeValue(json.deleted, 'datetime');
            end
            if isfield(json, 'file_id')
                obj.props_('file_id') = flywheel.ModelBase.deserializeValue(json.file_id, 'char');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'restored_from')
                obj.props_('restored_from') = flywheel.ModelBase.deserializeValue(json.restored_from, 'integer');
            end
            if isfield(json, 'restored_by')
                obj.props_('restored_by') = flywheel.model.Origin.fromJson(json.restored_by, context);
            end
            if isfield(json, 'version')
                obj.props_('version') = flywheel.ModelBase.deserializeValue(json.version, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FileVersionOutput')
                    obj = flywheel.model.FileVersionOutput(obj);
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'deleted')
                end
                if isKey(obj.props_, 'file_id')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'restored_from')
                end
                if isKey(obj.props_, 'restored_by')
                    obj.props_('restored_by') =  flywheel.model.Origin.ensureIsInstance(obj.props_('restored_by'));
                end
                if isKey(obj.props_, 'version')
                end
            end
        end
    end
end
