% Filter
%
% Filter Properties:
%    attribute 
%    operator   - Comparison operator to filter on. Can be one of: < (lt), <= (lte), = (eq), != (neq), >= (gte), > (gt), =~ (reg), =| (in), !=| (not_in)
%    value     
%
% Filter Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Filter < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'attribute', 'operator', 'value' }, ...
            { 'attribute', 'operator', 'value' });
    end
    properties(Dependent)
        attribute
        operator
        value
    end
    methods
        function obj = Filter(varargin)
            obj@flywheel.ModelBase(flywheel.model.Filter.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'attribute', []);
                addParameter(p, 'operator', []);
                addParameter(p, 'value', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.attribute)
                    obj.props_('attribute') = p.Results.attribute;
                end
                if ~isempty(p.Results.operator)
                    obj.props_('operator') = p.Results.operator;
                end
                if ~isempty(p.Results.value)
                    obj.props_('value') = p.Results.value;
                end
            end
        end
        function result = get.attribute(obj)
            if ismethod(obj, 'get_attribute')
                result = obj.get_attribute();
            else
                if isKey(obj.props_, 'attribute')
                    result = obj.props_('attribute');
                else
                    result = [];
                end
            end
        end
        function obj = set.attribute(obj, value)
            obj.props_('attribute') = value;
        end
        function result = get.operator(obj)
            if ismethod(obj, 'get_operator')
                result = obj.get_operator();
            else
                if isKey(obj.props_, 'operator')
                    result = obj.props_('operator');
                else
                    result = [];
                end
            end
        end
        function obj = set.operator(obj, value)
            obj.props_('operator') = value;
        end
        function result = get.value(obj)
            if ismethod(obj, 'get_value')
                result = obj.get_value();
            else
                if isKey(obj.props_, 'value')
                    result = obj.props_('value');
                else
                    result = [];
                end
            end
        end
        function obj = set.value(obj, value)
            obj.props_('value') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'attribute')
                result('attribute') = flywheel.ModelBase.serializeValue(obj.props_('attribute'), 'char');
            end
            if isKey(obj.props_, 'operator')
                result('operator') = flywheel.ModelBase.serializeValue(obj.props_('operator'), 'char');
            end
            if isKey(obj.props_, 'value')
                result('value') = obj.props_('value').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'attribute')
                result.attribute = obj.props_('attribute');
            else
                result.attribute = [];
            end
            if isKey(obj.props_, 'operator')
                result.operator = obj.props_('operator');
            else
                result.operator = [];
            end
            if isKey(obj.props_, 'value')
                result.value = struct(obj.props_('value'));
            else
                result.value = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'attribute')
                    propList.attribute = obj.props_('attribute');
                else
                    propList.attribute = [];
                end
                if isKey(obj.props_, 'operator')
                    propList.operator = obj.props_('operator');
                else
                    propList.operator = [];
                end
                if isKey(obj.props_, 'value')
                    propList.value = obj.props_('value');
                else
                    propList.value = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Filter;
            if isfield(json, 'attribute')
                obj.props_('attribute') = flywheel.ModelBase.deserializeValue(json.attribute, 'char');
            end
            if isfield(json, 'operator')
                obj.props_('operator') = flywheel.ModelBase.deserializeValue(json.operator, 'char');
            end
            if isfield(json, 'value')
                obj.props_('value') = flywheel.model.AnyOfFilterValue.fromJson(json.value, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Filter')
                    obj = flywheel.model.Filter(obj);
                end
                if isKey(obj.props_, 'attribute')
                end
                if isKey(obj.props_, 'operator')
                end
                if isKey(obj.props_, 'value')
                    obj.props_('value') =  flywheel.model.AnyOfFilterValue.ensureIsInstance(obj.props_('value'));
                end
            end
        end
    end
end
