% FixedFileVersionInput
%
% FixedFileVersionInput Properties:
%    fileId  
%    version 
%    input   
%
% FixedFileVersionInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FixedFileVersionInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'fileId', 'version', 'input' }, ...
            { 'file_id', 'version', 'input' });
    end
    properties(Dependent)
        fileId
        version
        input
    end
    methods
        function obj = FixedFileVersionInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.FixedFileVersionInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'fileId', []);
                addParameter(p, 'version', 1);
                addParameter(p, 'input', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.fileId)
                    obj.props_('file_id') = p.Results.fileId;
                end
                if ~isempty(p.Results.version)
                    obj.props_('version') = p.Results.version;
                end
                if ~isempty(p.Results.input)
                    obj.props_('input') = p.Results.input;
                end
            end
        end
        function result = get.fileId(obj)
            if ismethod(obj, 'get_fileId')
                result = obj.get_fileId();
            else
                if isKey(obj.props_, 'file_id')
                    result = obj.props_('file_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileId(obj, value)
            obj.props_('file_id') = value;
        end
        function result = get.version(obj)
            if ismethod(obj, 'get_version')
                result = obj.get_version();
            else
                if isKey(obj.props_, 'version')
                    result = obj.props_('version');
                else
                    result = [];
                end
            end
        end
        function obj = set.version(obj, value)
            obj.props_('version') = value;
        end
        function result = get.input(obj)
            if ismethod(obj, 'get_input')
                result = obj.get_input();
            else
                if isKey(obj.props_, 'input')
                    result = obj.props_('input');
                else
                    result = [];
                end
            end
        end
        function obj = set.input(obj, value)
            obj.props_('input') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'file_id')
                result('file_id') = flywheel.ModelBase.serializeValue(obj.props_('file_id'), 'char');
            end
            if isKey(obj.props_, 'version')
                result('version') = flywheel.ModelBase.serializeValue(obj.props_('version'), 'integer');
            end
            if isKey(obj.props_, 'input')
                result('input') = flywheel.ModelBase.serializeValue(obj.props_('input'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'file_id')
                result.fileId = obj.props_('file_id');
            else
                result.fileId = [];
            end
            if isKey(obj.props_, 'version')
                result.version = obj.props_('version');
            else
                result.version = [];
            end
            if isKey(obj.props_, 'input')
                result.input = obj.props_('input');
            else
                result.input = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'file_id')
                    propList.fileId = obj.props_('file_id');
                else
                    propList.fileId = [];
                end
                if isKey(obj.props_, 'version')
                    propList.version = obj.props_('version');
                else
                    propList.version = [];
                end
                if isKey(obj.props_, 'input')
                    propList.input = obj.props_('input');
                else
                    propList.input = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FixedFileVersionInput;
            if isfield(json, 'file_id')
                obj.props_('file_id') = flywheel.ModelBase.deserializeValue(json.file_id, 'char');
            end
            if isfield(json, 'version')
                obj.props_('version') = flywheel.ModelBase.deserializeValue(json.version, 'integer');
            end
            if isfield(json, 'input')
                obj.props_('input') = flywheel.ModelBase.deserializeValue(json.input, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FixedFileVersionInput')
                    obj = flywheel.model.FixedFileVersionInput(obj);
                end
                if isKey(obj.props_, 'file_id')
                end
                if isKey(obj.props_, 'version')
                end
                if isKey(obj.props_, 'input')
                end
            end
        end
    end
end
