% FormDefinition - Holds Form.io schema only. Will be extended as needed later
%
% FormDefinition Properties:
%    components 
%
% FormDefinition Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef FormDefinition < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'components' }, ...
            { 'components' });
    end
    properties(Dependent)
        components
    end
    methods
        function obj = FormDefinition(varargin)
            obj@flywheel.ModelBase(flywheel.model.FormDefinition.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'components', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.components)
                    obj.props_('components') = p.Results.components;
                end
            end
        end
        function result = get.components(obj)
            if ismethod(obj, 'get_components')
                result = obj.get_components();
            else
                if isKey(obj.props_, 'components')
                    result = obj.props_('components');
                else
                    result = [];
                end
            end
        end
        function obj = set.components(obj, value)
            obj.props_('components') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'components')
                result('components') = flywheel.ModelBase.serializeValue(obj.props_('components'), 'vector[containers.Map]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'components')
                result.components = obj.props_('components');
            else
                result.components = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'components')
                    propList.components = obj.props_('components');
                else
                    propList.components = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.FormDefinition;
            if isfield(json, 'components')
                obj.props_('components') = flywheel.ModelBase.deserializeValue(json.components, 'vector[containers.Map]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.FormDefinition')
                    obj = flywheel.model.FormDefinition(obj);
                end
                if isKey(obj.props_, 'components')
                end
            end
        end
    end
end
