% GcpCreds
%
% GcpCreds Properties:
%    clientEmail             
%    clientId                
%    privateKeyId            
%    privateKey              
%    clientX509CertUrl       
%    projectId               
%    authUri                 
%    tokenUri                
%    authProviderX509CertUrl 
%    type                    
%
% GcpCreds Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GcpCreds < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'clientEmail', 'clientId', 'privateKeyId', 'privateKey', 'clientX509CertUrl', 'projectId', 'authUri', 'tokenUri', 'authProviderX509CertUrl', 'type' }, ...
            { 'client_email', 'client_id', 'private_key_id', 'private_key', 'client_x509_cert_url', 'project_id', 'auth_uri', 'token_uri', 'auth_provider_x509_cert_url', 'type' });
    end
    properties(Dependent)
        clientEmail
        clientId
        privateKeyId
        privateKey
        clientX509CertUrl
        projectId
        authUri
        tokenUri
        authProviderX509CertUrl
        type
    end
    methods
        function obj = GcpCreds(varargin)
            obj@flywheel.ModelBase(flywheel.model.GcpCreds.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'clientEmail', []);
                addParameter(p, 'clientId', []);
                addParameter(p, 'privateKeyId', []);
                addParameter(p, 'privateKey', []);
                addParameter(p, 'clientX509CertUrl', []);
                addParameter(p, 'projectId', []);
                addParameter(p, 'authUri', []);
                addParameter(p, 'tokenUri', []);
                addParameter(p, 'authProviderX509CertUrl', []);
                addParameter(p, 'type', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.clientEmail)
                    obj.props_('client_email') = p.Results.clientEmail;
                end
                if ~isempty(p.Results.clientId)
                    obj.props_('client_id') = p.Results.clientId;
                end
                if ~isempty(p.Results.privateKeyId)
                    obj.props_('private_key_id') = p.Results.privateKeyId;
                end
                if ~isempty(p.Results.privateKey)
                    obj.props_('private_key') = p.Results.privateKey;
                end
                if ~isempty(p.Results.clientX509CertUrl)
                    obj.props_('client_x509_cert_url') = p.Results.clientX509CertUrl;
                end
                if ~isempty(p.Results.projectId)
                    obj.props_('project_id') = p.Results.projectId;
                end
                if ~isempty(p.Results.authUri)
                    obj.props_('auth_uri') = p.Results.authUri;
                end
                if ~isempty(p.Results.tokenUri)
                    obj.props_('token_uri') = p.Results.tokenUri;
                end
                if ~isempty(p.Results.authProviderX509CertUrl)
                    obj.props_('auth_provider_x509_cert_url') = p.Results.authProviderX509CertUrl;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
            end
        end
        function result = get.clientEmail(obj)
            if ismethod(obj, 'get_clientEmail')
                result = obj.get_clientEmail();
            else
                if isKey(obj.props_, 'client_email')
                    result = obj.props_('client_email');
                else
                    result = [];
                end
            end
        end
        function obj = set.clientEmail(obj, value)
            obj.props_('client_email') = value;
        end
        function result = get.clientId(obj)
            if ismethod(obj, 'get_clientId')
                result = obj.get_clientId();
            else
                if isKey(obj.props_, 'client_id')
                    result = obj.props_('client_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.clientId(obj, value)
            obj.props_('client_id') = value;
        end
        function result = get.privateKeyId(obj)
            if ismethod(obj, 'get_privateKeyId')
                result = obj.get_privateKeyId();
            else
                if isKey(obj.props_, 'private_key_id')
                    result = obj.props_('private_key_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.privateKeyId(obj, value)
            obj.props_('private_key_id') = value;
        end
        function result = get.privateKey(obj)
            if ismethod(obj, 'get_privateKey')
                result = obj.get_privateKey();
            else
                if isKey(obj.props_, 'private_key')
                    result = obj.props_('private_key');
                else
                    result = [];
                end
            end
        end
        function obj = set.privateKey(obj, value)
            obj.props_('private_key') = value;
        end
        function result = get.clientX509CertUrl(obj)
            if ismethod(obj, 'get_clientX509CertUrl')
                result = obj.get_clientX509CertUrl();
            else
                if isKey(obj.props_, 'client_x509_cert_url')
                    result = obj.props_('client_x509_cert_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.clientX509CertUrl(obj, value)
            obj.props_('client_x509_cert_url') = value;
        end
        function result = get.projectId(obj)
            if ismethod(obj, 'get_projectId')
                result = obj.get_projectId();
            else
                if isKey(obj.props_, 'project_id')
                    result = obj.props_('project_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectId(obj, value)
            obj.props_('project_id') = value;
        end
        function result = get.authUri(obj)
            if ismethod(obj, 'get_authUri')
                result = obj.get_authUri();
            else
                if isKey(obj.props_, 'auth_uri')
                    result = obj.props_('auth_uri');
                else
                    result = [];
                end
            end
        end
        function obj = set.authUri(obj, value)
            obj.props_('auth_uri') = value;
        end
        function result = get.tokenUri(obj)
            if ismethod(obj, 'get_tokenUri')
                result = obj.get_tokenUri();
            else
                if isKey(obj.props_, 'token_uri')
                    result = obj.props_('token_uri');
                else
                    result = [];
                end
            end
        end
        function obj = set.tokenUri(obj, value)
            obj.props_('token_uri') = value;
        end
        function result = get.authProviderX509CertUrl(obj)
            if ismethod(obj, 'get_authProviderX509CertUrl')
                result = obj.get_authProviderX509CertUrl();
            else
                if isKey(obj.props_, 'auth_provider_x509_cert_url')
                    result = obj.props_('auth_provider_x509_cert_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.authProviderX509CertUrl(obj, value)
            obj.props_('auth_provider_x509_cert_url') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'client_email')
                result('client_email') = flywheel.ModelBase.serializeValue(obj.props_('client_email'), 'char');
            end
            if isKey(obj.props_, 'client_id')
                result('client_id') = flywheel.ModelBase.serializeValue(obj.props_('client_id'), 'char');
            end
            if isKey(obj.props_, 'private_key_id')
                result('private_key_id') = flywheel.ModelBase.serializeValue(obj.props_('private_key_id'), 'char');
            end
            if isKey(obj.props_, 'private_key')
                result('private_key') = flywheel.ModelBase.serializeValue(obj.props_('private_key'), 'char');
            end
            if isKey(obj.props_, 'client_x509_cert_url')
                result('client_x509_cert_url') = flywheel.ModelBase.serializeValue(obj.props_('client_x509_cert_url'), 'char');
            end
            if isKey(obj.props_, 'project_id')
                result('project_id') = flywheel.ModelBase.serializeValue(obj.props_('project_id'), 'char');
            end
            if isKey(obj.props_, 'auth_uri')
                result('auth_uri') = flywheel.ModelBase.serializeValue(obj.props_('auth_uri'), 'char');
            end
            if isKey(obj.props_, 'token_uri')
                result('token_uri') = flywheel.ModelBase.serializeValue(obj.props_('token_uri'), 'char');
            end
            if isKey(obj.props_, 'auth_provider_x509_cert_url')
                result('auth_provider_x509_cert_url') = flywheel.ModelBase.serializeValue(obj.props_('auth_provider_x509_cert_url'), 'char');
            end
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'client_email')
                result.clientEmail = obj.props_('client_email');
            else
                result.clientEmail = [];
            end
            if isKey(obj.props_, 'client_id')
                result.clientId = obj.props_('client_id');
            else
                result.clientId = [];
            end
            if isKey(obj.props_, 'private_key_id')
                result.privateKeyId = obj.props_('private_key_id');
            else
                result.privateKeyId = [];
            end
            if isKey(obj.props_, 'private_key')
                result.privateKey = obj.props_('private_key');
            else
                result.privateKey = [];
            end
            if isKey(obj.props_, 'client_x509_cert_url')
                result.clientX509CertUrl = obj.props_('client_x509_cert_url');
            else
                result.clientX509CertUrl = [];
            end
            if isKey(obj.props_, 'project_id')
                result.projectId = obj.props_('project_id');
            else
                result.projectId = [];
            end
            if isKey(obj.props_, 'auth_uri')
                result.authUri = obj.props_('auth_uri');
            else
                result.authUri = [];
            end
            if isKey(obj.props_, 'token_uri')
                result.tokenUri = obj.props_('token_uri');
            else
                result.tokenUri = [];
            end
            if isKey(obj.props_, 'auth_provider_x509_cert_url')
                result.authProviderX509CertUrl = obj.props_('auth_provider_x509_cert_url');
            else
                result.authProviderX509CertUrl = [];
            end
            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'client_email')
                    propList.clientEmail = obj.props_('client_email');
                else
                    propList.clientEmail = [];
                end
                if isKey(obj.props_, 'client_id')
                    propList.clientId = obj.props_('client_id');
                else
                    propList.clientId = [];
                end
                if isKey(obj.props_, 'private_key_id')
                    propList.privateKeyId = obj.props_('private_key_id');
                else
                    propList.privateKeyId = [];
                end
                if isKey(obj.props_, 'private_key')
                    propList.privateKey = obj.props_('private_key');
                else
                    propList.privateKey = [];
                end
                if isKey(obj.props_, 'client_x509_cert_url')
                    propList.clientX509CertUrl = obj.props_('client_x509_cert_url');
                else
                    propList.clientX509CertUrl = [];
                end
                if isKey(obj.props_, 'project_id')
                    propList.projectId = obj.props_('project_id');
                else
                    propList.projectId = [];
                end
                if isKey(obj.props_, 'auth_uri')
                    propList.authUri = obj.props_('auth_uri');
                else
                    propList.authUri = [];
                end
                if isKey(obj.props_, 'token_uri')
                    propList.tokenUri = obj.props_('token_uri');
                else
                    propList.tokenUri = [];
                end
                if isKey(obj.props_, 'auth_provider_x509_cert_url')
                    propList.authProviderX509CertUrl = obj.props_('auth_provider_x509_cert_url');
                else
                    propList.authProviderX509CertUrl = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GcpCreds;
            if isfield(json, 'client_email')
                obj.props_('client_email') = flywheel.ModelBase.deserializeValue(json.client_email, 'char');
            end
            if isfield(json, 'client_id')
                obj.props_('client_id') = flywheel.ModelBase.deserializeValue(json.client_id, 'char');
            end
            if isfield(json, 'private_key_id')
                obj.props_('private_key_id') = flywheel.ModelBase.deserializeValue(json.private_key_id, 'char');
            end
            if isfield(json, 'private_key')
                obj.props_('private_key') = flywheel.ModelBase.deserializeValue(json.private_key, 'char');
            end
            if isfield(json, 'client_x509_cert_url')
                obj.props_('client_x509_cert_url') = flywheel.ModelBase.deserializeValue(json.client_x509_cert_url, 'char');
            end
            if isfield(json, 'project_id')
                obj.props_('project_id') = flywheel.ModelBase.deserializeValue(json.project_id, 'char');
            end
            if isfield(json, 'auth_uri')
                obj.props_('auth_uri') = flywheel.ModelBase.deserializeValue(json.auth_uri, 'char');
            end
            if isfield(json, 'token_uri')
                obj.props_('token_uri') = flywheel.ModelBase.deserializeValue(json.token_uri, 'char');
            end
            if isfield(json, 'auth_provider_x509_cert_url')
                obj.props_('auth_provider_x509_cert_url') = flywheel.ModelBase.deserializeValue(json.auth_provider_x509_cert_url, 'char');
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GcpCreds')
                    obj = flywheel.model.GcpCreds(obj);
                end
                if isKey(obj.props_, 'client_email')
                end
                if isKey(obj.props_, 'client_id')
                end
                if isKey(obj.props_, 'private_key_id')
                end
                if isKey(obj.props_, 'private_key')
                end
                if isKey(obj.props_, 'client_x509_cert_url')
                end
                if isKey(obj.props_, 'project_id')
                end
                if isKey(obj.props_, 'auth_uri')
                end
                if isKey(obj.props_, 'token_uri')
                end
                if isKey(obj.props_, 'auth_provider_x509_cert_url')
                end
                if isKey(obj.props_, 'type')
                end
            end
        end
    end
end
