% Gear - Gear manifest
%
% Gear Properties:
%    author        - The author of this gear.
%    capabilities 
%    maintainer    - (optional) The maintainer of this gear. Can be used to distinguish the algorithm author from the gear maintainer.
%    cite          - (optional) Any citations relevant to the algorithm(s) or work present in the gear.
%    config       
%    custom       
%    description   - A brief description of the gear's purpose. Ideally 1-4 sentences.
%    environment  
%    flywheel     
%    command       - If provided, the starting command for the gear, rather than /flywheel/v0/run. Will be templated according to the spec.
%    inputs       
%    label         - The human-friendly name of this gear.
%    license       - Software license of the gear
%    name          - The identification of this gear.
%    source        - A valid URI, or empty string.
%    url           - A valid URI, or empty string.
%    version       - A human-friendly string explaining the release version of this gear. Example: 3.2.1
%
% Gear Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Gear < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'author', 'capabilities', 'maintainer', 'cite', 'config', 'custom', 'description', 'environment', 'flywheel', 'command', 'inputs', 'label', 'license', 'name', 'source', 'url', 'version' }, ...
            { 'author', 'capabilities', 'maintainer', 'cite', 'config', 'custom', 'description', 'environment', 'flywheel', 'command', 'inputs', 'label', 'license', 'name', 'source', 'url', 'version' });
    end
    properties(Dependent)
        author
        capabilities
        maintainer
        cite
        config
        custom
        description
        environment
        flywheel
        command
        inputs
        label
        license
        name
        source
        url
        version
    end
    methods
        function obj = Gear(varargin)
            obj@flywheel.ModelBase(flywheel.model.Gear.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'author', []);
                addParameter(p, 'capabilities', []);
                addParameter(p, 'maintainer', []);
                addParameter(p, 'cite', []);
                addParameter(p, 'config', []);
                addParameter(p, 'custom', []);
                addParameter(p, 'description', []);
                addParameter(p, 'environment', []);
                addParameter(p, 'flywheel', []);
                addParameter(p, 'command', []);
                addParameter(p, 'inputs', []);
                addParameter(p, 'label', []);
                addParameter(p, 'license', []);
                addParameter(p, 'name', []);
                addParameter(p, 'source', []);
                addParameter(p, 'url', []);
                addParameter(p, 'version', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.author)
                    obj.props_('author') = p.Results.author;
                end
                if ~isempty(p.Results.capabilities)
                    obj.props_('capabilities') = p.Results.capabilities;
                end
                if ~isempty(p.Results.maintainer)
                    obj.props_('maintainer') = p.Results.maintainer;
                end
                if ~isempty(p.Results.cite)
                    obj.props_('cite') = p.Results.cite;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
                if ~isempty(p.Results.custom)
                    obj.props_('custom') = p.Results.custom;
                end
                if ~isempty(p.Results.description)
                    obj.props_('description') = p.Results.description;
                end
                if ~isempty(p.Results.environment)
                    obj.props_('environment') = p.Results.environment;
                end
                if ~isempty(p.Results.flywheel)
                    obj.props_('flywheel') = p.Results.flywheel;
                end
                if ~isempty(p.Results.command)
                    obj.props_('command') = p.Results.command;
                end
                if ~isempty(p.Results.inputs)
                    obj.props_('inputs') = p.Results.inputs;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.license)
                    obj.props_('license') = p.Results.license;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.source)
                    obj.props_('source') = p.Results.source;
                end
                if ~isempty(p.Results.url)
                    obj.props_('url') = p.Results.url;
                end
                if ~isempty(p.Results.version)
                    obj.props_('version') = p.Results.version;
                end
            end
        end
        function result = get.author(obj)
            if ismethod(obj, 'get_author')
                result = obj.get_author();
            else
                if isKey(obj.props_, 'author')
                    result = obj.props_('author');
                else
                    result = [];
                end
            end
        end
        function obj = set.author(obj, value)
            obj.props_('author') = value;
        end
        function result = get.capabilities(obj)
            if ismethod(obj, 'get_capabilities')
                result = obj.get_capabilities();
            else
                if isKey(obj.props_, 'capabilities')
                    result = obj.props_('capabilities');
                else
                    result = [];
                end
            end
        end
        function obj = set.capabilities(obj, value)
            obj.props_('capabilities') = value;
        end
        function result = get.maintainer(obj)
            if ismethod(obj, 'get_maintainer')
                result = obj.get_maintainer();
            else
                if isKey(obj.props_, 'maintainer')
                    result = obj.props_('maintainer');
                else
                    result = [];
                end
            end
        end
        function obj = set.maintainer(obj, value)
            obj.props_('maintainer') = value;
        end
        function result = get.cite(obj)
            if ismethod(obj, 'get_cite')
                result = obj.get_cite();
            else
                if isKey(obj.props_, 'cite')
                    result = obj.props_('cite');
                else
                    result = [];
                end
            end
        end
        function obj = set.cite(obj, value)
            obj.props_('cite') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = get.custom(obj)
            if ismethod(obj, 'get_custom')
                result = obj.get_custom();
            else
                if isKey(obj.props_, 'custom')
                    result = obj.props_('custom');
                else
                    result = [];
                end
            end
        end
        function obj = set.custom(obj, value)
            obj.props_('custom') = value;
        end
        function result = get.description(obj)
            if ismethod(obj, 'get_description')
                result = obj.get_description();
            else
                if isKey(obj.props_, 'description')
                    result = obj.props_('description');
                else
                    result = [];
                end
            end
        end
        function obj = set.description(obj, value)
            obj.props_('description') = value;
        end
        function result = get.environment(obj)
            if ismethod(obj, 'get_environment')
                result = obj.get_environment();
            else
                if isKey(obj.props_, 'environment')
                    result = obj.props_('environment');
                else
                    result = [];
                end
            end
        end
        function obj = set.environment(obj, value)
            obj.props_('environment') = value;
        end
        function result = get.flywheel(obj)
            if ismethod(obj, 'get_flywheel')
                result = obj.get_flywheel();
            else
                if isKey(obj.props_, 'flywheel')
                    result = obj.props_('flywheel');
                else
                    result = [];
                end
            end
        end
        function obj = set.flywheel(obj, value)
            obj.props_('flywheel') = value;
        end
        function result = get.command(obj)
            if ismethod(obj, 'get_command')
                result = obj.get_command();
            else
                if isKey(obj.props_, 'command')
                    result = obj.props_('command');
                else
                    result = [];
                end
            end
        end
        function obj = set.command(obj, value)
            obj.props_('command') = value;
        end
        function result = get.inputs(obj)
            if ismethod(obj, 'get_inputs')
                result = obj.get_inputs();
            else
                if isKey(obj.props_, 'inputs')
                    result = obj.props_('inputs');
                else
                    result = [];
                end
            end
        end
        function obj = set.inputs(obj, value)
            obj.props_('inputs') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.license(obj)
            if ismethod(obj, 'get_license')
                result = obj.get_license();
            else
                if isKey(obj.props_, 'license')
                    result = obj.props_('license');
                else
                    result = [];
                end
            end
        end
        function obj = set.license(obj, value)
            obj.props_('license') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.source(obj)
            if ismethod(obj, 'get_source')
                result = obj.get_source();
            else
                if isKey(obj.props_, 'source')
                    result = obj.props_('source');
                else
                    result = [];
                end
            end
        end
        function obj = set.source(obj, value)
            obj.props_('source') = value;
        end
        function result = get.url(obj)
            if ismethod(obj, 'get_url')
                result = obj.get_url();
            else
                if isKey(obj.props_, 'url')
                    result = obj.props_('url');
                else
                    result = [];
                end
            end
        end
        function obj = set.url(obj, value)
            obj.props_('url') = value;
        end
        function result = get.version(obj)
            if ismethod(obj, 'get_version')
                result = obj.get_version();
            else
                if isKey(obj.props_, 'version')
                    result = obj.props_('version');
                else
                    result = [];
                end
            end
        end
        function obj = set.version(obj, value)
            obj.props_('version') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'author')
                result('author') = flywheel.ModelBase.serializeValue(obj.props_('author'), 'char');
            end
            if isKey(obj.props_, 'capabilities')
                result('capabilities') = flywheel.ModelBase.serializeValue(obj.props_('capabilities'), 'vector[char]');
            end
            if isKey(obj.props_, 'maintainer')
                result('maintainer') = flywheel.ModelBase.serializeValue(obj.props_('maintainer'), 'char');
            end
            if isKey(obj.props_, 'cite')
                result('cite') = flywheel.ModelBase.serializeValue(obj.props_('cite'), 'char');
            end
            if isKey(obj.props_, 'config')
                result('config') = obj.props_('config').toJson();
            else
                result('config') = flywheel.model.GearConfig().toJson();
            end
            if isKey(obj.props_, 'custom')
                result('custom') = obj.props_('custom').toJson();
            end
            if isKey(obj.props_, 'description')
                result('description') = flywheel.ModelBase.serializeValue(obj.props_('description'), 'char');
            end
            if isKey(obj.props_, 'environment')
                result('environment') = obj.props_('environment').toJson();
            end
            if isKey(obj.props_, 'flywheel')
                result('flywheel') = flywheel.ModelBase.serializeValue(obj.props_('flywheel'), 'containers.Map');
            end
            if isKey(obj.props_, 'command')
                result('command') = flywheel.ModelBase.serializeValue(obj.props_('command'), 'char');
            end
            if isKey(obj.props_, 'inputs')
                result('inputs') = obj.props_('inputs').toJson();
            else
                result('inputs') = flywheel.model.GearInputs().toJson();
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'license')
                result('license') = flywheel.ModelBase.serializeValue(obj.props_('license'), 'char');
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'source')
                result('source') = flywheel.ModelBase.serializeValue(obj.props_('source'), 'char');
            end
            if isKey(obj.props_, 'url')
                result('url') = flywheel.ModelBase.serializeValue(obj.props_('url'), 'char');
            end
            if isKey(obj.props_, 'version')
                result('version') = flywheel.ModelBase.serializeValue(obj.props_('version'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'author')
                result.author = obj.props_('author');
            else
                result.author = [];
            end
            if isKey(obj.props_, 'capabilities')
                result.capabilities = obj.props_('capabilities');
            else
                result.capabilities = [];
            end
            if isKey(obj.props_, 'maintainer')
                result.maintainer = obj.props_('maintainer');
            else
                result.maintainer = [];
            end
            if isKey(obj.props_, 'cite')
                result.cite = obj.props_('cite');
            else
                result.cite = [];
            end
            if isKey(obj.props_, 'config')
                result.config = struct(obj.props_('config'));
            else
                result.config = [];
            end
            if isKey(obj.props_, 'custom')
                result.custom = struct(obj.props_('custom'));
            else
                result.custom = [];
            end
            if isKey(obj.props_, 'description')
                result.description = obj.props_('description');
            else
                result.description = [];
            end
            if isKey(obj.props_, 'environment')
                result.environment = struct(obj.props_('environment'));
            else
                result.environment = [];
            end
            if isKey(obj.props_, 'flywheel')
                result.flywheel = obj.props_('flywheel');
            else
                result.flywheel = [];
            end
            if isKey(obj.props_, 'command')
                result.command = obj.props_('command');
            else
                result.command = [];
            end
            if isKey(obj.props_, 'inputs')
                result.inputs = struct(obj.props_('inputs'));
            else
                result.inputs = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'license')
                result.license = obj.props_('license');
            else
                result.license = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'source')
                result.source = obj.props_('source');
            else
                result.source = [];
            end
            if isKey(obj.props_, 'url')
                result.url = obj.props_('url');
            else
                result.url = [];
            end
            if isKey(obj.props_, 'version')
                result.version = obj.props_('version');
            else
                result.version = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'author')
                    propList.author = obj.props_('author');
                else
                    propList.author = [];
                end
                if isKey(obj.props_, 'capabilities')
                    propList.capabilities = obj.props_('capabilities');
                else
                    propList.capabilities = [];
                end
                if isKey(obj.props_, 'maintainer')
                    propList.maintainer = obj.props_('maintainer');
                else
                    propList.maintainer = [];
                end
                if isKey(obj.props_, 'cite')
                    propList.cite = obj.props_('cite');
                else
                    propList.cite = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                if isKey(obj.props_, 'custom')
                    propList.custom = obj.props_('custom');
                else
                    propList.custom = [];
                end
                if isKey(obj.props_, 'description')
                    propList.description = obj.props_('description');
                else
                    propList.description = [];
                end
                if isKey(obj.props_, 'environment')
                    propList.environment = obj.props_('environment');
                else
                    propList.environment = [];
                end
                if isKey(obj.props_, 'flywheel')
                    propList.flywheel = obj.props_('flywheel');
                else
                    propList.flywheel = [];
                end
                if isKey(obj.props_, 'command')
                    propList.command = obj.props_('command');
                else
                    propList.command = [];
                end
                if isKey(obj.props_, 'inputs')
                    propList.inputs = obj.props_('inputs');
                else
                    propList.inputs = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'license')
                    propList.license = obj.props_('license');
                else
                    propList.license = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'source')
                    propList.source = obj.props_('source');
                else
                    propList.source = [];
                end
                if isKey(obj.props_, 'url')
                    propList.url = obj.props_('url');
                else
                    propList.url = [];
                end
                if isKey(obj.props_, 'version')
                    propList.version = obj.props_('version');
                else
                    propList.version = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Gear;
            if isfield(json, 'author')
                obj.props_('author') = flywheel.ModelBase.deserializeValue(json.author, 'char');
            end
            if isfield(json, 'capabilities')
                obj.props_('capabilities') = flywheel.ModelBase.deserializeValue(json.capabilities, 'vector[char]');
            end
            if isfield(json, 'maintainer')
                obj.props_('maintainer') = flywheel.ModelBase.deserializeValue(json.maintainer, 'char');
            end
            if isfield(json, 'cite')
                obj.props_('cite') = flywheel.ModelBase.deserializeValue(json.cite, 'char');
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.model.GearConfig.fromJson(json.config, context);
            end
            if isfield(json, 'custom')
                obj.props_('custom') = flywheel.model.GearCustom.fromJson(json.custom, context);
            end
            if isfield(json, 'description')
                obj.props_('description') = flywheel.ModelBase.deserializeValue(json.description, 'char');
            end
            if isfield(json, 'environment')
                obj.props_('environment') = flywheel.model.GearEnvironment.fromJson(json.environment, context);
            end
            if isfield(json, 'flywheel')
                obj.props_('flywheel') = flywheel.ModelBase.deserializeValue(json.flywheel, 'containers.Map');
            end
            if isfield(json, 'command')
                obj.props_('command') = flywheel.ModelBase.deserializeValue(json.command, 'char');
            end
            if isfield(json, 'inputs')
                obj.props_('inputs') = flywheel.model.GearInputs.fromJson(json.inputs, context);
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'license')
                obj.props_('license') = flywheel.ModelBase.deserializeValue(json.license, 'char');
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'source')
                obj.props_('source') = flywheel.ModelBase.deserializeValue(json.source, 'char');
            end
            if isfield(json, 'url')
                obj.props_('url') = flywheel.ModelBase.deserializeValue(json.url, 'char');
            end
            if isfield(json, 'version')
                obj.props_('version') = flywheel.ModelBase.deserializeValue(json.version, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Gear')
                    obj = flywheel.model.Gear(obj);
                end
                if isKey(obj.props_, 'author')
                end
                if isKey(obj.props_, 'capabilities')
                end
                if isKey(obj.props_, 'maintainer')
                end
                if isKey(obj.props_, 'cite')
                end
                if isKey(obj.props_, 'config')
                    obj.props_('config') =  flywheel.model.GearConfig.ensureIsInstance(obj.props_('config'));
                end
                if isKey(obj.props_, 'custom')
                    obj.props_('custom') =  flywheel.model.GearCustom.ensureIsInstance(obj.props_('custom'));
                end
                if isKey(obj.props_, 'description')
                end
                if isKey(obj.props_, 'environment')
                    obj.props_('environment') =  flywheel.model.GearEnvironment.ensureIsInstance(obj.props_('environment'));
                end
                if isKey(obj.props_, 'flywheel')
                end
                if isKey(obj.props_, 'command')
                end
                if isKey(obj.props_, 'inputs')
                    obj.props_('inputs') =  flywheel.model.GearInputs.ensureIsInstance(obj.props_('inputs'));
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'license')
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'source')
                end
                if isKey(obj.props_, 'url')
                end
                if isKey(obj.props_, 'version')
                end
            end
        end
    end
end
