% GearDocumentLegacyInput
%
% GearDocumentLegacyInput Properties:
%    category 
%    gear     
%    exchange 
%    created  
%    modified 
%    disabled 
%
% GearDocumentLegacyInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GearDocumentLegacyInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'category', 'gear', 'exchange', 'created', 'modified', 'disabled' }, ...
            { 'category', 'gear', 'exchange', 'created', 'modified', 'disabled' });
    end
    properties(Dependent)
        category
        gear
        exchange
        created
        modified
        disabled
    end
    methods
        function obj = GearDocumentLegacyInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.GearDocumentLegacyInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'category', []);
                addParameter(p, 'gear', []);
                addParameter(p, 'exchange', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'disabled', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.category)
                    obj.props_('category') = p.Results.category;
                end
                if ~isempty(p.Results.gear)
                    obj.props_('gear') = p.Results.gear;
                end
                if ~isempty(p.Results.exchange)
                    obj.props_('exchange') = p.Results.exchange;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.disabled)
                    obj.props_('disabled') = p.Results.disabled;
                end
            end
        end
        function result = get.category(obj)
            if ismethod(obj, 'get_category')
                result = obj.get_category();
            else
                if isKey(obj.props_, 'category')
                    result = obj.props_('category');
                else
                    result = [];
                end
            end
        end
        function obj = set.category(obj, value)
            obj.props_('category') = value;
        end
        function result = get.gear(obj)
            if ismethod(obj, 'get_gear')
                result = obj.get_gear();
            else
                if isKey(obj.props_, 'gear')
                    result = obj.props_('gear');
                else
                    result = [];
                end
            end
        end
        function obj = set.gear(obj, value)
            obj.props_('gear') = value;
        end
        function result = get.exchange(obj)
            if ismethod(obj, 'get_exchange')
                result = obj.get_exchange();
            else
                if isKey(obj.props_, 'exchange')
                    result = obj.props_('exchange');
                else
                    result = [];
                end
            end
        end
        function obj = set.exchange(obj, value)
            obj.props_('exchange') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.disabled(obj)
            if ismethod(obj, 'get_disabled')
                result = obj.get_disabled();
            else
                if isKey(obj.props_, 'disabled')
                    result = obj.props_('disabled');
                else
                    result = [];
                end
            end
        end
        function obj = set.disabled(obj, value)
            obj.props_('disabled') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'category')
                result('category') = obj.props_('category').toJson();
            end
            if isKey(obj.props_, 'gear')
                result('gear') = obj.props_('gear').toJson();
            end
            if isKey(obj.props_, 'exchange')
                result('exchange') = obj.props_('exchange').toJson();
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'disabled')
                result('disabled') = flywheel.ModelBase.serializeValue(obj.props_('disabled'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'category')
                result.category = struct(obj.props_('category'));
            else
                result.category = [];
            end
            if isKey(obj.props_, 'gear')
                result.gear = struct(obj.props_('gear'));
            else
                result.gear = [];
            end
            if isKey(obj.props_, 'exchange')
                result.exchange = struct(obj.props_('exchange'));
            else
                result.exchange = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'disabled')
                result.disabled = obj.props_('disabled');
            else
                result.disabled = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'category')
                    propList.category = obj.props_('category');
                else
                    propList.category = [];
                end
                if isKey(obj.props_, 'gear')
                    propList.gear = obj.props_('gear');
                else
                    propList.gear = [];
                end
                if isKey(obj.props_, 'exchange')
                    propList.exchange = obj.props_('exchange');
                else
                    propList.exchange = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'disabled')
                    propList.disabled = obj.props_('disabled');
                else
                    propList.disabled = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GearDocumentLegacyInput;
            if isfield(json, 'category')
                obj.props_('category') = flywheel.model.AllOfGearDocumentLegacyInputCategory.fromJson(json.category, context);
            end
            if isfield(json, 'gear')
                obj.props_('gear') = flywheel.model.GearManifest.fromJson(json.gear, context);
            end
            if isfield(json, 'exchange')
                obj.props_('exchange') = flywheel.model.GearExchange.fromJson(json.exchange, context);
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'disabled')
                obj.props_('disabled') = flywheel.ModelBase.deserializeValue(json.disabled, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GearDocumentLegacyInput')
                    obj = flywheel.model.GearDocumentLegacyInput(obj);
                end
                if isKey(obj.props_, 'category')
                    obj.props_('category') =  flywheel.model.AllOfGearDocumentLegacyInputCategory.ensureIsInstance(obj.props_('category'));
                end
                if isKey(obj.props_, 'gear')
                    obj.props_('gear') =  flywheel.model.GearManifest.ensureIsInstance(obj.props_('gear'));
                end
                if isKey(obj.props_, 'exchange')
                    obj.props_('exchange') =  flywheel.model.GearExchange.ensureIsInstance(obj.props_('exchange'));
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'disabled')
                end
            end
        end
    end
end
