% GearFileInput - Represents a gear file input for a gear  Attributes:     base (str): The input type     optional (bool): A bool representing an required decision
%
% GearFileInput Properties:
%    base     
%    optional 
%
% GearFileInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GearFileInput < flywheel.ModelBase & flywheel.mixins.GearMixin
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'base', 'optional' }, ...
            { 'base', 'optional' });
    end
    properties(Dependent)
        base
        optional
    end
    methods
        function obj = GearFileInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.GearFileInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'base', &#x27;file&#x27;);
                addParameter(p, 'optional', false);

                parse(p, varargin{:});

                if ~isempty(p.Results.base)
                    obj.props_('base') = p.Results.base;
                end
                if ~isempty(p.Results.optional)
                    obj.props_('optional') = p.Results.optional;
                end
            end
        end
        function result = get.base(obj)
            if ismethod(obj, 'get_base')
                result = obj.get_base();
            else
                if isKey(obj.props_, 'base')
                    result = obj.props_('base');
                else
                    result = [];
                end
            end
        end
        function obj = set.base(obj, value)
            obj.props_('base') = value;
        end
        function result = get.optional(obj)
            if ismethod(obj, 'get_optional')
                result = obj.get_optional();
            else
                if isKey(obj.props_, 'optional')
                    result = obj.props_('optional');
                else
                    result = [];
                end
            end
        end
        function obj = set.optional(obj, value)
            obj.props_('optional') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'base')
                result('base') = flywheel.ModelBase.serializeValue(obj.props_('base'), 'char');
            end
            if isKey(obj.props_, 'optional')
                result('optional') = flywheel.ModelBase.serializeValue(obj.props_('optional'), 'logical');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'base')
                result.base = obj.props_('base');
            else
                result.base = [];
            end
            if isKey(obj.props_, 'optional')
                result.optional = obj.props_('optional');
            else
                result.optional = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'base')
                    propList.base = obj.props_('base');
                else
                    propList.base = [];
                end
                if isKey(obj.props_, 'optional')
                    propList.optional = obj.props_('optional');
                else
                    propList.optional = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GearFileInput;
            if isfield(json, 'base')
                obj.props_('base') = flywheel.ModelBase.deserializeValue(json.base, 'char');
            end
            if isfield(json, 'optional')
                obj.props_('optional') = flywheel.ModelBase.deserializeValue(json.optional, 'logical');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GearFileInput')
                    obj = flywheel.model.GearFileInput(obj);
                end
                if isKey(obj.props_, 'base')
                end
                if isKey(obj.props_, 'optional')
                end
            end
        end
    end
end
