% GearInputItem - Describes a gear input
%
% GearInputItem Properties:
%    base         - The type of gear input.
%    description  - Hackaround for description not technically being a schema directive
%    optional     - Allow the gear to mark an input file as optional.
%
% GearInputItem Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GearInputItem < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'base', 'description', 'optional' }, ...
            { 'base', 'description', 'optional' });
    end
    properties(Dependent)
        base
        description
        optional
    end
    methods
        function obj = GearInputItem(varargin)
            obj@flywheel.ModelBase(flywheel.model.GearInputItem.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'base', []);
                addParameter(p, 'description', []);
                addParameter(p, 'optional', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.base)
                    obj.props_('base') = p.Results.base;
                end
                if ~isempty(p.Results.description)
                    obj.props_('description') = p.Results.description;
                end
                if ~isempty(p.Results.optional)
                    obj.props_('optional') = p.Results.optional;
                end
            end
        end
        function result = get.base(obj)
            if ismethod(obj, 'get_base')
                result = obj.get_base();
            else
                if isKey(obj.props_, 'base')
                    result = obj.props_('base');
                else
                    result = [];
                end
            end
        end
        function obj = set.base(obj, value)
            obj.props_('base') = value;
        end
        function result = get.description(obj)
            if ismethod(obj, 'get_description')
                result = obj.get_description();
            else
                if isKey(obj.props_, 'description')
                    result = obj.props_('description');
                else
                    result = [];
                end
            end
        end
        function obj = set.description(obj, value)
            obj.props_('description') = value;
        end
        function result = get.optional(obj)
            if ismethod(obj, 'get_optional')
                result = obj.get_optional();
            else
                if isKey(obj.props_, 'optional')
                    result = obj.props_('optional');
                else
                    result = [];
                end
            end
        end
        function obj = set.optional(obj, value)
            obj.props_('optional') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'base')
                result('base') = flywheel.ModelBase.serializeValue(obj.props_('base'), 'char');
            end
            if isKey(obj.props_, 'description')
                result('description') = flywheel.ModelBase.serializeValue(obj.props_('description'), 'char');
            end
            if isKey(obj.props_, 'optional')
                result('optional') = flywheel.ModelBase.serializeValue(obj.props_('optional'), 'logical');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'base')
                result.base = obj.props_('base');
            else
                result.base = [];
            end
            if isKey(obj.props_, 'description')
                result.description = obj.props_('description');
            else
                result.description = [];
            end
            if isKey(obj.props_, 'optional')
                result.optional = obj.props_('optional');
            else
                result.optional = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'base')
                    propList.base = obj.props_('base');
                else
                    propList.base = [];
                end
                if isKey(obj.props_, 'description')
                    propList.description = obj.props_('description');
                else
                    propList.description = [];
                end
                if isKey(obj.props_, 'optional')
                    propList.optional = obj.props_('optional');
                else
                    propList.optional = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GearInputItem;
            if isfield(json, 'base')
                obj.props_('base') = flywheel.ModelBase.deserializeValue(json.base, 'char');
            end
            if isfield(json, 'description')
                obj.props_('description') = flywheel.ModelBase.deserializeValue(json.description, 'char');
            end
            if isfield(json, 'optional')
                obj.props_('optional') = flywheel.ModelBase.deserializeValue(json.optional, 'logical');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GearInputItem')
                    obj = flywheel.model.GearInputItem(obj);
                end
                if isKey(obj.props_, 'base')
                end
                if isKey(obj.props_, 'description')
                end
                if isKey(obj.props_, 'optional')
                end
            end
        end
    end
end
