% GearPermissions
%
% GearPermissions Properties:
%    users    
%    projects 
%
% GearPermissions Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GearPermissions < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'users', 'projects' }, ...
            { 'users', 'projects' });
    end
    properties(Dependent)
        users
        projects
    end
    methods
        function obj = GearPermissions(varargin)
            obj@flywheel.ModelBase(flywheel.model.GearPermissions.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'users', []);
                addParameter(p, 'projects', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.users)
                    obj.props_('users') = p.Results.users;
                end
                if ~isempty(p.Results.projects)
                    obj.props_('projects') = p.Results.projects;
                end
            end
        end
        function result = get.users(obj)
            if ismethod(obj, 'get_users')
                result = obj.get_users();
            else
                if isKey(obj.props_, 'users')
                    result = obj.props_('users');
                else
                    result = [];
                end
            end
        end
        function obj = set.users(obj, value)
            obj.props_('users') = value;
        end
        function result = get.projects(obj)
            if ismethod(obj, 'get_projects')
                result = obj.get_projects();
            else
                if isKey(obj.props_, 'projects')
                    result = obj.props_('projects');
                else
                    result = [];
                end
            end
        end
        function obj = set.projects(obj, value)
            obj.props_('projects') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'users')
                result('users') = flywheel.ModelBase.serializeValue(obj.props_('users'), 'vector[char]');
            end
            if isKey(obj.props_, 'projects')
                result('projects') = flywheel.ModelBase.serializeValue(obj.props_('projects'), 'vector[char]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'users')
                result.users = obj.props_('users');
            else
                result.users = [];
            end
            if isKey(obj.props_, 'projects')
                result.projects = obj.props_('projects');
            else
                result.projects = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'users')
                    propList.users = obj.props_('users');
                else
                    propList.users = [];
                end
                if isKey(obj.props_, 'projects')
                    propList.projects = obj.props_('projects');
                else
                    propList.projects = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GearPermissions;
            if isfield(json, 'users')
                obj.props_('users') = flywheel.ModelBase.deserializeValue(json.users, 'vector[char]');
            end
            if isfield(json, 'projects')
                obj.props_('projects') = flywheel.ModelBase.deserializeValue(json.projects, 'vector[char]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GearPermissions')
                    obj = flywheel.model.GearPermissions(obj);
                end
                if isKey(obj.props_, 'users')
                end
                if isKey(obj.props_, 'projects')
                end
            end
        end
    end
end
