% GearRule - Domain model for a gear rule  Attributes:     id (str): The id of the rule     project_id (str): The id of the project the rule runs         on or 'site' if it is a site wide rule template     gear_id (str): The gear to run     role_id (str): The id of the role     name (str): The name of the gear rule     config (Optional[dict]): The optional config for the gear     fixed_inputs (List[FixedInput]): The fixed inputs for the gear run     auto_update (bool): Flag to automatically update the gear version to         the latest     any (List[GearRuleCondition]): List of match criteria for a job to be created of         which any one of must be matched to run the job     all (List[GearRuleCondition]): List of match criteria for a job to be created of         which all of must be matched to run the job     not (List[GearRuleCondition]): List of match criteria for a job to be created of         which none of must be matched to run the job     disabled (bool): Rule will not be evaluated if set to true     compute_provider_id (Optional[str]): Set the compute provider         for the jobs
%
% GearRule Properties:
%    id                
%    projectId         
%    gearId            
%    roleId            
%    name              
%    config            
%    fixedInputs       
%    priority          
%    autoUpdate        
%    revision          
%    any               
%    all               
%    not               
%    created           
%    modified          
%    disabled          
%    computeProviderId 
%    lastModifiedBy    
%    triggeringInput   
%
% GearRule Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GearRule < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'projectId', 'gearId', 'roleId', 'name', 'config', 'fixedInputs', 'priority', 'autoUpdate', 'revision', 'any', 'all', 'not', 'created', 'modified', 'disabled', 'computeProviderId', 'lastModifiedBy', 'triggeringInput' }, ...
            { '_id', 'project_id', 'gear_id', 'role_id', 'name', 'config', 'fixed_inputs', 'priority', 'auto_update', 'revision', 'any', 'all', 'not', 'created', 'modified', 'disabled', 'compute_provider_id', 'last_modified_by', 'triggering_input' });
    end
    properties(Dependent)
        id
        projectId
        gearId
        roleId
        name
        config
        fixedInputs
        priority
        autoUpdate
        revision
        any
        all
        not
        created
        modified
        disabled
        computeProviderId
        lastModifiedBy
        triggeringInput
    end
    methods
        function obj = GearRule(varargin)
            obj@flywheel.ModelBase(flywheel.model.GearRule.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'projectId', []);
                addParameter(p, 'gearId', []);
                addParameter(p, 'roleId', []);
                addParameter(p, 'name', []);
                addParameter(p, 'config', []);
                addParameter(p, 'fixedInputs', []);
                addParameter(p, 'priority', []);
                addParameter(p, 'autoUpdate', false);
                addParameter(p, 'revision', 1);
                addParameter(p, 'any', []);
                addParameter(p, 'all', []);
                addParameter(p, 'not', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'disabled', false);
                addParameter(p, 'computeProviderId', []);
                addParameter(p, 'lastModifiedBy', []);
                addParameter(p, 'triggeringInput', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.projectId)
                    obj.props_('project_id') = p.Results.projectId;
                end
                if ~isempty(p.Results.gearId)
                    obj.props_('gear_id') = p.Results.gearId;
                end
                if ~isempty(p.Results.roleId)
                    obj.props_('role_id') = p.Results.roleId;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
                if ~isempty(p.Results.fixedInputs)
                    obj.props_('fixed_inputs') = p.Results.fixedInputs;
                end
                if ~isempty(p.Results.priority)
                    obj.props_('priority') = p.Results.priority;
                end
                if ~isempty(p.Results.autoUpdate)
                    obj.props_('auto_update') = p.Results.autoUpdate;
                end
                if ~isempty(p.Results.revision)
                    obj.props_('revision') = p.Results.revision;
                end
                if ~isempty(p.Results.any)
                    obj.props_('any') = p.Results.any;
                end
                if ~isempty(p.Results.all)
                    obj.props_('all') = p.Results.all;
                end
                if ~isempty(p.Results.not)
                    obj.props_('not') = p.Results.not;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.disabled)
                    obj.props_('disabled') = p.Results.disabled;
                end
                if ~isempty(p.Results.computeProviderId)
                    obj.props_('compute_provider_id') = p.Results.computeProviderId;
                end
                if ~isempty(p.Results.lastModifiedBy)
                    obj.props_('last_modified_by') = p.Results.lastModifiedBy;
                end
                if ~isempty(p.Results.triggeringInput)
                    obj.props_('triggering_input') = p.Results.triggeringInput;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.projectId(obj)
            if ismethod(obj, 'get_projectId')
                result = obj.get_projectId();
            else
                if isKey(obj.props_, 'project_id')
                    result = obj.props_('project_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectId(obj, value)
            obj.props_('project_id') = value;
        end
        function result = get.gearId(obj)
            if ismethod(obj, 'get_gearId')
                result = obj.get_gearId();
            else
                if isKey(obj.props_, 'gear_id')
                    result = obj.props_('gear_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearId(obj, value)
            obj.props_('gear_id') = value;
        end
        function result = get.roleId(obj)
            if ismethod(obj, 'get_roleId')
                result = obj.get_roleId();
            else
                if isKey(obj.props_, 'role_id')
                    result = obj.props_('role_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.roleId(obj, value)
            obj.props_('role_id') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = get.fixedInputs(obj)
            if ismethod(obj, 'get_fixedInputs')
                result = obj.get_fixedInputs();
            else
                if isKey(obj.props_, 'fixed_inputs')
                    result = obj.props_('fixed_inputs');
                else
                    result = [];
                end
            end
        end
        function obj = set.fixedInputs(obj, value)
            obj.props_('fixed_inputs') = value;
        end
        function result = get.priority(obj)
            if ismethod(obj, 'get_priority')
                result = obj.get_priority();
            else
                if isKey(obj.props_, 'priority')
                    result = obj.props_('priority');
                else
                    result = [];
                end
            end
        end
        function obj = set.priority(obj, value)
            obj.props_('priority') = value;
        end
        function result = get.autoUpdate(obj)
            if ismethod(obj, 'get_autoUpdate')
                result = obj.get_autoUpdate();
            else
                if isKey(obj.props_, 'auto_update')
                    result = obj.props_('auto_update');
                else
                    result = [];
                end
            end
        end
        function obj = set.autoUpdate(obj, value)
            obj.props_('auto_update') = value;
        end
        function result = get.revision(obj)
            if ismethod(obj, 'get_revision')
                result = obj.get_revision();
            else
                if isKey(obj.props_, 'revision')
                    result = obj.props_('revision');
                else
                    result = [];
                end
            end
        end
        function obj = set.revision(obj, value)
            obj.props_('revision') = value;
        end
        function result = get.any(obj)
            if ismethod(obj, 'get_any')
                result = obj.get_any();
            else
                if isKey(obj.props_, 'any')
                    result = obj.props_('any');
                else
                    result = [];
                end
            end
        end
        function obj = set.any(obj, value)
            obj.props_('any') = value;
        end
        function result = get.all(obj)
            if ismethod(obj, 'get_all')
                result = obj.get_all();
            else
                if isKey(obj.props_, 'all')
                    result = obj.props_('all');
                else
                    result = [];
                end
            end
        end
        function obj = set.all(obj, value)
            obj.props_('all') = value;
        end
        function result = get.not(obj)
            if ismethod(obj, 'get_not')
                result = obj.get_not();
            else
                if isKey(obj.props_, 'not')
                    result = obj.props_('not');
                else
                    result = [];
                end
            end
        end
        function obj = set.not(obj, value)
            obj.props_('not') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.disabled(obj)
            if ismethod(obj, 'get_disabled')
                result = obj.get_disabled();
            else
                if isKey(obj.props_, 'disabled')
                    result = obj.props_('disabled');
                else
                    result = [];
                end
            end
        end
        function obj = set.disabled(obj, value)
            obj.props_('disabled') = value;
        end
        function result = get.computeProviderId(obj)
            if ismethod(obj, 'get_computeProviderId')
                result = obj.get_computeProviderId();
            else
                if isKey(obj.props_, 'compute_provider_id')
                    result = obj.props_('compute_provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.computeProviderId(obj, value)
            obj.props_('compute_provider_id') = value;
        end
        function result = get.lastModifiedBy(obj)
            if ismethod(obj, 'get_lastModifiedBy')
                result = obj.get_lastModifiedBy();
            else
                if isKey(obj.props_, 'last_modified_by')
                    result = obj.props_('last_modified_by');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastModifiedBy(obj, value)
            obj.props_('last_modified_by') = value;
        end
        function result = get.triggeringInput(obj)
            if ismethod(obj, 'get_triggeringInput')
                result = obj.get_triggeringInput();
            else
                if isKey(obj.props_, 'triggering_input')
                    result = obj.props_('triggering_input');
                else
                    result = [];
                end
            end
        end
        function obj = set.triggeringInput(obj, value)
            obj.props_('triggering_input') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'project_id')
                result('project_id') = flywheel.ModelBase.serializeValue(obj.props_('project_id'), 'char');
            end
            if isKey(obj.props_, 'gear_id')
                result('gear_id') = flywheel.ModelBase.serializeValue(obj.props_('gear_id'), 'char');
            end
            if isKey(obj.props_, 'role_id')
                result('role_id') = flywheel.ModelBase.serializeValue(obj.props_('role_id'), 'char');
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'config')
                result('config') = flywheel.ModelBase.serializeValue(obj.props_('config'), 'containers.Map');
            end
            if isKey(obj.props_, 'fixed_inputs')
                result('fixed_inputs') = flywheel.ModelBase.cellmap(@toJson, obj.props_('fixed_inputs'));
            end
            if isKey(obj.props_, 'priority')
                result('priority') = obj.props_('priority').toJson();
            end
            if isKey(obj.props_, 'auto_update')
                result('auto_update') = flywheel.ModelBase.serializeValue(obj.props_('auto_update'), 'logical');
            end
            if isKey(obj.props_, 'revision')
                result('revision') = flywheel.ModelBase.serializeValue(obj.props_('revision'), 'integer');
            end
            if isKey(obj.props_, 'any')
                result('any') = flywheel.ModelBase.cellmap(@toJson, obj.props_('any'));
            end
            if isKey(obj.props_, 'all')
                result('all') = flywheel.ModelBase.cellmap(@toJson, obj.props_('all'));
            end
            if isKey(obj.props_, 'not')
                result('not') = flywheel.ModelBase.cellmap(@toJson, obj.props_('not'));
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'disabled')
                result('disabled') = flywheel.ModelBase.serializeValue(obj.props_('disabled'), 'logical');
            end
            if isKey(obj.props_, 'compute_provider_id')
                result('compute_provider_id') = flywheel.ModelBase.serializeValue(obj.props_('compute_provider_id'), 'char');
            end
            if isKey(obj.props_, 'last_modified_by')
                result('last_modified_by') = obj.props_('last_modified_by').toJson();
            end
            if isKey(obj.props_, 'triggering_input')
                result('triggering_input') = flywheel.ModelBase.serializeValue(obj.props_('triggering_input'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'project_id')
                result.projectId = obj.props_('project_id');
            else
                result.projectId = [];
            end
            if isKey(obj.props_, 'gear_id')
                result.gearId = obj.props_('gear_id');
            else
                result.gearId = [];
            end
            if isKey(obj.props_, 'role_id')
                result.roleId = obj.props_('role_id');
            else
                result.roleId = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'config')
                result.config = obj.props_('config');
            else
                result.config = [];
            end
            if isKey(obj.props_, 'fixed_inputs')
                result.fixedInputs = flywheel.ModelBase.cellmap(@struct, obj.props_('fixed_inputs'));
            else
                result.fixedInputs = [];
            end
            if isKey(obj.props_, 'priority')
                result.priority = struct(obj.props_('priority'));
            else
                result.priority = [];
            end
            if isKey(obj.props_, 'auto_update')
                result.autoUpdate = obj.props_('auto_update');
            else
                result.autoUpdate = [];
            end
            if isKey(obj.props_, 'revision')
                result.revision = obj.props_('revision');
            else
                result.revision = [];
            end
            if isKey(obj.props_, 'any')
                result.any = flywheel.ModelBase.cellmap(@struct, obj.props_('any'));
            else
                result.any = [];
            end
            if isKey(obj.props_, 'all')
                result.all = flywheel.ModelBase.cellmap(@struct, obj.props_('all'));
            else
                result.all = [];
            end
            if isKey(obj.props_, 'not')
                result.not = flywheel.ModelBase.cellmap(@struct, obj.props_('not'));
            else
                result.not = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'disabled')
                result.disabled = obj.props_('disabled');
            else
                result.disabled = [];
            end
            if isKey(obj.props_, 'compute_provider_id')
                result.computeProviderId = obj.props_('compute_provider_id');
            else
                result.computeProviderId = [];
            end
            if isKey(obj.props_, 'last_modified_by')
                result.lastModifiedBy = struct(obj.props_('last_modified_by'));
            else
                result.lastModifiedBy = [];
            end
            if isKey(obj.props_, 'triggering_input')
                result.triggeringInput = obj.props_('triggering_input');
            else
                result.triggeringInput = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'project_id')
                    propList.projectId = obj.props_('project_id');
                else
                    propList.projectId = [];
                end
                if isKey(obj.props_, 'gear_id')
                    propList.gearId = obj.props_('gear_id');
                else
                    propList.gearId = [];
                end
                if isKey(obj.props_, 'role_id')
                    propList.roleId = obj.props_('role_id');
                else
                    propList.roleId = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                if isKey(obj.props_, 'fixed_inputs')
                    propList.fixedInputs = obj.props_('fixed_inputs');
                else
                    propList.fixedInputs = [];
                end
                if isKey(obj.props_, 'priority')
                    propList.priority = obj.props_('priority');
                else
                    propList.priority = [];
                end
                if isKey(obj.props_, 'auto_update')
                    propList.autoUpdate = obj.props_('auto_update');
                else
                    propList.autoUpdate = [];
                end
                if isKey(obj.props_, 'revision')
                    propList.revision = obj.props_('revision');
                else
                    propList.revision = [];
                end
                if isKey(obj.props_, 'any')
                    propList.any = obj.props_('any');
                else
                    propList.any = [];
                end
                if isKey(obj.props_, 'all')
                    propList.all = obj.props_('all');
                else
                    propList.all = [];
                end
                if isKey(obj.props_, 'not')
                    propList.not = obj.props_('not');
                else
                    propList.not = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'disabled')
                    propList.disabled = obj.props_('disabled');
                else
                    propList.disabled = [];
                end
                if isKey(obj.props_, 'compute_provider_id')
                    propList.computeProviderId = obj.props_('compute_provider_id');
                else
                    propList.computeProviderId = [];
                end
                if isKey(obj.props_, 'last_modified_by')
                    propList.lastModifiedBy = obj.props_('last_modified_by');
                else
                    propList.lastModifiedBy = [];
                end
                if isKey(obj.props_, 'triggering_input')
                    propList.triggeringInput = obj.props_('triggering_input');
                else
                    propList.triggeringInput = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GearRule;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'project_id')
                obj.props_('project_id') = flywheel.ModelBase.deserializeValue(json.project_id, 'char');
            end
            if isfield(json, 'gear_id')
                obj.props_('gear_id') = flywheel.ModelBase.deserializeValue(json.gear_id, 'char');
            end
            if isfield(json, 'role_id')
                obj.props_('role_id') = flywheel.ModelBase.deserializeValue(json.role_id, 'char');
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.ModelBase.deserializeValue(json.config, 'containers.Map');
            end
            if isfield(json, 'fixed_inputs')
                obj.props_('fixed_inputs') = flywheel.ModelBase.cellmap(@(x) flywheel.model.FixedFileVersionInput.fromJson(x, context), json.fixed_inputs);
            end
            if isfield(json, 'priority')
                obj.props_('priority') = flywheel.model.AllOfGearRulePriority.fromJson(json.priority, context);
            end
            if isfield(json, 'auto_update')
                obj.props_('auto_update') = flywheel.ModelBase.deserializeValue(json.auto_update, 'logical');
            end
            if isfield(json, 'revision')
                obj.props_('revision') = flywheel.ModelBase.deserializeValue(json.revision, 'integer');
            end
            if isfield(json, 'any')
                obj.props_('any') = flywheel.ModelBase.cellmap(@(x) flywheel.model.GearRuleCondition.fromJson(x, context), json.any);
            end
            if isfield(json, 'all')
                obj.props_('all') = flywheel.ModelBase.cellmap(@(x) flywheel.model.GearRuleCondition.fromJson(x, context), json.all);
            end
            if isfield(json, 'not')
                obj.props_('not') = flywheel.ModelBase.cellmap(@(x) flywheel.model.GearRuleCondition.fromJson(x, context), json.not);
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'disabled')
                obj.props_('disabled') = flywheel.ModelBase.deserializeValue(json.disabled, 'logical');
            end
            if isfield(json, 'compute_provider_id')
                obj.props_('compute_provider_id') = flywheel.ModelBase.deserializeValue(json.compute_provider_id, 'char');
            end
            if isfield(json, 'last_modified_by')
                obj.props_('last_modified_by') = flywheel.model.Origin.fromJson(json.last_modified_by, context);
            end
            if isfield(json, 'triggering_input')
                obj.props_('triggering_input') = flywheel.ModelBase.deserializeValue(json.triggering_input, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GearRule')
                    obj = flywheel.model.GearRule(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'project_id')
                end
                if isKey(obj.props_, 'gear_id')
                end
                if isKey(obj.props_, 'role_id')
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'config')
                end
                if isKey(obj.props_, 'fixed_inputs')
                    obj.props_('fixed_inputs') = flywheel.ModelBase.cellmap(@flywheel.model.FixedFileVersionInput.ensureIsInstance, obj.props_('fixed_inputs'));
                end
                if isKey(obj.props_, 'priority')
                    obj.props_('priority') =  flywheel.model.AllOfGearRulePriority.ensureIsInstance(obj.props_('priority'));
                end
                if isKey(obj.props_, 'auto_update')
                end
                if isKey(obj.props_, 'revision')
                end
                if isKey(obj.props_, 'any')
                    obj.props_('any') = flywheel.ModelBase.cellmap(@flywheel.model.GearRuleCondition.ensureIsInstance, obj.props_('any'));
                end
                if isKey(obj.props_, 'all')
                    obj.props_('all') = flywheel.ModelBase.cellmap(@flywheel.model.GearRuleCondition.ensureIsInstance, obj.props_('all'));
                end
                if isKey(obj.props_, 'not')
                    obj.props_('not') = flywheel.ModelBase.cellmap(@flywheel.model.GearRuleCondition.ensureIsInstance, obj.props_('not'));
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'disabled')
                end
                if isKey(obj.props_, 'compute_provider_id')
                end
                if isKey(obj.props_, 'last_modified_by')
                    obj.props_('last_modified_by') =  flywheel.model.Origin.ensureIsInstance(obj.props_('last_modified_by'));
                end
                if isKey(obj.props_, 'triggering_input')
                end
            end
        end
    end
end
