% GearSaveSubmission - Confirmation of gear upload
%
% GearSaveSubmission Properties:
%    ticket   - Ticket id returned from prepare-add
%    repo     - The identification of this gear.
%    pointer  - Checksum of the docker image
%
% GearSaveSubmission Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GearSaveSubmission < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'ticket', 'repo', 'pointer' }, ...
            { 'ticket', 'repo', 'pointer' });
    end
    properties(Dependent)
        ticket
        repo
        pointer
    end
    methods
        function obj = GearSaveSubmission(varargin)
            obj@flywheel.ModelBase(flywheel.model.GearSaveSubmission.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'ticket', []);
                addParameter(p, 'repo', []);
                addParameter(p, 'pointer', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.ticket)
                    obj.props_('ticket') = p.Results.ticket;
                end
                if ~isempty(p.Results.repo)
                    obj.props_('repo') = p.Results.repo;
                end
                if ~isempty(p.Results.pointer)
                    obj.props_('pointer') = p.Results.pointer;
                end
            end
        end
        function result = get.ticket(obj)
            if ismethod(obj, 'get_ticket')
                result = obj.get_ticket();
            else
                if isKey(obj.props_, 'ticket')
                    result = obj.props_('ticket');
                else
                    result = [];
                end
            end
        end
        function obj = set.ticket(obj, value)
            obj.props_('ticket') = value;
        end
        function result = get.repo(obj)
            if ismethod(obj, 'get_repo')
                result = obj.get_repo();
            else
                if isKey(obj.props_, 'repo')
                    result = obj.props_('repo');
                else
                    result = [];
                end
            end
        end
        function obj = set.repo(obj, value)
            obj.props_('repo') = value;
        end
        function result = get.pointer(obj)
            if ismethod(obj, 'get_pointer')
                result = obj.get_pointer();
            else
                if isKey(obj.props_, 'pointer')
                    result = obj.props_('pointer');
                else
                    result = [];
                end
            end
        end
        function obj = set.pointer(obj, value)
            obj.props_('pointer') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'ticket')
                result('ticket') = flywheel.ModelBase.serializeValue(obj.props_('ticket'), 'char');
            end
            if isKey(obj.props_, 'repo')
                result('repo') = flywheel.ModelBase.serializeValue(obj.props_('repo'), 'char');
            end
            if isKey(obj.props_, 'pointer')
                result('pointer') = flywheel.ModelBase.serializeValue(obj.props_('pointer'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'ticket')
                result.ticket = obj.props_('ticket');
            else
                result.ticket = [];
            end
            if isKey(obj.props_, 'repo')
                result.repo = obj.props_('repo');
            else
                result.repo = [];
            end
            if isKey(obj.props_, 'pointer')
                result.pointer = obj.props_('pointer');
            else
                result.pointer = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'ticket')
                    propList.ticket = obj.props_('ticket');
                else
                    propList.ticket = [];
                end
                if isKey(obj.props_, 'repo')
                    propList.repo = obj.props_('repo');
                else
                    propList.repo = [];
                end
                if isKey(obj.props_, 'pointer')
                    propList.pointer = obj.props_('pointer');
                else
                    propList.pointer = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GearSaveSubmission;
            if isfield(json, 'ticket')
                obj.props_('ticket') = flywheel.ModelBase.deserializeValue(json.ticket, 'char');
            end
            if isfield(json, 'repo')
                obj.props_('repo') = flywheel.ModelBase.deserializeValue(json.repo, 'char');
            end
            if isfield(json, 'pointer')
                obj.props_('pointer') = flywheel.ModelBase.deserializeValue(json.pointer, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GearSaveSubmission')
                    obj = flywheel.model.GearSaveSubmission(obj);
                end
                if isKey(obj.props_, 'ticket')
                end
                if isKey(obj.props_, 'repo')
                end
                if isKey(obj.props_, 'pointer')
                end
            end
        end
    end
end
