% GearSeriesUpdate - Represents GearSeries attributes that can be modified via PUT  Attributes:     is_restricted: (Optional[bool]): if False, the gear can be accessed         site-wide. If True, `permissions` will be evaluated to determine         gear access.
%
% GearSeriesUpdate Properties:
%    isRestricted 
%
% GearSeriesUpdate Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GearSeriesUpdate < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'isRestricted' }, ...
            { 'is_restricted' });
    end
    properties(Dependent)
        isRestricted
    end
    methods
        function obj = GearSeriesUpdate(varargin)
            obj@flywheel.ModelBase(flywheel.model.GearSeriesUpdate.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'isRestricted', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.isRestricted)
                    obj.props_('is_restricted') = p.Results.isRestricted;
                end
            end
        end
        function result = get.isRestricted(obj)
            if ismethod(obj, 'get_isRestricted')
                result = obj.get_isRestricted();
            else
                if isKey(obj.props_, 'is_restricted')
                    result = obj.props_('is_restricted');
                else
                    result = [];
                end
            end
        end
        function obj = set.isRestricted(obj, value)
            obj.props_('is_restricted') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'is_restricted')
                result('is_restricted') = flywheel.ModelBase.serializeValue(obj.props_('is_restricted'), 'logical');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'is_restricted')
                result.isRestricted = obj.props_('is_restricted');
            else
                result.isRestricted = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'is_restricted')
                    propList.isRestricted = obj.props_('is_restricted');
                else
                    propList.isRestricted = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GearSeriesUpdate;
            if isfield(json, 'is_restricted')
                obj.props_('is_restricted') = flywheel.ModelBase.deserializeValue(json.is_restricted, 'logical');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GearSeriesUpdate')
                    obj = flywheel.model.GearSeriesUpdate(obj);
                end
                if isKey(obj.props_, 'is_restricted')
                end
            end
        end
    end
end
