% GearSuggestionOutput
%
% GearSuggestionOutput Properties:
%    id       
%    contType 
%    label    
%    parents  
%    children 
%    files    
%
% GearSuggestionOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GearSuggestionOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'contType', 'label', 'parents', 'children', 'files' }, ...
            { '_id', 'cont_type', 'label', 'parents', 'children', 'files' });
    end
    properties(Dependent)
        id
        contType
        label
        parents
        children
        files
    end
    methods
        function obj = GearSuggestionOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.GearSuggestionOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'contType', []);
                addParameter(p, 'label', []);
                addParameter(p, 'parents', []);
                addParameter(p, 'children', []);
                addParameter(p, 'files', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.contType)
                    obj.props_('cont_type') = p.Results.contType;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.parents)
                    obj.props_('parents') = p.Results.parents;
                end
                if ~isempty(p.Results.children)
                    obj.props_('children') = p.Results.children;
                end
                if ~isempty(p.Results.files)
                    obj.props_('files') = p.Results.files;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.contType(obj)
            if ismethod(obj, 'get_contType')
                result = obj.get_contType();
            else
                if isKey(obj.props_, 'cont_type')
                    result = obj.props_('cont_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.contType(obj, value)
            obj.props_('cont_type') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.parents(obj)
            if ismethod(obj, 'get_parents')
                result = obj.get_parents();
            else
                if isKey(obj.props_, 'parents')
                    result = obj.props_('parents');
                else
                    result = [];
                end
            end
        end
        function obj = set.parents(obj, value)
            obj.props_('parents') = value;
        end
        function result = get.children(obj)
            if ismethod(obj, 'get_children')
                result = obj.get_children();
            else
                if isKey(obj.props_, 'children')
                    result = obj.props_('children');
                else
                    result = [];
                end
            end
        end
        function obj = set.children(obj, value)
            obj.props_('children') = value;
        end
        function result = get.files(obj)
            if ismethod(obj, 'get_files')
                result = obj.get_files();
            else
                if isKey(obj.props_, 'files')
                    result = obj.props_('files');
                else
                    result = [];
                end
            end
        end
        function obj = set.files(obj, value)
            obj.props_('files') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'cont_type')
                result('cont_type') = obj.props_('cont_type').toJson();
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'parents')
                result('parents') = flywheel.ModelBase.cellmap(@toJson, obj.props_('parents'));
            end
            if isKey(obj.props_, 'children')
                result('children') = flywheel.ModelBase.serializeValue(obj.props_('children'), 'containers.Map[String, vector[ContainerReferenceWithLabel]]');
            end
            if isKey(obj.props_, 'files')
                result('files') = flywheel.ModelBase.cellmap(@toJson, obj.props_('files'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'cont_type')
                result.contType = struct(obj.props_('cont_type'));
            else
                result.contType = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'parents')
                result.parents = flywheel.ModelBase.cellmap(@struct, obj.props_('parents'));
            else
                result.parents = [];
            end
            if isKey(obj.props_, 'children')
                result.children = obj.props_('children');
            else
                result.children = [];
            end
            if isKey(obj.props_, 'files')
                result.files = flywheel.ModelBase.cellmap(@struct, obj.props_('files'));
            else
                result.files = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'cont_type')
                    propList.contType = obj.props_('cont_type');
                else
                    propList.contType = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'parents')
                    propList.parents = obj.props_('parents');
                else
                    propList.parents = [];
                end
                if isKey(obj.props_, 'children')
                    propList.children = obj.props_('children');
                else
                    propList.children = [];
                end
                if isKey(obj.props_, 'files')
                    propList.files = obj.props_('files');
                else
                    propList.files = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GearSuggestionOutput;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'cont_type')
                obj.props_('cont_type') = flywheel.model.ContainerType.fromJson(json.cont_type, context);
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'parents')
                obj.props_('parents') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ContainerReferenceWithLabel.fromJson(x, context), json.parents);
            end
            if isfield(json, 'children')
                obj.props_('children') = flywheel.ModelBase.deserializeValue(json.children, 'containers.Map[String, vector[ContainerReferenceWithLabel]]');
            end
            if isfield(json, 'files')
                obj.props_('files') = flywheel.ModelBase.cellmap(@(x) flywheel.model.FileSuggestion.fromJson(x, context), json.files);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GearSuggestionOutput')
                    obj = flywheel.model.GearSuggestionOutput(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'cont_type')
                    obj.props_('cont_type') =  flywheel.model.ContainerType.ensureIsInstance(obj.props_('cont_type'));
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'parents')
                    obj.props_('parents') = flywheel.ModelBase.cellmap(@flywheel.model.ContainerReferenceWithLabel.ensureIsInstance, obj.props_('parents'));
                end
                if isKey(obj.props_, 'children')
                end
                if isKey(obj.props_, 'files')
                    obj.props_('files') = flywheel.ModelBase.cellmap(@flywheel.model.FileSuggestion.ensureIsInstance, obj.props_('files'));
                end
            end
        end
    end
end
