% GoogleAuthOut
%
% GoogleAuthOut Properties:
%    idEndpoint      
%    clientId        
%    tokenEndpoint   
%    verifyEndpoint  
%    refreshEndpoint 
%    authEndpoint    
%
% GoogleAuthOut Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GoogleAuthOut < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'idEndpoint', 'clientId', 'tokenEndpoint', 'verifyEndpoint', 'refreshEndpoint', 'authEndpoint' }, ...
            { 'id_endpoint', 'client_id', 'token_endpoint', 'verify_endpoint', 'refresh_endpoint', 'auth_endpoint' });
    end
    properties(Dependent)
        idEndpoint
        clientId
        tokenEndpoint
        verifyEndpoint
        refreshEndpoint
        authEndpoint
    end
    methods
        function obj = GoogleAuthOut(varargin)
            obj@flywheel.ModelBase(flywheel.model.GoogleAuthOut.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'idEndpoint', &#x27;https://www.googleapis.com/oauth2/v3/userinfo&#x27;);
                addParameter(p, 'clientId', &#x27;979703271380-q85tbsupddmb7996q30244368r7e54lr.apps.googleusercontent.com&#x27;);
                addParameter(p, 'tokenEndpoint', &#x27;https://accounts.google.com/o/oauth2/token&#x27;);
                addParameter(p, 'verifyEndpoint', &#x27;https://www.googleapis.com/oauth2/v1/tokeninfo&#x27;);
                addParameter(p, 'refreshEndpoint', &#x27;https://www.googleapis.com/oauth2/v4/token&#x27;);
                addParameter(p, 'authEndpoint', &#x27;https://accounts.google.com/o/oauth2/auth&#x27;);

                parse(p, varargin{:});

                if ~isempty(p.Results.idEndpoint)
                    obj.props_('id_endpoint') = p.Results.idEndpoint;
                end
                if ~isempty(p.Results.clientId)
                    obj.props_('client_id') = p.Results.clientId;
                end
                if ~isempty(p.Results.tokenEndpoint)
                    obj.props_('token_endpoint') = p.Results.tokenEndpoint;
                end
                if ~isempty(p.Results.verifyEndpoint)
                    obj.props_('verify_endpoint') = p.Results.verifyEndpoint;
                end
                if ~isempty(p.Results.refreshEndpoint)
                    obj.props_('refresh_endpoint') = p.Results.refreshEndpoint;
                end
                if ~isempty(p.Results.authEndpoint)
                    obj.props_('auth_endpoint') = p.Results.authEndpoint;
                end
            end
        end
        function result = get.idEndpoint(obj)
            if ismethod(obj, 'get_idEndpoint')
                result = obj.get_idEndpoint();
            else
                if isKey(obj.props_, 'id_endpoint')
                    result = obj.props_('id_endpoint');
                else
                    result = [];
                end
            end
        end
        function obj = set.idEndpoint(obj, value)
            obj.props_('id_endpoint') = value;
        end
        function result = get.clientId(obj)
            if ismethod(obj, 'get_clientId')
                result = obj.get_clientId();
            else
                if isKey(obj.props_, 'client_id')
                    result = obj.props_('client_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.clientId(obj, value)
            obj.props_('client_id') = value;
        end
        function result = get.tokenEndpoint(obj)
            if ismethod(obj, 'get_tokenEndpoint')
                result = obj.get_tokenEndpoint();
            else
                if isKey(obj.props_, 'token_endpoint')
                    result = obj.props_('token_endpoint');
                else
                    result = [];
                end
            end
        end
        function obj = set.tokenEndpoint(obj, value)
            obj.props_('token_endpoint') = value;
        end
        function result = get.verifyEndpoint(obj)
            if ismethod(obj, 'get_verifyEndpoint')
                result = obj.get_verifyEndpoint();
            else
                if isKey(obj.props_, 'verify_endpoint')
                    result = obj.props_('verify_endpoint');
                else
                    result = [];
                end
            end
        end
        function obj = set.verifyEndpoint(obj, value)
            obj.props_('verify_endpoint') = value;
        end
        function result = get.refreshEndpoint(obj)
            if ismethod(obj, 'get_refreshEndpoint')
                result = obj.get_refreshEndpoint();
            else
                if isKey(obj.props_, 'refresh_endpoint')
                    result = obj.props_('refresh_endpoint');
                else
                    result = [];
                end
            end
        end
        function obj = set.refreshEndpoint(obj, value)
            obj.props_('refresh_endpoint') = value;
        end
        function result = get.authEndpoint(obj)
            if ismethod(obj, 'get_authEndpoint')
                result = obj.get_authEndpoint();
            else
                if isKey(obj.props_, 'auth_endpoint')
                    result = obj.props_('auth_endpoint');
                else
                    result = [];
                end
            end
        end
        function obj = set.authEndpoint(obj, value)
            obj.props_('auth_endpoint') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'id_endpoint')
                result('id_endpoint') = flywheel.ModelBase.serializeValue(obj.props_('id_endpoint'), 'char');
            end
            if isKey(obj.props_, 'client_id')
                result('client_id') = flywheel.ModelBase.serializeValue(obj.props_('client_id'), 'char');
            end
            if isKey(obj.props_, 'token_endpoint')
                result('token_endpoint') = flywheel.ModelBase.serializeValue(obj.props_('token_endpoint'), 'char');
            end
            if isKey(obj.props_, 'verify_endpoint')
                result('verify_endpoint') = flywheel.ModelBase.serializeValue(obj.props_('verify_endpoint'), 'char');
            end
            if isKey(obj.props_, 'refresh_endpoint')
                result('refresh_endpoint') = flywheel.ModelBase.serializeValue(obj.props_('refresh_endpoint'), 'char');
            end
            if isKey(obj.props_, 'auth_endpoint')
                result('auth_endpoint') = flywheel.ModelBase.serializeValue(obj.props_('auth_endpoint'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'id_endpoint')
                result.idEndpoint = obj.props_('id_endpoint');
            else
                result.idEndpoint = [];
            end
            if isKey(obj.props_, 'client_id')
                result.clientId = obj.props_('client_id');
            else
                result.clientId = [];
            end
            if isKey(obj.props_, 'token_endpoint')
                result.tokenEndpoint = obj.props_('token_endpoint');
            else
                result.tokenEndpoint = [];
            end
            if isKey(obj.props_, 'verify_endpoint')
                result.verifyEndpoint = obj.props_('verify_endpoint');
            else
                result.verifyEndpoint = [];
            end
            if isKey(obj.props_, 'refresh_endpoint')
                result.refreshEndpoint = obj.props_('refresh_endpoint');
            else
                result.refreshEndpoint = [];
            end
            if isKey(obj.props_, 'auth_endpoint')
                result.authEndpoint = obj.props_('auth_endpoint');
            else
                result.authEndpoint = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'id_endpoint')
                    propList.idEndpoint = obj.props_('id_endpoint');
                else
                    propList.idEndpoint = [];
                end
                if isKey(obj.props_, 'client_id')
                    propList.clientId = obj.props_('client_id');
                else
                    propList.clientId = [];
                end
                if isKey(obj.props_, 'token_endpoint')
                    propList.tokenEndpoint = obj.props_('token_endpoint');
                else
                    propList.tokenEndpoint = [];
                end
                if isKey(obj.props_, 'verify_endpoint')
                    propList.verifyEndpoint = obj.props_('verify_endpoint');
                else
                    propList.verifyEndpoint = [];
                end
                if isKey(obj.props_, 'refresh_endpoint')
                    propList.refreshEndpoint = obj.props_('refresh_endpoint');
                else
                    propList.refreshEndpoint = [];
                end
                if isKey(obj.props_, 'auth_endpoint')
                    propList.authEndpoint = obj.props_('auth_endpoint');
                else
                    propList.authEndpoint = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GoogleAuthOut;
            if isfield(json, 'id_endpoint')
                obj.props_('id_endpoint') = flywheel.ModelBase.deserializeValue(json.id_endpoint, 'char');
            end
            if isfield(json, 'client_id')
                obj.props_('client_id') = flywheel.ModelBase.deserializeValue(json.client_id, 'char');
            end
            if isfield(json, 'token_endpoint')
                obj.props_('token_endpoint') = flywheel.ModelBase.deserializeValue(json.token_endpoint, 'char');
            end
            if isfield(json, 'verify_endpoint')
                obj.props_('verify_endpoint') = flywheel.ModelBase.deserializeValue(json.verify_endpoint, 'char');
            end
            if isfield(json, 'refresh_endpoint')
                obj.props_('refresh_endpoint') = flywheel.ModelBase.deserializeValue(json.refresh_endpoint, 'char');
            end
            if isfield(json, 'auth_endpoint')
                obj.props_('auth_endpoint') = flywheel.ModelBase.deserializeValue(json.auth_endpoint, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GoogleAuthOut')
                    obj = flywheel.model.GoogleAuthOut(obj);
                end
                if isKey(obj.props_, 'id_endpoint')
                end
                if isKey(obj.props_, 'client_id')
                end
                if isKey(obj.props_, 'token_endpoint')
                end
                if isKey(obj.props_, 'verify_endpoint')
                end
                if isKey(obj.props_, 'refresh_endpoint')
                end
                if isKey(obj.props_, 'auth_endpoint')
                end
            end
        end
    end
end
