% GroupUpdate
%
% GroupUpdate Properties:
%    label     
%    providers 
%    editions  
%    modified  
%
% GroupUpdate Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef GroupUpdate < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'providers', 'editions', 'modified' }, ...
            { 'label', 'providers', 'editions', 'modified' });
    end
    properties(Dependent)
        label
        providers
        editions
        modified
    end
    methods
        function obj = GroupUpdate(varargin)
            obj@flywheel.ModelBase(flywheel.model.GroupUpdate.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'providers', []);
                addParameter(p, 'editions', []);
                addParameter(p, 'modified', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.providers)
                    obj.props_('providers') = p.Results.providers;
                end
                if ~isempty(p.Results.editions)
                    obj.props_('editions') = p.Results.editions;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.providers(obj)
            if ismethod(obj, 'get_providers')
                result = obj.get_providers();
            else
                if isKey(obj.props_, 'providers')
                    result = obj.props_('providers');
                else
                    result = [];
                end
            end
        end
        function obj = set.providers(obj, value)
            obj.props_('providers') = value;
        end
        function result = get.editions(obj)
            if ismethod(obj, 'get_editions')
                result = obj.get_editions();
            else
                if isKey(obj.props_, 'editions')
                    result = obj.props_('editions');
                else
                    result = [];
                end
            end
        end
        function obj = set.editions(obj, value)
            obj.props_('editions') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'providers')
                result('providers') = obj.props_('providers').toJson();
            end
            if isKey(obj.props_, 'editions')
                result('editions') = obj.props_('editions').toJson();
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'providers')
                result.providers = struct(obj.props_('providers'));
            else
                result.providers = [];
            end
            if isKey(obj.props_, 'editions')
                result.editions = struct(obj.props_('editions'));
            else
                result.editions = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'providers')
                    propList.providers = obj.props_('providers');
                else
                    propList.providers = [];
                end
                if isKey(obj.props_, 'editions')
                    propList.editions = obj.props_('editions');
                else
                    propList.editions = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.GroupUpdate;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'providers')
                obj.props_('providers') = flywheel.model.Providers.fromJson(json.providers, context);
            end
            if isfield(json, 'editions')
                obj.props_('editions') = flywheel.model.Edition.fromJson(json.editions, context);
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.GroupUpdate')
                    obj = flywheel.model.GroupUpdate(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'providers')
                    obj.props_('providers') =  flywheel.model.Providers.ensureIsInstance(obj.props_('providers'));
                end
                if isKey(obj.props_, 'editions')
                    obj.props_('editions') =  flywheel.model.Edition.ensureIsInstance(obj.props_('editions'));
                end
                if isKey(obj.props_, 'modified')
                end
            end
        end
    end
end
