% Info
%
% Info Properties:
%    set     
%    delete  
%    replace 
%
% Info Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Info < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'set', 'delete', 'replace' }, ...
            { 'set', 'delete', 'replace' });
    end
    properties(Dependent)
        set
        delete
        replace
    end
    methods
        function obj = Info(varargin)
            obj@flywheel.ModelBase(flywheel.model.Info.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'set', []);
                addParameter(p, 'delete', []);
                addParameter(p, 'replace', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.set)
                    obj.props_('set') = p.Results.set;
                end
                if ~isempty(p.Results.delete)
                    obj.props_('delete') = p.Results.delete;
                end
                if ~isempty(p.Results.replace)
                    obj.props_('replace') = p.Results.replace;
                end
            end
        end
        function result = get.set(obj)
            if ismethod(obj, 'get_set')
                result = obj.get_set();
            else
                if isKey(obj.props_, 'set')
                    result = obj.props_('set');
                else
                    result = [];
                end
            end
        end
        function obj = set.set(obj, value)
            obj.props_('set') = value;
        end
        function result = get.delete(obj)
            if ismethod(obj, 'get_delete')
                result = obj.get_delete();
            else
                if isKey(obj.props_, 'delete')
                    result = obj.props_('delete');
                else
                    result = [];
                end
            end
        end
        function obj = set.delete(obj, value)
            obj.props_('delete') = value;
        end
        function result = get.replace(obj)
            if ismethod(obj, 'get_replace')
                result = obj.get_replace();
            else
                if isKey(obj.props_, 'replace')
                    result = obj.props_('replace');
                else
                    result = [];
                end
            end
        end
        function obj = set.replace(obj, value)
            obj.props_('replace') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'set')
                result('set') = flywheel.ModelBase.serializeValue(obj.props_('set'), 'containers.Map');
            end
            if isKey(obj.props_, 'delete')
                result('delete') = flywheel.ModelBase.serializeValue(obj.props_('delete'), 'vector[char]');
            end
            if isKey(obj.props_, 'replace')
                result('replace') = flywheel.ModelBase.serializeValue(obj.props_('replace'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'set')
                result.set = obj.props_('set');
            else
                result.set = [];
            end
            if isKey(obj.props_, 'delete')
                result.delete = obj.props_('delete');
            else
                result.delete = [];
            end
            if isKey(obj.props_, 'replace')
                result.replace = obj.props_('replace');
            else
                result.replace = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'set')
                    propList.set = obj.props_('set');
                else
                    propList.set = [];
                end
                if isKey(obj.props_, 'delete')
                    propList.delete = obj.props_('delete');
                else
                    propList.delete = [];
                end
                if isKey(obj.props_, 'replace')
                    propList.replace = obj.props_('replace');
                else
                    propList.replace = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Info;
            if isfield(json, 'set')
                obj.props_('set') = flywheel.ModelBase.deserializeValue(json.set, 'containers.Map');
            end
            if isfield(json, 'delete')
                obj.props_('delete') = flywheel.ModelBase.deserializeValue(json.delete, 'vector[char]');
            end
            if isfield(json, 'replace')
                obj.props_('replace') = flywheel.ModelBase.deserializeValue(json.replace, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Info')
                    obj = flywheel.model.Info(obj);
                end
                if isKey(obj.props_, 'set')
                end
                if isKey(obj.props_, 'delete')
                end
                if isKey(obj.props_, 'replace')
                end
            end
        end
    end
end
