% IngressProvider - Provider input model--no relation to Ingress the Minikube add-on
%
% IngressProvider Properties:
%    label         
%    providerClass 
%    providerType  
%    creds         
%    config        
%    accessType    
%
% IngressProvider Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef IngressProvider < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'providerClass', 'providerType', 'creds', 'config', 'accessType' }, ...
            { 'label', 'provider_class', 'provider_type', 'creds', 'config', 'access_type' });
    end
    properties(Dependent)
        label
        providerClass
        providerType
        creds
        config
        accessType
    end
    methods
        function obj = IngressProvider(varargin)
            obj@flywheel.ModelBase(flywheel.model.IngressProvider.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'providerClass', []);
                addParameter(p, 'providerType', []);
                addParameter(p, 'creds', []);
                addParameter(p, 'config', []);
                addParameter(p, 'accessType', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.providerClass)
                    obj.props_('provider_class') = p.Results.providerClass;
                end
                if ~isempty(p.Results.providerType)
                    obj.props_('provider_type') = p.Results.providerType;
                end
                if ~isempty(p.Results.creds)
                    obj.props_('creds') = p.Results.creds;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
                if ~isempty(p.Results.accessType)
                    obj.props_('access_type') = p.Results.accessType;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.providerClass(obj)
            if ismethod(obj, 'get_providerClass')
                result = obj.get_providerClass();
            else
                if isKey(obj.props_, 'provider_class')
                    result = obj.props_('provider_class');
                else
                    result = [];
                end
            end
        end
        function obj = set.providerClass(obj, value)
            obj.props_('provider_class') = value;
        end
        function result = get.providerType(obj)
            if ismethod(obj, 'get_providerType')
                result = obj.get_providerType();
            else
                if isKey(obj.props_, 'provider_type')
                    result = obj.props_('provider_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.providerType(obj, value)
            obj.props_('provider_type') = value;
        end
        function result = get.creds(obj)
            if ismethod(obj, 'get_creds')
                result = obj.get_creds();
            else
                if isKey(obj.props_, 'creds')
                    result = obj.props_('creds');
                else
                    result = [];
                end
            end
        end
        function obj = set.creds(obj, value)
            obj.props_('creds') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = get.accessType(obj)
            if ismethod(obj, 'get_accessType')
                result = obj.get_accessType();
            else
                if isKey(obj.props_, 'access_type')
                    result = obj.props_('access_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.accessType(obj, value)
            obj.props_('access_type') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'provider_class')
                result('provider_class') = obj.props_('provider_class').toJson();
            end
            if isKey(obj.props_, 'provider_type')
                result('provider_type') = obj.props_('provider_type').toJson();
            end
            if isKey(obj.props_, 'creds')
                result('creds') = flywheel.ModelBase.serializeValue(obj.props_('creds'), 'containers.Map');
            end
            if isKey(obj.props_, 'config')
                result('config') = flywheel.ModelBase.serializeValue(obj.props_('config'), 'containers.Map');
            end
            if isKey(obj.props_, 'access_type')
                result('access_type') = obj.props_('access_type').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'provider_class')
                result.providerClass = struct(obj.props_('provider_class'));
            else
                result.providerClass = [];
            end
            if isKey(obj.props_, 'provider_type')
                result.providerType = struct(obj.props_('provider_type'));
            else
                result.providerType = [];
            end
            if isKey(obj.props_, 'creds')
                result.creds = obj.props_('creds');
            else
                result.creds = [];
            end
            if isKey(obj.props_, 'config')
                result.config = obj.props_('config');
            else
                result.config = [];
            end
            if isKey(obj.props_, 'access_type')
                result.accessType = struct(obj.props_('access_type'));
            else
                result.accessType = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'provider_class')
                    propList.providerClass = obj.props_('provider_class');
                else
                    propList.providerClass = [];
                end
                if isKey(obj.props_, 'provider_type')
                    propList.providerType = obj.props_('provider_type');
                else
                    propList.providerType = [];
                end
                if isKey(obj.props_, 'creds')
                    propList.creds = obj.props_('creds');
                else
                    propList.creds = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                if isKey(obj.props_, 'access_type')
                    propList.accessType = obj.props_('access_type');
                else
                    propList.accessType = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.IngressProvider;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'provider_class')
                obj.props_('provider_class') = flywheel.model.ProviderClass.fromJson(json.provider_class, context);
            end
            if isfield(json, 'provider_type')
                obj.props_('provider_type') = flywheel.model.ProviderType.fromJson(json.provider_type, context);
            end
            if isfield(json, 'creds')
                obj.props_('creds') = flywheel.ModelBase.deserializeValue(json.creds, 'containers.Map');
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.ModelBase.deserializeValue(json.config, 'containers.Map');
            end
            if isfield(json, 'access_type')
                obj.props_('access_type') = flywheel.model.ProviderAccessType.fromJson(json.access_type, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.IngressProvider')
                    obj = flywheel.model.IngressProvider(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'provider_class')
                    obj.props_('provider_class') =  flywheel.model.ProviderClass.ensureIsInstance(obj.props_('provider_class'));
                end
                if isKey(obj.props_, 'provider_type')
                    obj.props_('provider_type') =  flywheel.model.ProviderType.ensureIsInstance(obj.props_('provider_type'));
                end
                if isKey(obj.props_, 'creds')
                end
                if isKey(obj.props_, 'config')
                end
                if isKey(obj.props_, 'access_type')
                    obj.props_('access_type') =  flywheel.model.ProviderAccessType.ensureIsInstance(obj.props_('access_type'));
                end
            end
        end
    end
end
