% IngressSiteSettings
%
% IngressSiteSettings Properties:
%    centerGears 
%    providers   
%    ldapSync    
%    viewerApps  
%    deidProfile 
%
% IngressSiteSettings Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef IngressSiteSettings < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'centerGears', 'providers', 'ldapSync', 'viewerApps', 'deidProfile' }, ...
            { 'center_gears', 'providers', 'ldap_sync', 'viewer_apps', 'deid_profile' });
    end
    properties(Dependent)
        centerGears
        providers
        ldapSync
        viewerApps
        deidProfile
    end
    methods
        function obj = IngressSiteSettings(varargin)
            obj@flywheel.ModelBase(flywheel.model.IngressSiteSettings.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'centerGears', []);
                addParameter(p, 'providers', []);
                addParameter(p, 'ldapSync', []);
                addParameter(p, 'viewerApps', []);
                addParameter(p, 'deidProfile', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.centerGears)
                    obj.props_('center_gears') = p.Results.centerGears;
                end
                if ~isempty(p.Results.providers)
                    obj.props_('providers') = p.Results.providers;
                end
                if ~isempty(p.Results.ldapSync)
                    obj.props_('ldap_sync') = p.Results.ldapSync;
                end
                if ~isempty(p.Results.viewerApps)
                    obj.props_('viewer_apps') = p.Results.viewerApps;
                end
                if ~isempty(p.Results.deidProfile)
                    obj.props_('deid_profile') = p.Results.deidProfile;
                end
            end
        end
        function result = get.centerGears(obj)
            if ismethod(obj, 'get_centerGears')
                result = obj.get_centerGears();
            else
                if isKey(obj.props_, 'center_gears')
                    result = obj.props_('center_gears');
                else
                    result = [];
                end
            end
        end
        function obj = set.centerGears(obj, value)
            obj.props_('center_gears') = value;
        end
        function result = get.providers(obj)
            if ismethod(obj, 'get_providers')
                result = obj.get_providers();
            else
                if isKey(obj.props_, 'providers')
                    result = obj.props_('providers');
                else
                    result = [];
                end
            end
        end
        function obj = set.providers(obj, value)
            obj.props_('providers') = value;
        end
        function result = get.ldapSync(obj)
            if ismethod(obj, 'get_ldapSync')
                result = obj.get_ldapSync();
            else
                if isKey(obj.props_, 'ldap_sync')
                    result = obj.props_('ldap_sync');
                else
                    result = [];
                end
            end
        end
        function obj = set.ldapSync(obj, value)
            obj.props_('ldap_sync') = value;
        end
        function result = get.viewerApps(obj)
            if ismethod(obj, 'get_viewerApps')
                result = obj.get_viewerApps();
            else
                if isKey(obj.props_, 'viewer_apps')
                    result = obj.props_('viewer_apps');
                else
                    result = [];
                end
            end
        end
        function obj = set.viewerApps(obj, value)
            obj.props_('viewer_apps') = value;
        end
        function result = get.deidProfile(obj)
            if ismethod(obj, 'get_deidProfile')
                result = obj.get_deidProfile();
            else
                if isKey(obj.props_, 'deid_profile')
                    result = obj.props_('deid_profile');
                else
                    result = [];
                end
            end
        end
        function obj = set.deidProfile(obj, value)
            obj.props_('deid_profile') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'center_gears')
                result('center_gears') = flywheel.ModelBase.serializeValue(obj.props_('center_gears'), 'vector[char]');
            end
            if isKey(obj.props_, 'providers')
                result('providers') = obj.props_('providers').toJson();
            end
            if isKey(obj.props_, 'ldap_sync')
                result('ldap_sync') = obj.props_('ldap_sync').toJson();
            end
            if isKey(obj.props_, 'viewer_apps')
                result('viewer_apps') = flywheel.ModelBase.cellmap(@toJson, obj.props_('viewer_apps'));
            end
            if isKey(obj.props_, 'deid_profile')
                result('deid_profile') = obj.props_('deid_profile').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'center_gears')
                result.centerGears = obj.props_('center_gears');
            else
                result.centerGears = [];
            end
            if isKey(obj.props_, 'providers')
                result.providers = struct(obj.props_('providers'));
            else
                result.providers = [];
            end
            if isKey(obj.props_, 'ldap_sync')
                result.ldapSync = struct(obj.props_('ldap_sync'));
            else
                result.ldapSync = [];
            end
            if isKey(obj.props_, 'viewer_apps')
                result.viewerApps = flywheel.ModelBase.cellmap(@struct, obj.props_('viewer_apps'));
            else
                result.viewerApps = [];
            end
            if isKey(obj.props_, 'deid_profile')
                result.deidProfile = struct(obj.props_('deid_profile'));
            else
                result.deidProfile = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'center_gears')
                    propList.centerGears = obj.props_('center_gears');
                else
                    propList.centerGears = [];
                end
                if isKey(obj.props_, 'providers')
                    propList.providers = obj.props_('providers');
                else
                    propList.providers = [];
                end
                if isKey(obj.props_, 'ldap_sync')
                    propList.ldapSync = obj.props_('ldap_sync');
                else
                    propList.ldapSync = [];
                end
                if isKey(obj.props_, 'viewer_apps')
                    propList.viewerApps = obj.props_('viewer_apps');
                else
                    propList.viewerApps = [];
                end
                if isKey(obj.props_, 'deid_profile')
                    propList.deidProfile = obj.props_('deid_profile');
                else
                    propList.deidProfile = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.IngressSiteSettings;
            if isfield(json, 'center_gears')
                obj.props_('center_gears') = flywheel.ModelBase.deserializeValue(json.center_gears, 'vector[char]');
            end
            if isfield(json, 'providers')
                obj.props_('providers') = flywheel.model.IngressProviders.fromJson(json.providers, context);
            end
            if isfield(json, 'ldap_sync')
                obj.props_('ldap_sync') = flywheel.model.LdapSyncConfig.fromJson(json.ldap_sync, context);
            end
            if isfield(json, 'viewer_apps')
                obj.props_('viewer_apps') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ViewerAppInput.fromJson(x, context), json.viewer_apps);
            end
            if isfield(json, 'deid_profile')
                obj.props_('deid_profile') = flywheel.model.AnyOfIngressSiteSettingsDeidProfile.fromJson(json.deid_profile, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.IngressSiteSettings')
                    obj = flywheel.model.IngressSiteSettings(obj);
                end
                if isKey(obj.props_, 'center_gears')
                end
                if isKey(obj.props_, 'providers')
                    obj.props_('providers') =  flywheel.model.IngressProviders.ensureIsInstance(obj.props_('providers'));
                end
                if isKey(obj.props_, 'ldap_sync')
                    obj.props_('ldap_sync') =  flywheel.model.LdapSyncConfig.ensureIsInstance(obj.props_('ldap_sync'));
                end
                if isKey(obj.props_, 'viewer_apps')
                    obj.props_('viewer_apps') = flywheel.ModelBase.cellmap(@flywheel.model.ViewerAppInput.ensureIsInstance, obj.props_('viewer_apps'));
                end
                if isKey(obj.props_, 'deid_profile')
                    obj.props_('deid_profile') =  flywheel.model.AnyOfIngressSiteSettingsDeidProfile.ensureIsInstance(obj.props_('deid_profile'));
                end
            end
        end
    end
end
