% IngressUpdateProvider
%
% IngressUpdateProvider Properties:
%    label  
%    creds  
%    config 
%
% IngressUpdateProvider Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef IngressUpdateProvider < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'creds', 'config' }, ...
            { 'label', 'creds', 'config' });
    end
    properties(Dependent)
        label
        creds
        config
    end
    methods
        function obj = IngressUpdateProvider(varargin)
            obj@flywheel.ModelBase(flywheel.model.IngressUpdateProvider.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'creds', []);
                addParameter(p, 'config', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.creds)
                    obj.props_('creds') = p.Results.creds;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.creds(obj)
            if ismethod(obj, 'get_creds')
                result = obj.get_creds();
            else
                if isKey(obj.props_, 'creds')
                    result = obj.props_('creds');
                else
                    result = [];
                end
            end
        end
        function obj = set.creds(obj, value)
            obj.props_('creds') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'creds')
                result('creds') = flywheel.ModelBase.serializeValue(obj.props_('creds'), 'containers.Map');
            end
            if isKey(obj.props_, 'config')
                result('config') = flywheel.ModelBase.serializeValue(obj.props_('config'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'creds')
                result.creds = obj.props_('creds');
            else
                result.creds = [];
            end
            if isKey(obj.props_, 'config')
                result.config = obj.props_('config');
            else
                result.config = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'creds')
                    propList.creds = obj.props_('creds');
                else
                    propList.creds = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.IngressUpdateProvider;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'creds')
                obj.props_('creds') = flywheel.ModelBase.deserializeValue(json.creds, 'containers.Map');
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.ModelBase.deserializeValue(json.config, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.IngressUpdateProvider')
                    obj = flywheel.model.IngressUpdateProvider(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'creds')
                end
                if isKey(obj.props_, 'config')
                end
            end
        end
    end
end
