% InputFilter
%
% InputFilter Properties:
%    tags  
%    types 
%    since 
%
% InputFilter Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef InputFilter < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'tags', 'types', 'since' }, ...
            { 'tags', 'types', 'since' });
    end
    properties(Dependent)
        tags
        types
        since
    end
    methods
        function obj = InputFilter(varargin)
            obj@flywheel.ModelBase(flywheel.model.InputFilter.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'tags', []);
                addParameter(p, 'types', []);
                addParameter(p, 'since', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.types)
                    obj.props_('types') = p.Results.types;
                end
                if ~isempty(p.Results.since)
                    obj.props_('since') = p.Results.since;
                end
            end
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.types(obj)
            if ismethod(obj, 'get_types')
                result = obj.get_types();
            else
                if isKey(obj.props_, 'types')
                    result = obj.props_('types');
                else
                    result = [];
                end
            end
        end
        function obj = set.types(obj, value)
            obj.props_('types') = value;
        end
        function result = get.since(obj)
            if ismethod(obj, 'get_since')
                result = obj.get_since();
            else
                if isKey(obj.props_, 'since')
                    result = obj.props_('since');
                else
                    result = [];
                end
            end
        end
        function obj = set.since(obj, value)
            obj.props_('since') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'tags')
                result('tags') = obj.props_('tags').toJson();
            end
            if isKey(obj.props_, 'types')
                result('types') = obj.props_('types').toJson();
            end
            if isKey(obj.props_, 'since')
                result('since') = flywheel.ModelBase.serializeValue(obj.props_('since'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'tags')
                result.tags = struct(obj.props_('tags'));
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'types')
                result.types = struct(obj.props_('types'));
            else
                result.types = [];
            end
            if isKey(obj.props_, 'since')
                result.since = obj.props_('since');
            else
                result.since = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'types')
                    propList.types = obj.props_('types');
                else
                    propList.types = [];
                end
                if isKey(obj.props_, 'since')
                    propList.since = obj.props_('since');
                else
                    propList.since = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.InputFilter;
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.model.FilterValues.fromJson(json.tags, context);
            end
            if isfield(json, 'types')
                obj.props_('types') = flywheel.model.FilterValues.fromJson(json.types, context);
            end
            if isfield(json, 'since')
                obj.props_('since') = flywheel.ModelBase.deserializeValue(json.since, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.InputFilter')
                    obj = flywheel.model.InputFilter(obj);
                end
                if isKey(obj.props_, 'tags')
                    obj.props_('tags') =  flywheel.model.FilterValues.ensureIsInstance(obj.props_('tags'));
                end
                if isKey(obj.props_, 'types')
                    obj.props_('types') =  flywheel.model.FilterValues.ensureIsInstance(obj.props_('types'));
                end
                if isKey(obj.props_, 'since')
                end
            end
        end
    end
end
