% InputJob
%
% InputJob Properties:
%    attempt           
%    priority          
%    batch             
%    origin            
%    computeProviderId 
%    destination       
%    gearId            
%    roleId            
%    inputs            
%    parents           
%    label             
%    previousJobId     
%    tags              
%    config            
%
% InputJob Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef InputJob < flywheel.ModelBase & flywheel.mixins.JobMixin
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'attempt', 'priority', 'batch', 'origin', 'computeProviderId', 'destination', 'gearId', 'roleId', 'inputs', 'parents', 'label', 'previousJobId', 'tags', 'config' }, ...
            { 'attempt', 'priority', 'batch', 'origin', 'compute_provider_id', 'destination', 'gear_id', 'role_id', 'inputs', 'parents', 'label', 'previous_job_id', 'tags', 'config' });
    end
    properties(Dependent)
        attempt
        priority
        batch
        origin
        computeProviderId
        destination
        gearId
        roleId
        inputs
        parents
        label
        previousJobId
        tags
        config
    end
    methods
        function obj = InputJob(varargin)
            obj@flywheel.ModelBase(flywheel.model.InputJob.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'attempt', 1);
                addParameter(p, 'priority', []);
                addParameter(p, 'batch', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'computeProviderId', []);
                addParameter(p, 'destination', []);
                addParameter(p, 'gearId', []);
                addParameter(p, 'roleId', []);
                addParameter(p, 'inputs', []);
                addParameter(p, 'parents', []);
                addParameter(p, 'label', &#x27;&#x27;);
                addParameter(p, 'previousJobId', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'config', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.attempt)
                    obj.props_('attempt') = p.Results.attempt;
                end
                if ~isempty(p.Results.priority)
                    obj.props_('priority') = p.Results.priority;
                end
                if ~isempty(p.Results.batch)
                    obj.props_('batch') = p.Results.batch;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.computeProviderId)
                    obj.props_('compute_provider_id') = p.Results.computeProviderId;
                end
                if ~isempty(p.Results.destination)
                    obj.props_('destination') = p.Results.destination;
                end
                if ~isempty(p.Results.gearId)
                    obj.props_('gear_id') = p.Results.gearId;
                end
                if ~isempty(p.Results.roleId)
                    obj.props_('role_id') = p.Results.roleId;
                end
                if ~isempty(p.Results.inputs)
                    obj.props_('inputs') = p.Results.inputs;
                end
                if ~isempty(p.Results.parents)
                    obj.props_('parents') = p.Results.parents;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.previousJobId)
                    obj.props_('previous_job_id') = p.Results.previousJobId;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
            end
        end
        function result = get.attempt(obj)
            if ismethod(obj, 'get_attempt')
                result = obj.get_attempt();
            else
                if isKey(obj.props_, 'attempt')
                    result = obj.props_('attempt');
                else
                    result = [];
                end
            end
        end
        function obj = set.attempt(obj, value)
            obj.props_('attempt') = value;
        end
        function result = get.priority(obj)
            if ismethod(obj, 'get_priority')
                result = obj.get_priority();
            else
                if isKey(obj.props_, 'priority')
                    result = obj.props_('priority');
                else
                    result = [];
                end
            end
        end
        function obj = set.priority(obj, value)
            obj.props_('priority') = value;
        end
        function result = get.batch(obj)
            if ismethod(obj, 'get_batch')
                result = obj.get_batch();
            else
                if isKey(obj.props_, 'batch')
                    result = obj.props_('batch');
                else
                    result = [];
                end
            end
        end
        function obj = set.batch(obj, value)
            obj.props_('batch') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.computeProviderId(obj)
            if ismethod(obj, 'get_computeProviderId')
                result = obj.get_computeProviderId();
            else
                if isKey(obj.props_, 'compute_provider_id')
                    result = obj.props_('compute_provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.computeProviderId(obj, value)
            obj.props_('compute_provider_id') = value;
        end
        function result = get.destination(obj)
            if ismethod(obj, 'get_destination')
                result = obj.get_destination();
            else
                if isKey(obj.props_, 'destination')
                    result = obj.props_('destination');
                else
                    result = [];
                end
            end
        end
        function obj = set.destination(obj, value)
            obj.props_('destination') = value;
        end
        function result = get.gearId(obj)
            if ismethod(obj, 'get_gearId')
                result = obj.get_gearId();
            else
                if isKey(obj.props_, 'gear_id')
                    result = obj.props_('gear_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearId(obj, value)
            obj.props_('gear_id') = value;
        end
        function result = get.roleId(obj)
            if ismethod(obj, 'get_roleId')
                result = obj.get_roleId();
            else
                if isKey(obj.props_, 'role_id')
                    result = obj.props_('role_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.roleId(obj, value)
            obj.props_('role_id') = value;
        end
        function result = get.inputs(obj)
            if ismethod(obj, 'get_inputs')
                result = obj.get_inputs();
            else
                if isKey(obj.props_, 'inputs')
                    result = obj.props_('inputs');
                else
                    result = [];
                end
            end
        end
        function obj = set.inputs(obj, value)
            obj.props_('inputs') = value;
        end
        function result = get.parents(obj)
            if ismethod(obj, 'get_parents')
                result = obj.get_parents();
            else
                if isKey(obj.props_, 'parents')
                    result = obj.props_('parents');
                else
                    result = [];
                end
            end
        end
        function obj = set.parents(obj, value)
            obj.props_('parents') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.previousJobId(obj)
            if ismethod(obj, 'get_previousJobId')
                result = obj.get_previousJobId();
            else
                if isKey(obj.props_, 'previous_job_id')
                    result = obj.props_('previous_job_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.previousJobId(obj, value)
            obj.props_('previous_job_id') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'attempt')
                result('attempt') = flywheel.ModelBase.serializeValue(obj.props_('attempt'), 'integer');
            end
            if isKey(obj.props_, 'priority')
                result('priority') = obj.props_('priority').toJson();
            end
            if isKey(obj.props_, 'batch')
                result('batch') = flywheel.ModelBase.serializeValue(obj.props_('batch'), 'char');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'compute_provider_id')
                result('compute_provider_id') = flywheel.ModelBase.serializeValue(obj.props_('compute_provider_id'), 'char');
            end
            if isKey(obj.props_, 'destination')
                result('destination') = obj.props_('destination').toJson();
            end
            if isKey(obj.props_, 'gear_id')
                result('gear_id') = flywheel.ModelBase.serializeValue(obj.props_('gear_id'), 'char');
            end
            if isKey(obj.props_, 'role_id')
                result('role_id') = flywheel.ModelBase.serializeValue(obj.props_('role_id'), 'char');
            end
            if isKey(obj.props_, 'inputs')
                result('inputs') = obj.props_('inputs').toJson();
            end
            if isKey(obj.props_, 'parents')
                result('parents') = obj.props_('parents').toJson();
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'previous_job_id')
                result('previous_job_id') = flywheel.ModelBase.serializeValue(obj.props_('previous_job_id'), 'char');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
            if isKey(obj.props_, 'config')
                result('config') = flywheel.ModelBase.serializeValue(obj.props_('config'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'attempt')
                result.attempt = obj.props_('attempt');
            else
                result.attempt = [];
            end
            if isKey(obj.props_, 'priority')
                result.priority = struct(obj.props_('priority'));
            else
                result.priority = [];
            end
            if isKey(obj.props_, 'batch')
                result.batch = obj.props_('batch');
            else
                result.batch = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'compute_provider_id')
                result.computeProviderId = obj.props_('compute_provider_id');
            else
                result.computeProviderId = [];
            end
            if isKey(obj.props_, 'destination')
                result.destination = struct(obj.props_('destination'));
            else
                result.destination = [];
            end
            if isKey(obj.props_, 'gear_id')
                result.gearId = obj.props_('gear_id');
            else
                result.gearId = [];
            end
            if isKey(obj.props_, 'role_id')
                result.roleId = obj.props_('role_id');
            else
                result.roleId = [];
            end
            if isKey(obj.props_, 'inputs')
                result.inputs = struct(obj.props_('inputs'));
            else
                result.inputs = [];
            end
            if isKey(obj.props_, 'parents')
                result.parents = struct(obj.props_('parents'));
            else
                result.parents = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'previous_job_id')
                result.previousJobId = obj.props_('previous_job_id');
            else
                result.previousJobId = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'config')
                result.config = obj.props_('config');
            else
                result.config = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'attempt')
                    propList.attempt = obj.props_('attempt');
                else
                    propList.attempt = [];
                end
                if isKey(obj.props_, 'priority')
                    propList.priority = obj.props_('priority');
                else
                    propList.priority = [];
                end
                if isKey(obj.props_, 'batch')
                    propList.batch = obj.props_('batch');
                else
                    propList.batch = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'compute_provider_id')
                    propList.computeProviderId = obj.props_('compute_provider_id');
                else
                    propList.computeProviderId = [];
                end
                if isKey(obj.props_, 'destination')
                    propList.destination = obj.props_('destination');
                else
                    propList.destination = [];
                end
                if isKey(obj.props_, 'gear_id')
                    propList.gearId = obj.props_('gear_id');
                else
                    propList.gearId = [];
                end
                if isKey(obj.props_, 'role_id')
                    propList.roleId = obj.props_('role_id');
                else
                    propList.roleId = [];
                end
                if isKey(obj.props_, 'inputs')
                    propList.inputs = obj.props_('inputs');
                else
                    propList.inputs = [];
                end
                if isKey(obj.props_, 'parents')
                    propList.parents = obj.props_('parents');
                else
                    propList.parents = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'previous_job_id')
                    propList.previousJobId = obj.props_('previous_job_id');
                else
                    propList.previousJobId = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.InputJob;
            if isfield(json, 'attempt')
                obj.props_('attempt') = flywheel.ModelBase.deserializeValue(json.attempt, 'integer');
            end
            if isfield(json, 'priority')
                obj.props_('priority') = flywheel.model.AllOfInputJobPriority.fromJson(json.priority, context);
            end
            if isfield(json, 'batch')
                obj.props_('batch') = flywheel.ModelBase.deserializeValue(json.batch, 'char');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'compute_provider_id')
                obj.props_('compute_provider_id') = flywheel.ModelBase.deserializeValue(json.compute_provider_id, 'char');
            end
            if isfield(json, 'destination')
                obj.props_('destination') = flywheel.model.ContainerReference.fromJson(json.destination, context);
            end
            if isfield(json, 'gear_id')
                obj.props_('gear_id') = flywheel.ModelBase.deserializeValue(json.gear_id, 'char');
            end
            if isfield(json, 'role_id')
                obj.props_('role_id') = flywheel.ModelBase.deserializeValue(json.role_id, 'char');
            end
            if isfield(json, 'inputs')
                obj.props_('inputs') = flywheel.model.Object.fromJson(json.inputs, context);
            end
            if isfield(json, 'parents')
                obj.props_('parents') = flywheel.model.JobParents.fromJson(json.parents, context);
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'previous_job_id')
                obj.props_('previous_job_id') = flywheel.ModelBase.deserializeValue(json.previous_job_id, 'char');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.ModelBase.deserializeValue(json.config, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.InputJob')
                    obj = flywheel.model.InputJob(obj);
                end
                if isKey(obj.props_, 'attempt')
                end
                if isKey(obj.props_, 'priority')
                    obj.props_('priority') =  flywheel.model.AllOfInputJobPriority.ensureIsInstance(obj.props_('priority'));
                end
                if isKey(obj.props_, 'batch')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'compute_provider_id')
                end
                if isKey(obj.props_, 'destination')
                    obj.props_('destination') =  flywheel.model.ContainerReference.ensureIsInstance(obj.props_('destination'));
                end
                if isKey(obj.props_, 'gear_id')
                end
                if isKey(obj.props_, 'role_id')
                end
                if isKey(obj.props_, 'inputs')
                    obj.props_('inputs') =  flywheel.model.Object.ensureIsInstance(obj.props_('inputs'));
                end
                if isKey(obj.props_, 'parents')
                    obj.props_('parents') =  flywheel.model.JobParents.ensureIsInstance(obj.props_('parents'));
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'previous_job_id')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'config')
                end
            end
        end
    end
end
