% InputJobProfile - Represents the input for jobs profile  Attributes:     elapsed_time_ms (Optional[int]): The runtime of the job,         in milliseconds     executor (Optional[ExecutorInfo]): The information about the job         executor, also known as engine     preparation_time_ms (Optional[int]): The length of time taken to         download gear container and inputs, in milliseconds     upload_time_ms (Optional[int]): The length of time taken to upload the         job's outputs, in milliseconds     versions (Optional[Dict[str, str]]): Version info of components         involved in job
%
% InputJobProfile Properties:
%    elapsedTimeMs     
%    executor          
%    preparationTimeMs 
%    uploadTimeMs      
%    versions          
%
% InputJobProfile Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef InputJobProfile < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'elapsedTimeMs', 'executor', 'preparationTimeMs', 'uploadTimeMs', 'versions' }, ...
            { 'elapsed_time_ms', 'executor', 'preparation_time_ms', 'upload_time_ms', 'versions' });
    end
    properties(Dependent)
        elapsedTimeMs
        executor
        preparationTimeMs
        uploadTimeMs
        versions
    end
    methods
        function obj = InputJobProfile(varargin)
            obj@flywheel.ModelBase(flywheel.model.InputJobProfile.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'elapsedTimeMs', []);
                addParameter(p, 'executor', []);
                addParameter(p, 'preparationTimeMs', []);
                addParameter(p, 'uploadTimeMs', []);
                addParameter(p, 'versions', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.elapsedTimeMs)
                    obj.props_('elapsed_time_ms') = p.Results.elapsedTimeMs;
                end
                if ~isempty(p.Results.executor)
                    obj.props_('executor') = p.Results.executor;
                end
                if ~isempty(p.Results.preparationTimeMs)
                    obj.props_('preparation_time_ms') = p.Results.preparationTimeMs;
                end
                if ~isempty(p.Results.uploadTimeMs)
                    obj.props_('upload_time_ms') = p.Results.uploadTimeMs;
                end
                if ~isempty(p.Results.versions)
                    obj.props_('versions') = p.Results.versions;
                end
            end
        end
        function result = get.elapsedTimeMs(obj)
            if ismethod(obj, 'get_elapsedTimeMs')
                result = obj.get_elapsedTimeMs();
            else
                if isKey(obj.props_, 'elapsed_time_ms')
                    result = obj.props_('elapsed_time_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.elapsedTimeMs(obj, value)
            obj.props_('elapsed_time_ms') = value;
        end
        function result = get.executor(obj)
            if ismethod(obj, 'get_executor')
                result = obj.get_executor();
            else
                if isKey(obj.props_, 'executor')
                    result = obj.props_('executor');
                else
                    result = [];
                end
            end
        end
        function obj = set.executor(obj, value)
            obj.props_('executor') = value;
        end
        function result = get.preparationTimeMs(obj)
            if ismethod(obj, 'get_preparationTimeMs')
                result = obj.get_preparationTimeMs();
            else
                if isKey(obj.props_, 'preparation_time_ms')
                    result = obj.props_('preparation_time_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.preparationTimeMs(obj, value)
            obj.props_('preparation_time_ms') = value;
        end
        function result = get.uploadTimeMs(obj)
            if ismethod(obj, 'get_uploadTimeMs')
                result = obj.get_uploadTimeMs();
            else
                if isKey(obj.props_, 'upload_time_ms')
                    result = obj.props_('upload_time_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.uploadTimeMs(obj, value)
            obj.props_('upload_time_ms') = value;
        end
        function result = get.versions(obj)
            if ismethod(obj, 'get_versions')
                result = obj.get_versions();
            else
                if isKey(obj.props_, 'versions')
                    result = obj.props_('versions');
                else
                    result = [];
                end
            end
        end
        function obj = set.versions(obj, value)
            obj.props_('versions') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'elapsed_time_ms')
                result('elapsed_time_ms') = flywheel.ModelBase.serializeValue(obj.props_('elapsed_time_ms'), 'integer');
            end
            if isKey(obj.props_, 'executor')
                result('executor') = obj.props_('executor').toJson();
            end
            if isKey(obj.props_, 'preparation_time_ms')
                result('preparation_time_ms') = flywheel.ModelBase.serializeValue(obj.props_('preparation_time_ms'), 'integer');
            end
            if isKey(obj.props_, 'upload_time_ms')
                result('upload_time_ms') = flywheel.ModelBase.serializeValue(obj.props_('upload_time_ms'), 'integer');
            end
            if isKey(obj.props_, 'versions')
                result('versions') = flywheel.ModelBase.serializeValue(obj.props_('versions'), 'containers.Map[String, char]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'elapsed_time_ms')
                result.elapsedTimeMs = obj.props_('elapsed_time_ms');
            else
                result.elapsedTimeMs = [];
            end
            if isKey(obj.props_, 'executor')
                result.executor = struct(obj.props_('executor'));
            else
                result.executor = [];
            end
            if isKey(obj.props_, 'preparation_time_ms')
                result.preparationTimeMs = obj.props_('preparation_time_ms');
            else
                result.preparationTimeMs = [];
            end
            if isKey(obj.props_, 'upload_time_ms')
                result.uploadTimeMs = obj.props_('upload_time_ms');
            else
                result.uploadTimeMs = [];
            end
            if isKey(obj.props_, 'versions')
                result.versions = obj.props_('versions');
            else
                result.versions = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'elapsed_time_ms')
                    propList.elapsedTimeMs = obj.props_('elapsed_time_ms');
                else
                    propList.elapsedTimeMs = [];
                end
                if isKey(obj.props_, 'executor')
                    propList.executor = obj.props_('executor');
                else
                    propList.executor = [];
                end
                if isKey(obj.props_, 'preparation_time_ms')
                    propList.preparationTimeMs = obj.props_('preparation_time_ms');
                else
                    propList.preparationTimeMs = [];
                end
                if isKey(obj.props_, 'upload_time_ms')
                    propList.uploadTimeMs = obj.props_('upload_time_ms');
                else
                    propList.uploadTimeMs = [];
                end
                if isKey(obj.props_, 'versions')
                    propList.versions = obj.props_('versions');
                else
                    propList.versions = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.InputJobProfile;
            if isfield(json, 'elapsed_time_ms')
                obj.props_('elapsed_time_ms') = flywheel.ModelBase.deserializeValue(json.elapsed_time_ms, 'integer');
            end
            if isfield(json, 'executor')
                obj.props_('executor') = flywheel.model.ExecutorInfo.fromJson(json.executor, context);
            end
            if isfield(json, 'preparation_time_ms')
                obj.props_('preparation_time_ms') = flywheel.ModelBase.deserializeValue(json.preparation_time_ms, 'integer');
            end
            if isfield(json, 'upload_time_ms')
                obj.props_('upload_time_ms') = flywheel.ModelBase.deserializeValue(json.upload_time_ms, 'integer');
            end
            if isfield(json, 'versions')
                obj.props_('versions') = flywheel.ModelBase.deserializeValue(json.versions, 'containers.Map[String, char]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.InputJobProfile')
                    obj = flywheel.model.InputJobProfile(obj);
                end
                if isKey(obj.props_, 'elapsed_time_ms')
                end
                if isKey(obj.props_, 'executor')
                    obj.props_('executor') =  flywheel.model.ExecutorInfo.ensureIsInstance(obj.props_('executor'));
                end
                if isKey(obj.props_, 'preparation_time_ms')
                end
                if isKey(obj.props_, 'upload_time_ms')
                end
                if isKey(obj.props_, 'versions')
                end
            end
        end
    end
end
